/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.blockentity.special;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.Clearable;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import xfacthd.framedblocks.api.block.blockentity.FramedBlockEntity;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.menu.FramedStorageMenu;

public class FramedStorageBlockEntity
extends FramedBlockEntity
implements MenuProvider,
Nameable,
Clearable {
    public static final Component TITLE = Utils.translate("title", "framed_secret_storage");
    private final ItemStackHandler itemHandler = new ItemStackHandler(36){

        protected void onContentsChanged(int slot) {
            FramedStorageBlockEntity.this.setChanged();
        }
    };
    private Component customName = null;

    public FramedStorageBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)FBContent.BE_TYPE_FRAMED_SECRET_STORAGE.value(), pos, state);
    }

    protected FramedStorageBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void open(ServerPlayer player) {
        player.openMenu((MenuProvider)this, this.worldPosition);
    }

    public boolean isUsableByPlayer(Player player) {
        if (this.level().getBlockEntity(this.worldPosition) != this) {
            return false;
        }
        return !(player.distanceToSqr((double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ() + 0.5) > 64.0);
    }

    public List<ItemStack> getDrops() {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            ItemStack stack = this.itemHandler.getStackInSlot(i);
            if (stack.isEmpty()) continue;
            drops.add(stack);
        }
        return drops;
    }

    public void clearContent() {
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            this.itemHandler.setStackInSlot(i, ItemStack.EMPTY);
        }
    }

    public int getAnalogOutputSignal() {
        int stacks = 0;
        float fullness = 0.0f;
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            ItemStack stack = this.itemHandler.getStackInSlot(i);
            if (stack.isEmpty()) continue;
            float sizeLimit = Math.min(this.itemHandler.getSlotLimit(i), stack.getMaxStackSize());
            fullness += (float)stack.getCount() / sizeLimit;
            ++stacks;
        }
        return Mth.floor((float)((fullness /= (float)this.itemHandler.getSlots()) * 14.0f)) + (stacks > 0 ? 1 : 0);
    }

    public IItemHandler getItemHandler() {
        return this.itemHandler;
    }

    public void setCustomName(Component customName) {
        this.customName = customName;
        this.setChangedWithoutSignalUpdate();
    }

    public Component getName() {
        return this.customName != null ? this.customName : this.getDefaultName();
    }

    public Component getCustomName() {
        return this.customName;
    }

    @Override
    public void saveAdditional(CompoundTag nbt, HolderLookup.Provider provider) {
        nbt.put("inventory", (Tag)this.itemHandler.serializeNBT(provider));
        if (this.customName != null) {
            nbt.putString("custom_name", Component.Serializer.toJson((Component)this.customName, (HolderLookup.Provider)provider));
        }
        super.saveAdditional(nbt, provider);
    }

    @Override
    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider provider) {
        super.loadAdditional(nbt, provider);
        this.itemHandler.deserializeNBT(provider, nbt.getCompound("inventory"));
        if (nbt.contains("custom_name", 8)) {
            this.customName = Component.Serializer.fromJson((String)nbt.getString("custom_name"), (HolderLookup.Provider)provider);
        }
    }

    protected Component getDefaultName() {
        return TITLE;
    }

    public final Component getDisplayName() {
        return this.getName();
    }

    public AbstractContainerMenu createMenu(int windowId, Inventory inv, Player player) {
        return new FramedStorageMenu(windowId, inv, this);
    }
}

