/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.compat.emi;

import com.google.common.base.Stopwatch;
import dev.emi.emi.api.EmiDragDropHandler;
import dev.emi.emi.api.EmiEntrypoint;
import dev.emi.emi.api.EmiExclusionArea;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.EmiStackProvider;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import java.util.List;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import xfacthd.framedblocks.FramedBlocks;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.client.screen.FramingSawScreen;
import xfacthd.framedblocks.client.screen.FramingSawWithEncoderScreen;
import xfacthd.framedblocks.client.screen.PoweredFramingSawScreen;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.compat.emi.FramedEmiRecipeHandler;
import xfacthd.framedblocks.common.compat.emi.FramingSawDragDropHandler;
import xfacthd.framedblocks.common.compat.emi.FramingSawEmiRecipe;
import xfacthd.framedblocks.common.compat.emi.FramingSawExclusionArea;
import xfacthd.framedblocks.common.compat.emi.FramingSawRecipeCategory;
import xfacthd.framedblocks.common.compat.emi.FramingSawStackProvider;
import xfacthd.framedblocks.common.compat.emi.PoweredFramingSawDragDropHandler;
import xfacthd.framedblocks.common.compat.emi.PoweredFramingSawStackProvider;
import xfacthd.framedblocks.common.config.ClientConfig;
import xfacthd.framedblocks.common.crafting.FramingSawRecipe;
import xfacthd.framedblocks.common.crafting.FramingSawRecipeCache;
import xfacthd.framedblocks.common.crafting.FramingSawRecipeCalculation;

@EmiEntrypoint
public final class FramedEmiPlugin
implements EmiPlugin {
    public static final ResourceLocation SAW_ID = Utils.rl("framing_saw");
    public static final EmiStack SAW_WORKSTATION = EmiStack.of((ItemLike)((ItemLike)FBContent.BLOCK_FRAMING_SAW.value()));
    private static final EmiStack POWERED_SAW_WORKSTATION = EmiStack.of((ItemLike)((ItemLike)FBContent.BLOCK_POWERED_FRAMING_SAW.value()));
    public static final EmiRecipeCategory SAW_CATEGORY = new FramingSawRecipeCategory((EmiRenderable)SAW_WORKSTATION, (EmiRenderable)SAW_WORKSTATION);
    private static final Set<Item> CUBE_ITEM = Set.of(((Block)FBContent.BLOCK_FRAMED_CUBE.value()).asItem());

    public void register(EmiRegistry registry) {
        registry.addCategory(SAW_CATEGORY);
        registry.addWorkstation(SAW_CATEGORY, (EmiIngredient)SAW_WORKSTATION);
        registry.addWorkstation(SAW_CATEGORY, (EmiIngredient)POWERED_SAW_WORKSTATION);
        registry.addRecipeHandler((MenuType)FBContent.MENU_TYPE_FRAMING_SAW.get(), new FramedEmiRecipeHandler());
        registry.addRecipeHandler((MenuType)FBContent.MENU_TYPE_POWERED_FRAMING_SAW.get(), new FramedEmiRecipeHandler());
        registry.addStackProvider(FramingSawScreen.class, (EmiStackProvider)new FramingSawStackProvider());
        registry.addStackProvider(PoweredFramingSawScreen.class, (EmiStackProvider)new PoweredFramingSawStackProvider());
        registry.addDragDropHandler(FramingSawWithEncoderScreen.class, (EmiDragDropHandler)new FramingSawDragDropHandler());
        registry.addDragDropHandler(PoweredFramingSawScreen.class, (EmiDragDropHandler)new PoweredFramingSawDragDropHandler());
        registry.addExclusionArea(FramingSawWithEncoderScreen.class, (EmiExclusionArea)new FramingSawExclusionArea());
        FramedEmiPlugin.registerRecipes(registry);
    }

    private static void registerRecipes(EmiRegistry registry) {
        FramedBlocks.LOGGER.debug("Registering framing saw recipes to EMI...");
        Stopwatch watch = Stopwatch.createStarted();
        int[] recipeCount = new int[1];
        FramingSawRecipeCache cache = FramingSawRecipeCache.get(true);
        Set<Item> inputItems = ClientConfig.VIEW.showAllRecipePermutationsInEmi() ? cache.getKnownItems() : CUBE_ITEM;
        cache.getRecipes().forEach(holder -> {
            FramingSawRecipe recipe = (FramingSawRecipe)holder.value();
            for (Item item : inputItems) {
                if (recipe.getResult().is(item)) continue;
                ItemStack inputStack = new ItemStack((ItemLike)item);
                SingleRecipeInput dummyInput = new SingleRecipeInput(inputStack);
                FramingSawRecipeCalculation calc = recipe.makeCraftingCalculation((RecipeInput)dummyInput, true);
                int outputCount = calc.getOutputCount();
                EmiStack input = EmiStack.of((ItemStack)inputStack, (long)calc.getInputCount());
                List<EmiIngredient> additives = recipe.getAdditives().stream().map(additive -> {
                    int addCount = additive.count() * (outputCount / recipe.getResult().getCount());
                    return EmiIngredient.of((Ingredient)additive.ingredient(), (long)addCount);
                }).toList();
                EmiStack output = EmiStack.of((ItemStack)recipe.getResult(), (long)outputCount);
                registry.addRecipe((EmiRecipe)FramingSawEmiRecipe.make((RecipeHolder<FramingSawRecipe>)holder, input, additives, output));
                recipeCount[0] = recipeCount[0] + 1;
            }
        });
        watch.stop();
        FramedBlocks.LOGGER.debug("Registered {} framing saw recipes to EMI in {}", (Object)recipeCount[0], (Object)watch);
    }

    static int compareRecipes(EmiRecipe recipeOne, EmiRecipe recipeTwo) {
        FramingSawEmiRecipe sawRecipeTwo;
        ItemStack resultTwo;
        FramingSawEmiRecipe sawRecipeOne;
        ItemStack resultOne;
        if (!(recipeOne instanceof FramingSawEmiRecipe) || (resultOne = (sawRecipeOne = (FramingSawEmiRecipe)recipeOne).getOutputInternal()).isEmpty()) {
            return 1;
        }
        if (!(recipeTwo instanceof FramingSawEmiRecipe) || (resultTwo = (sawRecipeTwo = (FramingSawEmiRecipe)recipeTwo).getOutputInternal()).isEmpty()) {
            return -1;
        }
        return FramingSawRecipeCache.sortRecipes(resultOne, resultTwo, sawRecipeOne.getResultType(), sawRecipeTwo.getResultType());
    }
}

