/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.compat.jade;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.level.block.Block;
import snownee.jade.api.IComponentProvider;
import snownee.jade.api.IWailaClientRegistration;
import snownee.jade.api.IWailaPlugin;
import snownee.jade.api.WailaPlugin;
import xfacthd.framedblocks.api.block.AbstractFramedBlock;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.common.block.interactive.FramedItemFrameBlock;
import xfacthd.framedblocks.common.compat.jade.FramedBlockComponentProvider;
import xfacthd.framedblocks.common.compat.jade.FramedItemFrameComponentProvider;

@WailaPlugin
public final class FramedJadePlugin
implements IWailaPlugin {
    public void registerClient(IWailaClientRegistration registration) {
        for (Class<? extends Block> target : FramedJadePlugin.collectTargetClasses()) {
            registration.registerBlockIcon((IComponentProvider)FramedBlockComponentProvider.INSTANCE, target);
            registration.registerBlockComponent((IComponentProvider)FramedBlockComponentProvider.INSTANCE, target);
        }
        registration.registerBlockIcon((IComponentProvider)FramedItemFrameComponentProvider.INSTANCE, FramedItemFrameBlock.class);
        registration.registerBlockComponent((IComponentProvider)FramedItemFrameComponentProvider.INSTANCE, FramedItemFrameBlock.class);
    }

    private static Set<Class<? extends Block>> collectTargetClasses() {
        HashSet<Class<? extends Block>> targets = new HashSet<Class<? extends Block>>();
        targets.add(AbstractFramedBlock.class);
        BuiltInRegistries.BLOCK.stream().filter(IFramedBlock.class::isInstance).filter(block -> !(block instanceof AbstractFramedBlock)).map(IFramedBlock.class::cast).map(block -> {
            Class<? extends Block> target = block.getJadeTargetClass();
            if (!target.isInstance(block)) {
                throw new IllegalArgumentException("Block '" + String.valueOf(block) + "' specifies invalid Jade target class '" + String.valueOf(target) + "'");
            }
            return target;
        }).forEach(targets::add);
        return targets;
    }
}

