/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.config;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.api.util.ConfigView;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.config.ExtConfigView;

public final class DevToolsConfig {
    public static final ExtConfigView.DevTools VIEW = (ExtConfigView.DevTools)ConfigView.DevTools.INSTANCE;
    private static final ModConfigSpec SPEC;
    private static final String KEY_DOUBLE_BLOCK_PART_DEBUG = "doubleBlockPartDebug";
    private static final String KEY_CONNECTION_DEBUG = "connectionDebug";
    private static final String KEY_QUAD_WINDING_DEBUG = "quadWindingDebug";
    private static final String KEY_STATE_MERGER_DEBUG = "stateMergerDebug";
    private static final String KEY_STATE_MERGER_DEBUG_FILTER = "stateMergerDebugFilter";
    private static final String KEY_OCCLUSION_SHAPE_DEBUG = "occlusionShapeDebug";
    public static final String TRANSLATION_DOUBLE_BLOCK_PART_DEBUG;
    public static final String TRANSLATION_CONNECTION_DEBUG;
    public static final String TRANSLATION_QUAD_WINDING_DEBUG;
    public static final String TRANSLATION_STATE_MERGER_DEBUG;
    public static final String TRANSLATION_STATE_MERGER_DEBUG_FILTER;
    public static final String TRANSLATION_OCCLUSION_SHAPE_DEBUG;
    private static final ModConfigSpec.BooleanValue DOUBLE_BLOCK_PART_DEBUG_VALUE;
    private static final ModConfigSpec.BooleanValue CONNECTION_DEBUG_VALUE;
    private static final ModConfigSpec.BooleanValue QUAD_WINDING_DEBUG_VALUE;
    private static final ModConfigSpec.BooleanValue STATE_MERGER_DEBUG_VALUE;
    private static final ModConfigSpec.ConfigValue<String> STATE_MERGER_DEBUG_FILTER_VALUE;
    private static final ModConfigSpec.BooleanValue OCCLUSION_SHAPE_DEBUG_VALUE;
    private static boolean doubleBlockPartDebug;
    private static boolean connectionDebug;
    private static boolean quadWindingDebug;
    private static boolean stateMergerDebug;
    private static Pattern stateMergerDebugFilter;
    private static boolean occlusionShapeDebug;

    public static void init(IEventBus modBus, ModContainer modContainer) {
        if (!FMLEnvironment.production) {
            modBus.addListener(event -> DevToolsConfig.onConfigReloaded((ModConfigEvent)event));
            modBus.addListener(event -> DevToolsConfig.onConfigReloaded((ModConfigEvent)event));
            modContainer.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)SPEC, "framedblocks-devtools.toml");
        }
    }

    private static boolean validateFilterPattern(Object value) {
        if (value instanceof String) {
            String string = (String)value;
            if (string.isBlank()) {
                return true;
            }
            try {
                Pattern.compile(string);
                return true;
            }
            catch (PatternSyntaxException e) {
                return false;
            }
        }
        return false;
    }

    private static String translate(String key) {
        return Utils.translateConfig("devtools", key);
    }

    private static void onConfigReloaded(ModConfigEvent event) {
        if (event.getConfig().getType() == ModConfig.Type.CLIENT && event.getConfig().getSpec() == SPEC) {
            doubleBlockPartDebug = (Boolean)DOUBLE_BLOCK_PART_DEBUG_VALUE.get();
            connectionDebug = (Boolean)CONNECTION_DEBUG_VALUE.get();
            quadWindingDebug = (Boolean)QUAD_WINDING_DEBUG_VALUE.get();
            stateMergerDebug = (Boolean)STATE_MERGER_DEBUG_VALUE.get();
            String filter = (String)STATE_MERGER_DEBUG_FILTER_VALUE.get();
            stateMergerDebugFilter = filter.isBlank() ? null : Pattern.compile(filter);
            occlusionShapeDebug = (Boolean)OCCLUSION_SHAPE_DEBUG_VALUE.get();
        }
    }

    private DevToolsConfig() {
    }

    static {
        TRANSLATION_DOUBLE_BLOCK_PART_DEBUG = DevToolsConfig.translate(KEY_DOUBLE_BLOCK_PART_DEBUG);
        TRANSLATION_CONNECTION_DEBUG = DevToolsConfig.translate(KEY_CONNECTION_DEBUG);
        TRANSLATION_QUAD_WINDING_DEBUG = DevToolsConfig.translate(KEY_QUAD_WINDING_DEBUG);
        TRANSLATION_STATE_MERGER_DEBUG = DevToolsConfig.translate(KEY_STATE_MERGER_DEBUG);
        TRANSLATION_STATE_MERGER_DEBUG_FILTER = DevToolsConfig.translate(KEY_STATE_MERGER_DEBUG_FILTER);
        TRANSLATION_OCCLUSION_SHAPE_DEBUG = DevToolsConfig.translate(KEY_OCCLUSION_SHAPE_DEBUG);
        doubleBlockPartDebug = false;
        connectionDebug = false;
        quadWindingDebug = false;
        stateMergerDebug = false;
        stateMergerDebugFilter = null;
        occlusionShapeDebug = false;
        if (FMLEnvironment.production) {
            SPEC = null;
            DOUBLE_BLOCK_PART_DEBUG_VALUE = null;
            CONNECTION_DEBUG_VALUE = null;
            QUAD_WINDING_DEBUG_VALUE = null;
            STATE_MERGER_DEBUG_VALUE = null;
            STATE_MERGER_DEBUG_FILTER_VALUE = null;
            OCCLUSION_SHAPE_DEBUG_VALUE = null;
        } else {
            ModConfigSpec.Builder builder = new ModConfigSpec.Builder();
            DOUBLE_BLOCK_PART_DEBUG_VALUE = builder.comment(new String[]{"Enable double-block part debug renderer for testing whether FramedBlockEntity#hitSecondary() is correctly implemented.", "Only applies to FramedBlocks blocks, add-on blocks are not handled by this."}).translation(TRANSLATION_DOUBLE_BLOCK_PART_DEBUG).gameRestart().define(KEY_DOUBLE_BLOCK_PART_DEBUG, false);
            CONNECTION_DEBUG_VALUE = builder.comment(new String[]{"Enable debug renderer for testing ConnectionPredicates.", "BlockEntities from add-ons must be registered to the renderer via AttachDebugRenderersEvent."}).translation(TRANSLATION_CONNECTION_DEBUG).gameRestart().define(KEY_CONNECTION_DEBUG, false);
            QUAD_WINDING_DEBUG_VALUE = builder.comment(new String[]{"Enable quad-winding debug renderer to check for issues with quad winding on transformed quads.", "BlockEntities from add-ons must be registered to the renderer via AttachDebugRenderersEvent."}).translation(TRANSLATION_QUAD_WINDING_DEBUG).gameRestart().define(KEY_QUAD_WINDING_DEBUG, false);
            STATE_MERGER_DEBUG_VALUE = builder.comment("If enabled, all model wrapper registrations will print which state properties of the associated block are used as-is and which ones are handled by a StateMerger").translation(TRANSLATION_STATE_MERGER_DEBUG).define(KEY_STATE_MERGER_DEBUG, false);
            STATE_MERGER_DEBUG_FILTER_VALUE = builder.comment(new String[]{"Set the regex pattern to filter the blocks for which StateMerger debug logging is enabled.", "An empty string will disable filtering"}).translation(TRANSLATION_STATE_MERGER_DEBUG_FILTER).define(KEY_STATE_MERGER_DEBUG_FILTER, (Object)"", DevToolsConfig::validateFilterPattern);
            OCCLUSION_SHAPE_DEBUG_VALUE = builder.comment("If enabled, switches block selection shape rendering to render the occlusion shape instead of the general shape").translation(TRANSLATION_OCCLUSION_SHAPE_DEBUG).define(KEY_OCCLUSION_SHAPE_DEBUG, false);
            SPEC = builder.build();
        }
    }

    public static final class ViewImpl
    implements ExtConfigView.DevTools {
        private static final boolean IN_DEV = !FMLEnvironment.production;

        @Override
        public boolean isDoubleBlockPartHitDebugRendererEnabled() {
            return IN_DEV && doubleBlockPartDebug;
        }

        @Override
        public boolean isConnectionDebugRendererEnabled() {
            return IN_DEV && connectionDebug;
        }

        @Override
        public boolean isQuadWindingDebugRendererEnabled() {
            return IN_DEV && quadWindingDebug;
        }

        @Override
        public boolean isStateMergerDebugLoggingEnabled() {
            return IN_DEV && stateMergerDebug;
        }

        @Override
        @Nullable
        public Pattern getStateMergerDebugFilter() {
            return IN_DEV ? stateMergerDebugFilter : null;
        }

        @Override
        public boolean isOcclusionShapeDebugRenderingEnabled() {
            return IN_DEV && occlusionShapeDebug;
        }
    }
}

