/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.camo.fluid;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.MapColor;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.common.util.TriState;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.api.camo.CamoClientHandler;
import xfacthd.framedblocks.api.camo.CamoContainerHelper;
import xfacthd.framedblocks.api.camo.CamoContent;
import xfacthd.framedblocks.api.util.ClientUtils;
import xfacthd.framedblocks.common.data.camo.fluid.FluidCamoClientHandler;
import xfacthd.framedblocks.common.particle.FluidParticleOptions;

public final class FluidCamoContent
extends CamoContent<FluidCamoContent> {
    private final Fluid fluid;

    public FluidCamoContent(Fluid fluid) {
        this.fluid = fluid;
    }

    public Fluid getFluid() {
        return this.fluid;
    }

    @Override
    public boolean propagatesSkylightDown(BlockGetter level, BlockPos pos) {
        return true;
    }

    @Override
    public float getExplosionResistance(BlockGetter level, BlockPos pos, Explosion explosion) {
        return this.fluid.getExplosionResistance(this.fluid.defaultFluidState(), level, pos, explosion);
    }

    @Override
    public boolean isFlammable(BlockGetter level, BlockPos pos, Direction face) {
        return false;
    }

    @Override
    public int getFlammability(BlockGetter level, BlockPos pos, Direction face) {
        return 0;
    }

    @Override
    public int getFireSpreadSpeed(BlockGetter level, BlockPos pos, Direction face) {
        return 0;
    }

    @Override
    public float getShadeBrightness(BlockGetter level, BlockPos pos, float frameShade) {
        return 1.0f;
    }

    @Override
    public int getLightEmission() {
        return this.fluid.getFluidType().getLightLevel();
    }

    @Override
    public boolean isEmissive() {
        return false;
    }

    @Override
    public SoundType getSoundType() {
        return SoundType.STONE;
    }

    @Override
    public boolean shouldDisplayFluidOverlay(BlockAndTintGetter level, BlockPos pos, FluidState fluidState) {
        return fluidState.getType() != this.fluid;
    }

    @Override
    public float getFriction(LevelReader level, BlockPos pos, @Nullable Entity entity, float frameFriction) {
        return frameFriction;
    }

    @Override
    public TriState canSustainPlant(BlockGetter level, BlockPos pos, Direction side, BlockState plant) {
        BlockState state = this.fluid.defaultFluidState().createLegacyBlock();
        return CamoContainerHelper.canPlantSurviveOnCamo(state, level, pos, side, plant);
    }

    @Override
    public boolean canEntityDestroy(BlockGetter level, BlockPos pos, Entity entity) {
        return true;
    }

    @Override
    @Nullable
    public MapColor getMapColor(BlockGetter level, BlockPos pos) {
        BlockState state = this.fluid.defaultFluidState().createLegacyBlock();
        return state.isAir() ? null : state.getMapColor(level, pos);
    }

    @Override
    public int getTintColor(BlockAndTintGetter level, BlockPos pos, int tintIdx) {
        if (FMLEnvironment.dist.isClient()) {
            return ClientUtils.getFluidColor(level, pos, this.fluid.defaultFluidState());
        }
        throw new UnsupportedOperationException("Block color is not available on the server!");
    }

    @Override
    @Nullable
    public Integer getBeaconColorMultiplier(LevelReader level, BlockPos pos, BlockPos beaconPos) {
        return null;
    }

    @Override
    public boolean isSolid(BlockGetter level, BlockPos pos) {
        return false;
    }

    @Override
    public boolean canOcclude() {
        return false;
    }

    @Override
    public BlockState getAsBlockState() {
        return this.fluid.defaultFluidState().createLegacyBlock();
    }

    @Override
    public BlockState getAppearanceState() {
        return Blocks.AIR.defaultBlockState();
    }

    @Override
    public boolean isOccludedBy(BlockState adjState, BlockGetter level, BlockPos pos, BlockPos adjPos) {
        return adjState.isSolidRender(level, pos);
    }

    @Override
    public boolean isOccludedBy(CamoContent<?> adjCamo, BlockGetter level, BlockPos pos, BlockPos adjPos) {
        return adjCamo.isSolid(level, pos) || this.equals(adjCamo);
    }

    @Override
    public boolean occludes(BlockState adjState, BlockGetter level, BlockPos pos, BlockPos adjPos) {
        return false;
    }

    @Override
    public ParticleOptions makeRunningLandingParticles(BlockPos pos) {
        return new FluidParticleOptions(this.fluid);
    }

    @Override
    public String getCamoId() {
        return BuiltInRegistries.FLUID.getKey((Object)this.fluid).toString();
    }

    @Override
    public MutableComponent getCamoName() {
        return (MutableComponent)this.fluid.getFluidType().getDescription();
    }

    @Override
    public CamoClientHandler<FluidCamoContent> getClientHandler() {
        return FluidCamoClientHandler.INSTANCE;
    }

    @Override
    public int hashCode() {
        return this.fluid.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != FluidCamoContent.class) {
            return false;
        }
        return this.fluid == ((FluidCamoContent)obj).fluid;
    }

    @Override
    public String toString() {
        return "FluidCamoContent{Fluid{" + String.valueOf(BuiltInRegistries.FLUID.getKey((Object)this.fluid)) + "}}";
    }
}

