/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.doubleblock;

import java.util.function.Predicate;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.util.TriState;
import xfacthd.framedblocks.api.camo.CamoContent;
import xfacthd.framedblocks.common.blockentity.doubled.FramedDoubleBlockEntity;
import xfacthd.framedblocks.common.data.doubleblock.PlantablePredicate;

public enum SolidityCheck {
    NONE(be -> false, (be, side, plant) -> TriState.DEFAULT),
    FIRST(be -> ((CamoContent)be.getCamo().getContent()).isSolid((BlockGetter)be.getLevel(), be.getBlockPos()), (be, side, plant) -> ((CamoContent)be.getCamo().getContent()).canSustainPlant((BlockGetter)be.getLevel(), be.getBlockPos(), side, plant)),
    SECOND(be -> ((CamoContent)be.getCamoTwo().getContent()).isSolid((BlockGetter)be.getLevel(), be.getBlockPos()), (be, side, plant) -> ((CamoContent)be.getCamoTwo().getContent()).canSustainPlant((BlockGetter)be.getLevel(), be.getBlockPos(), side, plant)),
    BOTH(be -> FIRST.isSolid((FramedDoubleBlockEntity)be) && SECOND.isSolid((FramedDoubleBlockEntity)be), (be, side, plant) -> TriState.DEFAULT);

    private final Predicate<FramedDoubleBlockEntity> predicate;
    private final PlantablePredicate plantablePredicate;

    private SolidityCheck(Predicate<FramedDoubleBlockEntity> predicate, PlantablePredicate plantablePredicate) {
        this.predicate = predicate;
        this.plantablePredicate = plantablePredicate;
    }

    public boolean isSolid(FramedDoubleBlockEntity be) {
        return this.predicate.test(be);
    }

    public TriState canSustainPlant(FramedDoubleBlockEntity be, Direction side, BlockState plant) {
        return this.plantablePredicate.test(be, side, plant);
    }
}

