/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.shapes.pillar;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.shapes.ShapeGenerator;
import xfacthd.framedblocks.api.shapes.ShapeProvider;
import xfacthd.framedblocks.api.shapes.ShapeUtils;

public final class LatticeShapes
implements ShapeGenerator {
    public static final LatticeShapes THIN = new LatticeShapes(4);
    public static final LatticeShapes THICK = new LatticeShapes(8);
    private final int minSize;
    private final int maxSize;

    private LatticeShapes(int thickness) {
        this.minSize = 8 - thickness / 2;
        this.maxSize = 8 + thickness / 2;
    }

    @Override
    public ShapeProvider generate(ImmutableList<BlockState> states) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        VoxelShape centerShape = Block.box((double)this.minSize, (double)this.minSize, (double)this.minSize, (double)this.maxSize, (double)this.maxSize, (double)this.maxSize);
        VoxelShape xShape = Block.box((double)0.0, (double)this.minSize, (double)this.minSize, (double)16.0, (double)this.maxSize, (double)this.maxSize);
        VoxelShape yShape = Block.box((double)this.minSize, (double)0.0, (double)this.minSize, (double)this.maxSize, (double)16.0, (double)this.maxSize);
        VoxelShape zShape = Block.box((double)this.minSize, (double)this.minSize, (double)0.0, (double)this.maxSize, (double)this.maxSize, (double)16.0);
        int maskX = 1;
        int maskY = 2;
        int maskZ = 4;
        VoxelShape[] shapes = new VoxelShape[8];
        for (int i = 0; i < 8; ++i) {
            VoxelShape shape = centerShape;
            if ((i & maskX) != 0) {
                shape = ShapeUtils.orUnoptimized(shape, xShape);
            }
            if ((i & maskY) != 0) {
                shape = ShapeUtils.orUnoptimized(shape, yShape);
            }
            if ((i & maskZ) != 0) {
                shape = ShapeUtils.orUnoptimized(shape, zShape);
            }
            shapes[i] = shape.optimize();
        }
        for (BlockState state : states) {
            int x = (Boolean)state.getValue((Property)FramedProperties.X_AXIS) != false ? maskX : 0;
            int y = (Boolean)state.getValue((Property)FramedProperties.Y_AXIS) != false ? maskY : 0;
            int z = (Boolean)state.getValue((Property)FramedProperties.Z_AXIS) != false ? maskZ : 0;
            builder.put((Object)state, (Object)shapes[x | y | z]);
        }
        return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
    }
}

