/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.shapes.slopepanel;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.shapes.ShapeCache;
import xfacthd.framedblocks.api.shapes.ShapeProvider;
import xfacthd.framedblocks.api.shapes.ShapeUtils;
import xfacthd.framedblocks.common.block.slopepanel.SlopePanelShape;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.HorizontalRotation;
import xfacthd.framedblocks.common.data.shapes.SplitShapeGenerator;
import xfacthd.framedblocks.common.data.shapes.slopepanel.SlopePanelShapes;

public final class FlatSlopePanelCornerShapes
implements SplitShapeGenerator {
    public static final ShapeCache<ShapeKey> SHAPES = FlatSlopePanelCornerShapes.makeCache(SlopePanelShapes.SHAPES, BooleanOp.AND);
    public static final ShapeCache<ShapeKey> OCCLUSION_SHAPES = FlatSlopePanelCornerShapes.makeCache(SlopePanelShapes.OCCLUSION_SHAPES, BooleanOp.AND);
    public static final ShapeCache<ShapeKey> INNER_SHAPES = FlatSlopePanelCornerShapes.makeCache(SlopePanelShapes.SHAPES, BooleanOp.OR);
    public static final ShapeCache<ShapeKey> INNER_OCCLUSION_SHAPES = FlatSlopePanelCornerShapes.makeCache(SlopePanelShapes.OCCLUSION_SHAPES, BooleanOp.OR);
    public static final FlatSlopePanelCornerShapes OUTER = new FlatSlopePanelCornerShapes(SHAPES, OCCLUSION_SHAPES);
    public static final FlatSlopePanelCornerShapes INNER = new FlatSlopePanelCornerShapes(INNER_SHAPES, INNER_OCCLUSION_SHAPES);
    private final ShapeCache<ShapeKey> shapes;
    private final ShapeCache<ShapeKey> occlusionShapes;

    private FlatSlopePanelCornerShapes(ShapeCache<ShapeKey> shapes, ShapeCache<ShapeKey> occlusionShapes) {
        this.shapes = shapes;
        this.occlusionShapes = occlusionShapes;
    }

    @Override
    public ShapeProvider generate(ImmutableList<BlockState> states) {
        return FlatSlopePanelCornerShapes.generate(states, this.shapes);
    }

    @Override
    public ShapeProvider generateOcclusionShapes(ImmutableList<BlockState> states) {
        return FlatSlopePanelCornerShapes.generate(states, this.occlusionShapes);
    }

    private static ShapeProvider generate(ImmutableList<BlockState> states, ShapeCache<ShapeKey> cache) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        int maskFront = 4;
        VoxelShape[] shapes = new VoxelShape[32];
        for (HorizontalRotation rot : HorizontalRotation.values()) {
            VoxelShape preShape = cache.get(new ShapeKey(rot, false));
            VoxelShape preShapeFront = cache.get(new ShapeKey(rot, true));
            ShapeUtils.makeHorizontalRotations(preShape, Direction.NORTH, shapes, rot.ordinal() << 3);
            ShapeUtils.makeHorizontalRotations(preShapeFront, Direction.NORTH, shapes, maskFront | rot.ordinal() << 3);
        }
        for (BlockState state : states) {
            HorizontalRotation rot;
            Direction dir = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
            rot = (HorizontalRotation)((Object)state.getValue(PropertyHolder.ROTATION));
            int front = (Boolean)state.getValue((Property)PropertyHolder.FRONT) != false ? maskFront : 0;
            int idx = dir.get2DDataValue() | front | rot.ordinal() << 3;
            builder.put((Object)state, (Object)shapes[idx]);
        }
        return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
    }

    private static ShapeCache<ShapeKey> makeCache(ShapeCache<SlopePanelShape> cache, BooleanOp joinOp) {
        return ShapeCache.create(map -> {
            for (HorizontalRotation rot : HorizontalRotation.values()) {
                VoxelShape preShape = Shapes.joinUnoptimized((VoxelShape)cache.get(SlopePanelShape.get(rot, false)), (VoxelShape)cache.get(SlopePanelShape.get(rot.rotate(Rotation.COUNTERCLOCKWISE_90), false)), (BooleanOp)joinOp);
                map.put(new ShapeKey(rot, false), preShape);
                map.put(new ShapeKey(rot, true), preShape.move(0.0, 0.0, 0.5));
            }
        });
    }

    public record ShapeKey(HorizontalRotation rot, boolean front) {
    }
}

