/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.shapes.slopepanelcorner;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.shapes.CommonShapes;
import xfacthd.framedblocks.api.shapes.ShapeProvider;
import xfacthd.framedblocks.api.shapes.ShapeUtils;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.HorizontalRotation;

public final class DoubleCornerSlopePanelWallShapes {
    public static ShapeProvider generateSmall(ImmutableList<BlockState> states) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (BlockState state : states) {
            Direction dir = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
            HorizontalRotation rot = (HorizontalRotation)((Object)state.getValue(PropertyHolder.ROTATION));
            CommonShapes.DirBoolKey key = switch (rot) {
                default -> throw new MatchException(null, null);
                case HorizontalRotation.UP -> new CommonShapes.DirBoolKey(dir.getCounterClockWise(), true);
                case HorizontalRotation.DOWN -> new CommonShapes.DirBoolKey(dir.getClockWise(), false);
                case HorizontalRotation.RIGHT -> new CommonShapes.DirBoolKey(dir.getClockWise(), true);
                case HorizontalRotation.LEFT -> new CommonShapes.DirBoolKey(dir.getCounterClockWise(), false);
            };
            builder.put((Object)state, (Object)CommonShapes.SLAB_EDGE.get(key));
        }
        return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
    }

    public static ShapeProvider generateLarge(ImmutableList<BlockState> states) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        VoxelShape[] shapes = new VoxelShape[16];
        for (HorizontalRotation rot : HorizontalRotation.values()) {
            VoxelShape preShape = Shapes.joinUnoptimized((VoxelShape)rot.getCornerShape(), (VoxelShape)Shapes.block(), (BooleanOp)BooleanOp.NOT_SAME);
            ShapeUtils.makeHorizontalRotations(preShape, Direction.NORTH, shapes, rot.ordinal() << 2);
        }
        for (BlockState state : states) {
            HorizontalRotation rot;
            Direction dir = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
            rot = (HorizontalRotation)((Object)state.getValue(PropertyHolder.ROTATION));
            int idx = dir.get2DDataValue() | rot.ordinal() << 2;
            builder.put((Object)state, (Object)shapes[idx]);
        }
        return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
    }
}

