/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds.door;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.predicate.cull.SideSkipPredicate;
import xfacthd.framedblocks.common.block.door.FramedGateBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.skippreds.CullTest;

@CullTest(value={BlockType.FRAMED_GATE})
public final class GateSkipPredicate
implements SideSkipPredicate {
    @Override
    @CullTest.TestTarget(value={BlockType.FRAMED_GATE})
    public boolean test(BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        Direction adjFacing;
        if (!(adjState.getBlock() instanceof FramedGateBlock)) {
            return false;
        }
        Direction facing = GateSkipPredicate.getDoorFacing(state);
        return facing == (adjFacing = GateSkipPredicate.getDoorFacing(adjState)) && side.getAxis() != facing.getAxis();
    }

    private static Direction getDoorFacing(BlockState state) {
        Direction facing = (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        DoorHingeSide hinge = (DoorHingeSide)state.getValue((Property)BlockStateProperties.DOOR_HINGE);
        if (((Boolean)state.getValue((Property)BlockStateProperties.OPEN)).booleanValue()) {
            return hinge == DoorHingeSide.LEFT ? facing.getClockWise() : facing.getCounterClockWise();
        }
        return facing;
    }
}

