/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds.slopepanel;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.predicate.cull.SideSkipPredicate;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.HorizontalRotation;
import xfacthd.framedblocks.common.data.property.SlopeType;
import xfacthd.framedblocks.common.data.property.StairsType;
import xfacthd.framedblocks.common.data.skippreds.CullTest;
import xfacthd.framedblocks.common.data.skippreds.HalfDir;
import xfacthd.framedblocks.common.data.skippreds.HalfTriangleDir;
import xfacthd.framedblocks.common.data.skippreds.pillar.CornerPillarSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slab.MasonryCornerSegmentSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slab.PanelSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slab.SlabEdgeSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopeedge.ElevatedSlopeEdgeSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopeedge.SlopeEdgeSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanel.CompoundSlopePanelSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanel.ExtendedSlopePanelSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanel.FlatExtendedInnerSlopePanelCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanel.FlatInnerSlopePanelCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanel.SlopePanelSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanelcorner.ExtendedCornerSlopePanelSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanelcorner.ExtendedCornerSlopePanelWallSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanelcorner.ExtendedInnerCornerSlopePanelSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanelcorner.ExtendedInnerCornerSlopePanelWallSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.HalfStairsSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.StairsSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.VerticalSlopedStairsSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.VerticalStairsSkipPredicate;

@CullTest(value={BlockType.FRAMED_FLAT_EXT_SLOPE_PANEL_CORNER})
public final class FlatExtendedSlopePanelCornerSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        IFramedBlock block;
        Object object = adjState.getBlock();
        if (object instanceof IFramedBlock && (object = (block = (IFramedBlock)object).getBlockType()) instanceof BlockType) {
            BlockType type = (BlockType)object;
            Direction dir = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
            HorizontalRotation rot = (HorizontalRotation)((Object)state.getValue(PropertyHolder.ROTATION));
            return switch (type) {
                case BlockType.FRAMED_FLAT_EXT_SLOPE_PANEL_CORNER -> FlatExtendedSlopePanelCornerSkipPredicate.testAgainstFlatExtendedSlopePanelCorner(dir, rot, adjState, side);
                case BlockType.FRAMED_FLAT_EXT_INNER_SLOPE_PANEL_CORNER -> FlatExtendedSlopePanelCornerSkipPredicate.testAgainstFlatExtendedInnerSlopePanelCorner(dir, rot, adjState, side);
                case BlockType.FRAMED_FLAT_INNER_SLOPE_PANEL_CORNER -> FlatExtendedSlopePanelCornerSkipPredicate.testAgainstFlatInnerSlopePanelCorner(dir, rot, adjState, side);
                case BlockType.FRAMED_SLOPE_PANEL -> FlatExtendedSlopePanelCornerSkipPredicate.testAgainstSlopePanel(dir, rot, adjState, side);
                case BlockType.FRAMED_EXTENDED_SLOPE_PANEL -> FlatExtendedSlopePanelCornerSkipPredicate.testAgainstExtendedSlopePanel(dir, rot, adjState, side);
                case BlockType.FRAMED_COMPOUND_SLOPE_PANEL -> FlatExtendedSlopePanelCornerSkipPredicate.testAgainstCompoundSlopePanel(dir, rot, adjState, side);
                case BlockType.FRAMED_EXT_CORNER_SLOPE_PANEL -> FlatExtendedSlopePanelCornerSkipPredicate.testAgainstExtendedCornerSlopePanel(dir, rot, adjState, side);
                case BlockType.FRAMED_EXT_CORNER_SLOPE_PANEL_W -> FlatExtendedSlopePanelCornerSkipPredicate.testAgainstExtendedCornerSlopePanelWall(dir, rot, adjState, side);
                case BlockType.FRAMED_EXT_INNER_CORNER_SLOPE_PANEL -> FlatExtendedSlopePanelCornerSkipPredicate.testAgainstExtendedInnerCornerSlopePanel(dir, rot, adjState, side);
                case BlockType.FRAMED_EXT_INNER_CORNER_SLOPE_PANEL_W -> FlatExtendedSlopePanelCornerSkipPredicate.testAgainstExtendedInnerCornerSlopePanelWall(dir, rot, adjState, side);
                case BlockType.FRAMED_SLOPE_EDGE -> FlatExtendedSlopePanelCornerSkipPredicate.testAgainstSlopeEdge(dir, rot, adjState, side);
                case BlockType.FRAMED_ELEVATED_SLOPE_EDGE -> FlatExtendedSlopePanelCornerSkipPredicate.testAgainstElevatedSlopeEdge(dir, rot, adjState, side);
                case BlockType.FRAMED_SLAB_EDGE -> FlatExtendedSlopePanelCornerSkipPredicate.testAgainstSlabEdge(dir, rot, adjState, side);
                case BlockType.FRAMED_PANEL -> FlatExtendedSlopePanelCornerSkipPredicate.testAgainstPanel(dir, rot, adjState, side);
                case BlockType.FRAMED_CORNER_PILLAR -> FlatExtendedSlopePanelCornerSkipPredicate.testAgainstCornerPillar(dir, rot, adjState, side);
                case BlockType.FRAMED_MASONRY_CORNER_SEGMENT -> FlatExtendedSlopePanelCornerSkipPredicate.testAgainstMasonryCornerSegment(dir, rot, adjState, side);
                case BlockType.FRAMED_STAIRS -> FlatExtendedSlopePanelCornerSkipPredicate.testAgainstStairs(dir, rot, adjState, side);
                case BlockType.FRAMED_VERTICAL_STAIRS -> FlatExtendedSlopePanelCornerSkipPredicate.testAgainstVerticalStairs(dir, rot, adjState, side);
                case BlockType.FRAMED_HALF_STAIRS, BlockType.FRAMED_HALF_SLOPE -> FlatExtendedSlopePanelCornerSkipPredicate.testAgainstHalfStairs(dir, rot, adjState, side);
                case BlockType.FRAMED_VERTICAL_SLOPED_STAIRS -> FlatExtendedSlopePanelCornerSkipPredicate.testAgainstVerticalSlopedStairs(dir, rot, adjState, side);
                default -> false;
            };
        }
        return false;
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_FLAT_EXT_SLOPE_PANEL_CORNER})
    private static boolean testAgainstFlatExtendedSlopePanelCorner(Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.getValue(PropertyHolder.ROTATION));
        if (FlatExtendedSlopePanelCornerSkipPredicate.getHalfDir(dir, rot, side).isEqualTo(FlatExtendedSlopePanelCornerSkipPredicate.getHalfDir(adjDir, adjRot, side.getOpposite()))) {
            return true;
        }
        return FlatExtendedSlopePanelCornerSkipPredicate.getTriDir(dir, rot, side).isEqualTo(FlatExtendedSlopePanelCornerSkipPredicate.getTriDir(adjDir, adjRot, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_FLAT_EXT_INNER_SLOPE_PANEL_CORNER})
    private static boolean testAgainstFlatExtendedInnerSlopePanelCorner(Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.getValue(PropertyHolder.ROTATION));
        return FlatExtendedSlopePanelCornerSkipPredicate.getTriDir(dir, rot, side).isEqualTo(FlatExtendedInnerSlopePanelCornerSkipPredicate.getTriDir(adjDir, adjRot, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_FLAT_INNER_SLOPE_PANEL_CORNER})
    private static boolean testAgainstFlatInnerSlopePanelCorner(Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.getValue(PropertyHolder.ROTATION));
        boolean adjFront = (Boolean)adjState.getValue((Property)PropertyHolder.FRONT);
        return FlatExtendedSlopePanelCornerSkipPredicate.getHalfDir(dir, rot, side).isEqualTo(FlatInnerSlopePanelCornerSkipPredicate.getHalfDir(adjDir, adjRot, adjFront, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_SLOPE_PANEL})
    private static boolean testAgainstSlopePanel(Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.getValue(PropertyHolder.ROTATION));
        boolean adjFront = (Boolean)adjState.getValue((Property)PropertyHolder.FRONT);
        return FlatExtendedSlopePanelCornerSkipPredicate.getHalfDir(dir, rot, side).isEqualTo(SlopePanelSkipPredicate.getHalfDir(adjDir, adjRot, adjFront, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_EXTENDED_SLOPE_PANEL})
    private static boolean testAgainstExtendedSlopePanel(Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.getValue(PropertyHolder.ROTATION));
        if (FlatExtendedSlopePanelCornerSkipPredicate.getHalfDir(dir, rot, side).isEqualTo(ExtendedSlopePanelSkipPredicate.getHalfDir(adjDir, adjRot, side.getOpposite()))) {
            return true;
        }
        return FlatExtendedSlopePanelCornerSkipPredicate.getTriDir(dir, rot, side).isEqualTo(ExtendedSlopePanelSkipPredicate.getTriDir(adjDir, adjRot, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_COMPOUND_SLOPE_PANEL})
    private static boolean testAgainstCompoundSlopePanel(Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.getValue(PropertyHolder.ROTATION));
        return FlatExtendedSlopePanelCornerSkipPredicate.getHalfDir(dir, rot, side).isEqualTo(CompoundSlopePanelSkipPredicate.getHalfDir(adjDir, adjRot, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_EXT_CORNER_SLOPE_PANEL})
    private static boolean testAgainstExtendedCornerSlopePanel(Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        return FlatExtendedSlopePanelCornerSkipPredicate.getTriDir(dir, rot, side).isEqualTo(ExtendedCornerSlopePanelSkipPredicate.getTriDir(adjDir, adjTop, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_EXT_CORNER_SLOPE_PANEL_W})
    private static boolean testAgainstExtendedCornerSlopePanelWall(Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.getValue(PropertyHolder.ROTATION));
        return FlatExtendedSlopePanelCornerSkipPredicate.getTriDir(dir, rot, side).isEqualTo(ExtendedCornerSlopePanelWallSkipPredicate.getTriDir(adjDir, adjRot, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_EXT_INNER_CORNER_SLOPE_PANEL})
    private static boolean testAgainstExtendedInnerCornerSlopePanel(Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        return FlatExtendedSlopePanelCornerSkipPredicate.getTriDir(dir, rot, side).isEqualTo(ExtendedInnerCornerSlopePanelSkipPredicate.getTriDir(adjDir, adjTop, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_EXT_INNER_CORNER_SLOPE_PANEL_W})
    private static boolean testAgainstExtendedInnerCornerSlopePanelWall(Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.getValue(PropertyHolder.ROTATION));
        return FlatExtendedSlopePanelCornerSkipPredicate.getTriDir(dir, rot, side).isEqualTo(ExtendedInnerCornerSlopePanelWallSkipPredicate.getTriDir(adjDir, adjRot, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_SLOPE_EDGE})
    private static boolean testAgainstSlopeEdge(Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        SlopeType adjType = (SlopeType)((Object)adjState.getValue(PropertyHolder.SLOPE_TYPE));
        boolean adjAlt = (Boolean)adjState.getValue((Property)PropertyHolder.ALT_TYPE);
        return FlatExtendedSlopePanelCornerSkipPredicate.getHalfDir(dir, rot, side).isEqualTo(SlopeEdgeSkipPredicate.getHalfDir(adjDir, adjType, adjAlt, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_ELEVATED_SLOPE_EDGE})
    private static boolean testAgainstElevatedSlopeEdge(Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        SlopeType adjType = (SlopeType)((Object)adjState.getValue(PropertyHolder.SLOPE_TYPE));
        return FlatExtendedSlopePanelCornerSkipPredicate.getHalfDir(dir, rot, side).isEqualTo(ElevatedSlopeEdgeSkipPredicate.getHalfDir(adjDir, adjType, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_SLAB_EDGE})
    private static boolean testAgainstSlabEdge(Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        return FlatExtendedSlopePanelCornerSkipPredicate.getHalfDir(dir, rot, side).isEqualTo(SlabEdgeSkipPredicate.getHalfDir(adjDir, adjTop, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_PANEL})
    private static boolean testAgainstPanel(Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        return FlatExtendedSlopePanelCornerSkipPredicate.getHalfDir(dir, rot, side).isEqualTo(PanelSkipPredicate.getHalfDir(adjDir, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_CORNER_PILLAR})
    private static boolean testAgainstCornerPillar(Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        return FlatExtendedSlopePanelCornerSkipPredicate.getHalfDir(dir, rot, side).isEqualTo(CornerPillarSkipPredicate.getHalfDir(adjDir, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_MASONRY_CORNER_SEGMENT})
    private static boolean testAgainstMasonryCornerSegment(Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        return FlatExtendedSlopePanelCornerSkipPredicate.getHalfDir(dir, rot, side).isEqualTo(MasonryCornerSegmentSkipPredicate.getHalfDir(adjDir, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_STAIRS})
    private static boolean testAgainstStairs(Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)StairBlock.FACING);
        StairsShape adjShape = (StairsShape)adjState.getValue((Property)StairBlock.SHAPE);
        Half adjHalf = (Half)adjState.getValue((Property)StairBlock.HALF);
        return FlatExtendedSlopePanelCornerSkipPredicate.getHalfDir(dir, rot, side).isEqualTo(StairsSkipPredicate.getHalfDir(adjDir, adjShape, adjHalf, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_VERTICAL_STAIRS})
    private static boolean testAgainstVerticalStairs(Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        StairsType adjType = (StairsType)((Object)adjState.getValue(PropertyHolder.STAIRS_TYPE));
        return FlatExtendedSlopePanelCornerSkipPredicate.getHalfDir(dir, rot, side).isEqualTo(VerticalStairsSkipPredicate.getHalfDir(adjDir, adjType, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_HALF_STAIRS, BlockType.FRAMED_HALF_SLOPE})
    private static boolean testAgainstHalfStairs(Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        boolean adjRight = (Boolean)adjState.getValue((Property)PropertyHolder.RIGHT);
        return FlatExtendedSlopePanelCornerSkipPredicate.getHalfDir(dir, rot, side).isEqualTo(HalfStairsSkipPredicate.getHalfDir(adjDir, adjTop, adjRight, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_VERTICAL_SLOPED_STAIRS})
    private static boolean testAgainstVerticalSlopedStairs(Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.getValue(PropertyHolder.ROTATION));
        return FlatExtendedSlopePanelCornerSkipPredicate.getHalfDir(dir, rot, side).isEqualTo(VerticalSlopedStairsSkipPredicate.getHalfDir(adjDir, adjRot, side.getOpposite()));
    }

    public static HalfTriangleDir getTriDir(Direction dir, HorizontalRotation rot, Direction side) {
        Direction rotDir = rot.withFacing(dir);
        Direction perpRotDir = rot.rotate(Rotation.COUNTERCLOCKWISE_90).withFacing(dir);
        if (side == rotDir.getOpposite() || side == perpRotDir.getOpposite()) {
            Direction shortEdge = side == rotDir.getOpposite() ? perpRotDir.getOpposite() : rotDir.getOpposite();
            return HalfTriangleDir.fromDirections(dir, shortEdge, false);
        }
        return HalfTriangleDir.NULL;
    }

    public static HalfDir getHalfDir(Direction dir, HorizontalRotation rot, Direction side) {
        if (side == rot.withFacing(dir) || side == rot.rotate(Rotation.COUNTERCLOCKWISE_90).withFacing(dir)) {
            return HalfDir.fromDirections(side, dir);
        }
        return HalfDir.NULL;
    }
}

