/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds.slopepanelcorner;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.predicate.cull.SideSkipPredicate;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.HorizontalRotation;
import xfacthd.framedblocks.common.data.property.StairsType;
import xfacthd.framedblocks.common.data.skippreds.CullTest;
import xfacthd.framedblocks.common.data.skippreds.HalfTriangleDir;
import xfacthd.framedblocks.common.data.skippreds.TriangleDir;
import xfacthd.framedblocks.common.data.skippreds.slopepanel.FlatInnerSlopePanelCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanel.FlatSlopePanelCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanel.SlopePanelSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanelcorner.ExtendedInnerCornerSlopePanelSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanelcorner.LargeInnerCornerSlopePanelSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanelcorner.SmallInnerCornerSlopePanelSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.StairsSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.VerticalHalfStairsSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.VerticalStairsSkipPredicate;

@CullTest(value={BlockType.FRAMED_LARGE_CORNER_SLOPE_PANEL})
public final class LargeCornerSlopePanelSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        IFramedBlock block;
        Object object = adjState.getBlock();
        if (object instanceof IFramedBlock && (object = (block = (IFramedBlock)object).getBlockType()) instanceof BlockType) {
            BlockType type = (BlockType)object;
            Direction dir = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
            boolean top = (Boolean)state.getValue((Property)FramedProperties.TOP);
            return switch (type) {
                case BlockType.FRAMED_LARGE_CORNER_SLOPE_PANEL -> LargeCornerSlopePanelSkipPredicate.testAgainstLargeCornerSlopePanel(dir, top, adjState, side);
                case BlockType.FRAMED_SMALL_INNER_CORNER_SLOPE_PANEL -> LargeCornerSlopePanelSkipPredicate.testAgainstSmallInnerCornerSlopePanel(dir, top, adjState, side);
                case BlockType.FRAMED_LARGE_INNER_CORNER_SLOPE_PANEL -> LargeCornerSlopePanelSkipPredicate.testAgainstLargeInnerCornerSlopePanel(dir, top, adjState, side);
                case BlockType.FRAMED_EXT_INNER_CORNER_SLOPE_PANEL -> LargeCornerSlopePanelSkipPredicate.testAgainstExtendedInnerCornerSlopePanel(dir, top, adjState, side);
                case BlockType.FRAMED_SLOPE_PANEL -> LargeCornerSlopePanelSkipPredicate.testAgainstSlopePanel(dir, top, adjState, side);
                case BlockType.FRAMED_FLAT_SLOPE_PANEL_CORNER -> LargeCornerSlopePanelSkipPredicate.testAgainstFlatSlopePanelCorner(dir, top, adjState, side);
                case BlockType.FRAMED_FLAT_INNER_SLOPE_PANEL_CORNER -> LargeCornerSlopePanelSkipPredicate.testAgainstFlatInnerSlopePanelCorner(dir, top, adjState, side);
                case BlockType.FRAMED_STAIRS -> LargeCornerSlopePanelSkipPredicate.testAgainstStairs(dir, top, adjState, side);
                case BlockType.FRAMED_VERTICAL_STAIRS -> LargeCornerSlopePanelSkipPredicate.testAgainstVerticalStairs(dir, top, adjState, side);
                case BlockType.FRAMED_VERTICAL_HALF_STAIRS -> LargeCornerSlopePanelSkipPredicate.testAgainstVerticalHalfStairs(dir, top, adjState, side);
                default -> false;
            };
        }
        return false;
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_LARGE_CORNER_SLOPE_PANEL})
    private static boolean testAgainstLargeCornerSlopePanel(Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        if (LargeCornerSlopePanelSkipPredicate.getTriDir(dir, top, side).isEqualTo(LargeCornerSlopePanelSkipPredicate.getTriDir(adjDir, adjTop, side.getOpposite()))) {
            return true;
        }
        return LargeCornerSlopePanelSkipPredicate.getStairDir(dir, top, side).isEqualTo(LargeCornerSlopePanelSkipPredicate.getStairDir(adjDir, adjTop, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_SMALL_INNER_CORNER_SLOPE_PANEL})
    private static boolean testAgainstSmallInnerCornerSlopePanel(Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        return LargeCornerSlopePanelSkipPredicate.getTriDir(dir, top, side).isEqualTo(SmallInnerCornerSlopePanelSkipPredicate.getTriDir(adjDir, adjTop, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_LARGE_INNER_CORNER_SLOPE_PANEL})
    private static boolean testAgainstLargeInnerCornerSlopePanel(Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        return LargeCornerSlopePanelSkipPredicate.getStairDir(dir, top, side).isEqualTo(LargeInnerCornerSlopePanelSkipPredicate.getStairDir(adjDir, adjTop, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_EXT_INNER_CORNER_SLOPE_PANEL})
    private static boolean testAgainstExtendedInnerCornerSlopePanel(Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        return LargeCornerSlopePanelSkipPredicate.getStairDir(dir, top, side).isEqualTo(ExtendedInnerCornerSlopePanelSkipPredicate.getStairDir(adjDir, adjTop, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_SLOPE_PANEL})
    private static boolean testAgainstSlopePanel(Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.getValue(PropertyHolder.ROTATION));
        boolean adjFront = (Boolean)adjState.getValue((Property)PropertyHolder.FRONT);
        return LargeCornerSlopePanelSkipPredicate.getTriDir(dir, top, side).isEqualTo(SlopePanelSkipPredicate.getTriDir(adjDir, adjRot, adjFront, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_FLAT_SLOPE_PANEL_CORNER})
    private static boolean testAgainstFlatSlopePanelCorner(Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.getValue(PropertyHolder.ROTATION));
        boolean adjFront = (Boolean)adjState.getValue((Property)PropertyHolder.FRONT);
        return LargeCornerSlopePanelSkipPredicate.getTriDir(dir, top, side).isEqualTo(FlatSlopePanelCornerSkipPredicate.getTriDir(adjDir, adjRot, adjFront, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_FLAT_INNER_SLOPE_PANEL_CORNER})
    private static boolean testAgainstFlatInnerSlopePanelCorner(Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.getValue(PropertyHolder.ROTATION));
        boolean adjFront = (Boolean)adjState.getValue((Property)PropertyHolder.FRONT);
        return LargeCornerSlopePanelSkipPredicate.getTriDir(dir, top, side).isEqualTo(FlatInnerSlopePanelCornerSkipPredicate.getTriDir(adjDir, adjRot, adjFront, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_STAIRS})
    private static boolean testAgainstStairs(Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)StairBlock.FACING);
        StairsShape adjShape = (StairsShape)adjState.getValue((Property)StairBlock.SHAPE);
        Half adjHalf = (Half)adjState.getValue((Property)StairBlock.HALF);
        return LargeCornerSlopePanelSkipPredicate.getStairDir(dir, top, side).isEqualTo(StairsSkipPredicate.getStairDir(adjDir, adjShape, adjHalf, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_VERTICAL_STAIRS})
    private static boolean testAgainstVerticalStairs(Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        StairsType adjType = (StairsType)((Object)adjState.getValue(PropertyHolder.STAIRS_TYPE));
        return LargeCornerSlopePanelSkipPredicate.getStairDir(dir, top, side).isEqualTo(VerticalStairsSkipPredicate.getStairDir(adjDir, adjType, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_VERTICAL_HALF_STAIRS})
    private static boolean testAgainstVerticalHalfStairs(Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        return LargeCornerSlopePanelSkipPredicate.getStairDir(dir, top, side).isEqualTo(VerticalHalfStairsSkipPredicate.getStairDir(adjDir, adjTop, side.getOpposite()));
    }

    public static HalfTriangleDir getTriDir(Direction dir, boolean top, Direction side) {
        if (side == dir) {
            return HalfTriangleDir.fromDirections(dir.getCounterClockWise(), top ? Direction.UP : Direction.DOWN, false);
        }
        if (side == dir.getCounterClockWise()) {
            return HalfTriangleDir.fromDirections(dir, top ? Direction.UP : Direction.DOWN, false);
        }
        return HalfTriangleDir.NULL;
    }

    public static TriangleDir getStairDir(Direction dir, boolean top, Direction side) {
        if (!top && side == Direction.DOWN || top && side == Direction.UP) {
            return TriangleDir.fromDirections(dir.getClockWise(), dir.getOpposite());
        }
        return TriangleDir.NULL;
    }
}

