/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.datagen.providers;

import net.minecraft.client.KeyMapping;
import net.minecraft.core.Direction;
import net.minecraft.data.PackOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.data.LanguageProvider;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.block.blockentity.FramedBlockEntity;
import xfacthd.framedblocks.api.camo.empty.EmptyCamoContainer;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.client.screen.FramedSignScreen;
import xfacthd.framedblocks.client.screen.FramingSawScreen;
import xfacthd.framedblocks.client.screen.FramingSawWithEncoderScreen;
import xfacthd.framedblocks.client.screen.PoweredFramingSawScreen;
import xfacthd.framedblocks.client.screen.overlay.CamoRotationOverlay;
import xfacthd.framedblocks.client.screen.overlay.FrameBackgroundOverlay;
import xfacthd.framedblocks.client.screen.overlay.OneWayWindowOverlay;
import xfacthd.framedblocks.client.screen.overlay.PrismOffsetOverlay;
import xfacthd.framedblocks.client.screen.overlay.ReinforcementOverlay;
import xfacthd.framedblocks.client.screen.overlay.SplitLineOverlay;
import xfacthd.framedblocks.client.screen.overlay.StateLockOverlay;
import xfacthd.framedblocks.client.screen.overlay.ToggleWaterloggableOverlay;
import xfacthd.framedblocks.client.screen.overlay.ToggleYSlopeOverlay;
import xfacthd.framedblocks.client.util.KeyMappings;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.block.special.FramingSawBlock;
import xfacthd.framedblocks.common.block.special.PoweredFramingSawBlock;
import xfacthd.framedblocks.common.blockentity.special.FramedChestBlockEntity;
import xfacthd.framedblocks.common.blockentity.special.FramedStorageBlockEntity;
import xfacthd.framedblocks.common.compat.atlasviewer.AtlasViewerCompat;
import xfacthd.framedblocks.common.compat.jade.JadeCompat;
import xfacthd.framedblocks.common.compat.jei.JeiMessages;
import xfacthd.framedblocks.common.config.ClientConfig;
import xfacthd.framedblocks.common.config.DevToolsConfig;
import xfacthd.framedblocks.common.config.ServerConfig;
import xfacthd.framedblocks.common.crafting.FramingSawRecipeMatchResult;
import xfacthd.framedblocks.common.data.property.NullableDirection;
import xfacthd.framedblocks.common.item.FramedBlueprintItem;

public final class FramedLanguageProvider
extends LanguageProvider {
    public FramedLanguageProvider(PackOutput output) {
        super(output, "framedblocks", "en_us");
    }

    protected void addTranslations() {
        this.addFramedBlockTranslations();
        this.addSpecialBlockTranslations();
        this.addItemTranslations();
        this.addSpecialTranslations();
        this.addStatusMessageTranslations();
        this.addScreenTranslations();
        this.addTooltipTranslations();
        this.addOverlayTranslations();
        this.addConfigTranslations();
    }

    private void addFramedBlockTranslations() {
        this.add((Block)FBContent.BLOCK_FRAMED_CUBE.value(), "Framed Cube");
        this.add((Block)FBContent.BLOCK_FRAMED_SLOPE.value(), "Framed Slope");
        this.add((Block)FBContent.BLOCK_FRAMED_DOUBLE_SLOPE.value(), "Framed Double Slope");
        this.add((Block)FBContent.BLOCK_FRAMED_HALF_SLOPE.value(), "Framed Half Slope");
        this.add((Block)FBContent.BLOCK_FRAMED_VERTICAL_HALF_SLOPE.value(), "Framed Half Slope");
        this.add((Block)FBContent.BLOCK_FRAMED_DIVIDED_SLOPE.value(), "Framed Divided Slope");
        this.add((Block)FBContent.BLOCK_FRAMED_DOUBLE_HALF_SLOPE.value(), "Framed Double Half Slope");
        this.add((Block)FBContent.BLOCK_FRAMED_VERTICAL_DOUBLE_HALF_SLOPE.value(), "Framed Double Half Slope");
        this.add((Block)FBContent.BLOCK_FRAMED_CORNER_SLOPE.value(), "Framed Corner Slope");
        this.add((Block)FBContent.BLOCK_FRAMED_INNER_CORNER_SLOPE.value(), "Framed Inner Corner Slope");
        this.add((Block)FBContent.BLOCK_FRAMED_DOUBLE_CORNER.value(), "Framed Double Corner");
        this.add((Block)FBContent.BLOCK_FRAMED_PRISM_CORNER.value(), "Framed Prism Corner");
        this.add((Block)FBContent.BLOCK_FRAMED_INNER_PRISM_CORNER.value(), "Framed Inner Prism Corner");
        this.add((Block)FBContent.BLOCK_FRAMED_DOUBLE_PRISM_CORNER.value(), "Framed Double Prism Corner");
        this.add((Block)FBContent.BLOCK_FRAMED_THREEWAY_CORNER.value(), "Framed Threeway Corner");
        this.add((Block)FBContent.BLOCK_FRAMED_INNER_THREEWAY_CORNER.value(), "Framed Inner Threeway Corner");
        this.add((Block)FBContent.BLOCK_FRAMED_DOUBLE_THREEWAY_CORNER.value(), "Framed Double Threeway Corner");
        this.add((Block)FBContent.BLOCK_FRAMED_SLOPE_EDGE.value(), "Framed Slope Edge");
        this.add((Block)FBContent.BLOCK_FRAMED_ELEVATED_SLOPE_EDGE.value(), "Framed Elevated Slope Edge");
        this.add((Block)FBContent.BLOCK_FRAMED_ELEVATED_DOUBLE_SLOPE_EDGE.value(), "Framed Elevated Double Slope Edge");
        this.add((Block)FBContent.BLOCK_FRAMED_STACKED_SLOPE_EDGE.value(), "Framed Stacked Slope Edge");
        this.add((Block)FBContent.BLOCK_FRAMED_SLAB.value(), "Framed Slab");
        this.add((Block)FBContent.BLOCK_FRAMED_DOUBLE_SLAB.value(), "Framed Double Slab");
        this.add((Block)FBContent.BLOCK_FRAMED_ADJ_DOUBLE_SLAB.value(), "Framed Adjustable Double Slab");
        this.add((Block)FBContent.BLOCK_FRAMED_ADJ_DOUBLE_COPYCAT_SLAB.value(), "Framed Adjustable Double Copycat Slab");
        this.add((Block)FBContent.BLOCK_FRAMED_DIVIDED_SLAB.value(), "Framed Divided Slab");
        this.add((Block)FBContent.BLOCK_FRAMED_SLAB_EDGE.value(), "Framed Slab Edge");
        this.add((Block)FBContent.BLOCK_FRAMED_SLAB_CORNER.value(), "Framed Slab Corner");
        this.add((Block)FBContent.BLOCK_FRAMED_PANEL.value(), "Framed Panel");
        this.add((Block)FBContent.BLOCK_FRAMED_DOUBLE_PANEL.value(), "Framed Double Panel");
        this.add((Block)FBContent.BLOCK_FRAMED_ADJ_DOUBLE_PANEL.value(), "Framed Adjustable Double Panel");
        this.add((Block)FBContent.BLOCK_FRAMED_ADJ_DOUBLE_COPYCAT_PANEL.value(), "Framed Adjustable Double Copycat Panel");
        this.add((Block)FBContent.BLOCK_FRAMED_DIVIDED_PANEL_HOR.value(), "Framed Divided Panel (Horizontal)");
        this.add((Block)FBContent.BLOCK_FRAMED_DIVIDED_PANEL_VERT.value(), "Framed Divided Panel (Vertical)");
        this.add((Block)FBContent.BLOCK_FRAMED_CORNER_PILLAR.value(), "Framed Corner Pillar");
        this.add((Block)FBContent.BLOCK_FRAMED_STAIRS.value(), "Framed Stairs");
        this.add((Block)FBContent.BLOCK_FRAMED_DOUBLE_STAIRS.value(), "Framed Double Stairs");
        this.add((Block)FBContent.BLOCK_FRAMED_HALF_STAIRS.value(), "Framed Half Stairs");
        this.add((Block)FBContent.BLOCK_FRAMED_DIVIDED_STAIRS.value(), "Framed Divided Stairs");
        this.add((Block)FBContent.BLOCK_FRAMED_DOUBLE_HALF_STAIRS.value(), "Framed Double Half Stairs");
        this.add((Block)FBContent.BLOCK_FRAMED_SLOPED_STAIRS.value(), "Framed Sloped Stairs");
        this.add((Block)FBContent.BLOCK_FRAMED_SLICED_STAIRS_SLAB.value(), "Framed Sliced Stairs (Slab)");
        this.add((Block)FBContent.BLOCK_FRAMED_SLICED_STAIRS_PANEL.value(), "Framed Sliced Stairs (Panel)");
        this.add((Block)FBContent.BLOCK_FRAMED_VERTICAL_STAIRS.value(), "Framed Vertical Stairs");
        this.add((Block)FBContent.BLOCK_FRAMED_VERTICAL_DOUBLE_STAIRS.value(), "Framed Vertical Double Stairs");
        this.add((Block)FBContent.BLOCK_FRAMED_VERTICAL_HALF_STAIRS.value(), "Framed Vertical Half Stairs");
        this.add((Block)FBContent.BLOCK_FRAMED_VERTICAL_DIVIDED_STAIRS.value(), "Framed Vertical Divided Stairs");
        this.add((Block)FBContent.BLOCK_FRAMED_VERTICAL_DOUBLE_HALF_STAIRS.value(), "Framed Vertical Double Half Stairs");
        this.add((Block)FBContent.BLOCK_FRAMED_VERTICAL_SLICED_STAIRS.value(), "Framed Vertical Sliced Stairs");
        this.add((Block)FBContent.BLOCK_FRAMED_VERTICAL_SLOPED_STAIRS.value(), "Framed Vertical Sloped Stairs");
        this.add((Block)FBContent.BLOCK_FRAMED_THREEWAY_CORNER_PILLAR.value(), "Framed Threeway Corner Pillar");
        this.add((Block)FBContent.BLOCK_FRAMED_DOUBLE_THREEWAY_CORNER_PILLAR.value(), "Framed Double Threeway Corner Pillar");
        this.add((Block)FBContent.BLOCK_FRAMED_WALL.value(), "Framed Wall");
        this.add((Block)FBContent.BLOCK_FRAMED_FENCE.value(), "Framed Fence");
        this.add((Block)FBContent.BLOCK_FRAMED_FENCE_GATE.value(), "Framed Fence Gate");
        this.add((Block)FBContent.BLOCK_FRAMED_DOOR.value(), "Framed Door");
        this.add((Block)FBContent.BLOCK_FRAMED_IRON_DOOR.value(), "Framed Iron Door");
        this.add((Block)FBContent.BLOCK_FRAMED_TRAP_DOOR.value(), "Framed Trapdoor");
        this.add((Block)FBContent.BLOCK_FRAMED_IRON_TRAP_DOOR.value(), "Framed Iron Trapdoor");
        this.add((Block)FBContent.BLOCK_FRAMED_PRESSURE_PLATE.value(), "Framed Pressure Plate");
        this.add((Block)FBContent.BLOCK_FRAMED_WATERLOGGABLE_PRESSURE_PLATE.value(), "Framed Pressure Plate");
        this.add((Block)FBContent.BLOCK_FRAMED_STONE_PRESSURE_PLATE.value(), "Framed Stone Pressure Plate");
        this.add((Block)FBContent.BLOCK_FRAMED_WATERLOGGABLE_STONE_PRESSURE_PLATE.value(), "Framed Stone Pressure Plate");
        this.add((Block)FBContent.BLOCK_FRAMED_OBSIDIAN_PRESSURE_PLATE.value(), "Framed Obsidian Pressure Plate");
        this.add((Block)FBContent.BLOCK_FRAMED_WATERLOGGABLE_OBSIDIAN_PRESSURE_PLATE.value(), "Framed Obsidian Pressure Plate");
        this.add((Block)FBContent.BLOCK_FRAMED_GOLD_PRESSURE_PLATE.value(), "Framed Light Weighted Pressure Plate");
        this.add((Block)FBContent.BLOCK_FRAMED_WATERLOGGABLE_GOLD_PRESSURE_PLATE.value(), "Framed Light Weighted Pressure Plate");
        this.add((Block)FBContent.BLOCK_FRAMED_IRON_PRESSURE_PLATE.value(), "Framed Heavy Weighted Pressure Plate");
        this.add((Block)FBContent.BLOCK_FRAMED_WATERLOGGABLE_IRON_PRESSURE_PLATE.value(), "Framed Heavy Weighted Pressure Plate");
        this.add((Block)FBContent.BLOCK_FRAMED_LADDER.value(), "Framed Ladder");
        this.add((Block)FBContent.BLOCK_FRAMED_BUTTON.value(), "Framed Button");
        this.add((Block)FBContent.BLOCK_FRAMED_STONE_BUTTON.value(), "Framed Stone Button");
        this.add((Block)FBContent.BLOCK_FRAMED_LARGE_BUTTON.value(), "Large Framed Button");
        this.add((Block)FBContent.BLOCK_FRAMED_LARGE_STONE_BUTTON.value(), "Large Framed Stone Button");
        this.add((Block)FBContent.BLOCK_FRAMED_LEVER.value(), "Framed Lever");
        this.add((Block)FBContent.BLOCK_FRAMED_SIGN.value(), "Framed Sign");
        this.add((Block)FBContent.BLOCK_FRAMED_WALL_SIGN.value(), "Framed Sign");
        this.add((Block)FBContent.BLOCK_FRAMED_HANGING_SIGN.value(), "Framed Hanging Sign");
        this.add((Block)FBContent.BLOCK_FRAMED_WALL_HANGING_SIGN.value(), "Framed Hanging Sign");
        this.add((Block)FBContent.BLOCK_FRAMED_TORCH.value(), "Framed Torch");
        this.add((Block)FBContent.BLOCK_FRAMED_SOUL_TORCH.value(), "Framed Soul Torch");
        this.add((Block)FBContent.BLOCK_FRAMED_REDSTONE_TORCH.value(), "Framed Redstone Torch");
        this.add((Block)FBContent.BLOCK_FRAMED_FLOOR.value(), "Framed Floor Board");
        this.add((Block)FBContent.BLOCK_FRAMED_WALL_BOARD.value(), "Framed Wall Board");
        this.add((Block)FBContent.BLOCK_FRAMED_CORNER_STRIP.value(), "Framed Corner Strip");
        this.add((Block)FBContent.BLOCK_FRAMED_LATTICE.value(), "Framed Lattice");
        this.add((Block)FBContent.BLOCK_FRAMED_THICK_LATTICE.value(), "Framed Thick Lattice");
        this.add((Block)FBContent.BLOCK_FRAMED_CHEST.value(), "Framed Chest");
        this.add((Block)FBContent.BLOCK_FRAMED_SECRET_STORAGE.value(), "Framed Secret Storage");
        this.add((Block)FBContent.BLOCK_FRAMED_BARS.value(), "Framed Bars");
        this.add((Block)FBContent.BLOCK_FRAMED_PANE.value(), "Framed Pane");
        this.add((Block)FBContent.BLOCK_FRAMED_RAIL_SLOPE.value(), "Framed Rail Slope");
        this.add((Block)FBContent.BLOCK_FRAMED_POWERED_RAIL_SLOPE.value(), "Framed Powered Rail Slope");
        this.add((Block)FBContent.BLOCK_FRAMED_DETECTOR_RAIL_SLOPE.value(), "Framed Detector Rail Slope");
        this.add((Block)FBContent.BLOCK_FRAMED_ACTIVATOR_RAIL_SLOPE.value(), "Framed Activator Rail Slope");
        this.add((Block)FBContent.BLOCK_FRAMED_FANCY_RAIL.value(), "Framed Fancy Rail");
        this.add((Block)FBContent.BLOCK_FRAMED_FANCY_POWERED_RAIL.value(), "Framed Fancy Powered Rail");
        this.add((Block)FBContent.BLOCK_FRAMED_FANCY_DETECTOR_RAIL.value(), "Framed Fancy Detector Rail");
        this.add((Block)FBContent.BLOCK_FRAMED_FANCY_ACTIVATOR_RAIL.value(), "Framed Fancy Activator Rail");
        this.add((Block)FBContent.BLOCK_FRAMED_FANCY_RAIL_SLOPE.value(), "Framed Fancy Rail Slope");
        this.add((Block)FBContent.BLOCK_FRAMED_FANCY_POWERED_RAIL_SLOPE.value(), "Framed Fancy Powered Rail Slope");
        this.add((Block)FBContent.BLOCK_FRAMED_FANCY_DETECTOR_RAIL_SLOPE.value(), "Framed Fancy Detector Rail Slope");
        this.add((Block)FBContent.BLOCK_FRAMED_FANCY_ACTIVATOR_RAIL_SLOPE.value(), "Framed Fancy Activator Rail Slope");
        this.add((Block)FBContent.BLOCK_FRAMED_FLOWER_POT.value(), "Framed Flower Pot");
        this.add((Block)FBContent.BLOCK_FRAMED_PILLAR.value(), "Framed Pillar");
        this.add((Block)FBContent.BLOCK_FRAMED_HALF_PILLAR.value(), "Framed Half Pillar");
        this.add((Block)FBContent.BLOCK_FRAMED_POST.value(), "Framed Post");
        this.add((Block)FBContent.BLOCK_FRAMED_COLLAPSIBLE_BLOCK.value(), "Framed Collapsible Block");
        this.add((Block)FBContent.BLOCK_FRAMED_COLLAPSIBLE_COPYCAT_BLOCK.value(), "Framed Collapsible Copycat Block");
        this.add((Block)FBContent.BLOCK_FRAMED_BOUNCY_CUBE.value(), "Framed Bouncy Cube");
        this.add((Block)FBContent.BLOCK_FRAMED_REDSTONE_BLOCK.value(), "Framed Redstone Block");
        this.add((Block)FBContent.BLOCK_FRAMED_PRISM.value(), "Framed Prism");
        this.add((Block)FBContent.BLOCK_FRAMED_ELEVATED_INNER_PRISM.value(), "Framed Inner Prism");
        this.add((Block)FBContent.BLOCK_FRAMED_ELEVATED_INNER_DOUBLE_PRISM.value(), "Framed Double Prism");
        this.add((Block)FBContent.BLOCK_FRAMED_SLOPED_PRISM.value(), "Framed Sloped Prism");
        this.add((Block)FBContent.BLOCK_FRAMED_ELEVATED_INNER_SLOPED_PRISM.value(), "Framed Inner Sloped Prism");
        this.add((Block)FBContent.BLOCK_FRAMED_ELEVATED_INNER_DOUBLE_SLOPED_PRISM.value(), "Framed Double Sloped Prism");
        this.add((Block)FBContent.BLOCK_FRAMED_SLOPE_SLAB.value(), "Framed Slope Slab");
        this.add((Block)FBContent.BLOCK_FRAMED_ELEVATED_SLOPE_SLAB.value(), "Framed Elevated Slope Slab");
        this.add((Block)FBContent.BLOCK_FRAMED_COMPOUND_SLOPE_SLAB.value(), "Framed Compound Slope Slab");
        this.add((Block)FBContent.BLOCK_FRAMED_DOUBLE_SLOPE_SLAB.value(), "Framed Double Slope Slab");
        this.add((Block)FBContent.BLOCK_FRAMED_INVERSE_DOUBLE_SLOPE_SLAB.value(), "Framed Inverted Double Slope Slab");
        this.add((Block)FBContent.BLOCK_FRAMED_ELEVATED_DOUBLE_SLOPE_SLAB.value(), "Framed Elevated Double Slope Slab");
        this.add((Block)FBContent.BLOCK_FRAMED_STACKED_SLOPE_SLAB.value(), "Framed Stacked Slope Slab");
        this.add((Block)FBContent.BLOCK_FRAMED_FLAT_SLOPE_SLAB_CORNER.value(), "Framed Flat Slope Slab Corner");
        this.add((Block)FBContent.BLOCK_FRAMED_FLAT_INNER_SLOPE_SLAB_CORNER.value(), "Framed Flat Inner Slope Slab Corner");
        this.add((Block)FBContent.BLOCK_FRAMED_FLAT_ELEVATED_SLOPE_SLAB_CORNER.value(), "Framed Flat Elevated Slope Slab Corner");
        this.add((Block)FBContent.BLOCK_FRAMED_FLAT_ELEVATED_INNER_SLOPE_SLAB_CORNER.value(), "Framed Flat Elevated Inner Slope Slab Corner");
        this.add((Block)FBContent.BLOCK_FRAMED_FLAT_DOUBLE_SLOPE_SLAB_CORNER.value(), "Framed Flat Double Slope Slab Corner");
        this.add((Block)FBContent.BLOCK_FRAMED_FLAT_INVERSE_DOUBLE_SLOPE_SLAB_CORNER.value(), "Framed Flat Inverse Double Slope Slab Corner");
        this.add((Block)FBContent.BLOCK_FRAMED_FLAT_ELEVATED_DOUBLE_SLOPE_SLAB_CORNER.value(), "Framed Flat Elevated Double Slope Slab Corner");
        this.add((Block)FBContent.BLOCK_FRAMED_FLAT_ELEVATED_INNER_DOUBLE_SLOPE_SLAB_CORNER.value(), "Framed Flat Elevated Inner Double Slope Slab Corner");
        this.add((Block)FBContent.BLOCK_FRAMED_FLAT_STACKED_SLOPE_SLAB_CORNER.value(), "Framed Flat Stacked Slope Slab Corner");
        this.add((Block)FBContent.BLOCK_FRAMED_FLAT_STACKED_INNER_SLOPE_SLAB_CORNER.value(), "Framed Flat Stacked Inner Slope Slab Corner");
        this.add((Block)FBContent.BLOCK_FRAMED_SLOPE_PANEL.value(), "Framed Slope Panel");
        this.add((Block)FBContent.BLOCK_FRAMED_EXTENDED_SLOPE_PANEL.value(), "Framed Extended Slope Panel");
        this.add((Block)FBContent.BLOCK_FRAMED_COMPOUND_SLOPE_PANEL.value(), "Framed Compound Slope Panel");
        this.add((Block)FBContent.BLOCK_FRAMED_DOUBLE_SLOPE_PANEL.value(), "Framed Double Slope Panel");
        this.add((Block)FBContent.BLOCK_FRAMED_INVERSE_DOUBLE_SLOPE_PANEL.value(), "Framed Inverted Double Slope Panel");
        this.add((Block)FBContent.BLOCK_FRAMED_EXTENDED_DOUBLE_SLOPE_PANEL.value(), "Framed Extended Double Slope Panel");
        this.add((Block)FBContent.BLOCK_FRAMED_STACKED_SLOPE_PANEL.value(), "Framed Stacked Slope Panel");
        this.add((Block)FBContent.BLOCK_FRAMED_FLAT_SLOPE_PANEL_CORNER.value(), "Framed Flat Slope Panel Corner");
        this.add((Block)FBContent.BLOCK_FRAMED_FLAT_INNER_SLOPE_PANEL_CORNER.value(), "Framed Flat Inner Slope Panel Corner");
        this.add((Block)FBContent.BLOCK_FRAMED_FLAT_EXTENDED_SLOPE_PANEL_CORNER.value(), "Framed Flat Extended Slope Panel Corner");
        this.add((Block)FBContent.BLOCK_FRAMED_FLAT_EXTENDED_INNER_SLOPE_PANEL_CORNER.value(), "Framed Flat Extended Inner Slope Panel Corner");
        this.add((Block)FBContent.BLOCK_FRAMED_FLAT_DOUBLE_SLOPE_PANEL_CORNER.value(), "Framed Flat Double Slope Panel Corner");
        this.add((Block)FBContent.BLOCK_FRAMED_FLAT_INVERSE_DOUBLE_SLOPE_PANEL_CORNER.value(), "Framed Flat Inverse Double Slope Panel Corner");
        this.add((Block)FBContent.BLOCK_FRAMED_FLAT_EXTENDED_DOUBLE_SLOPE_PANEL_CORNER.value(), "Framed Flat Extended Double Slope Panel Corner");
        this.add((Block)FBContent.BLOCK_FRAMED_FLAT_EXTENDED_INNER_DOUBLE_SLOPE_PANEL_CORNER.value(), "Framed Flat Extended Inner Double Slope Panel Corner");
        this.add((Block)FBContent.BLOCK_FRAMED_FLAT_STACKED_SLOPE_PANEL_CORNER.value(), "Framed Flat Stacked Slope Panel Corner");
        this.add((Block)FBContent.BLOCK_FRAMED_FLAT_STACKED_INNER_SLOPE_PANEL_CORNER.value(), "Framed Flat Stacked Inner Slope Panel Corner");
        this.add((Block)FBContent.BLOCK_FRAMED_SMALL_CORNER_SLOPE_PANEL.value(), "Framed Small Corner Slope Panel");
        this.add((Block)FBContent.BLOCK_FRAMED_SMALL_CORNER_SLOPE_PANEL_WALL.value(), "Framed Small Corner Slope Panel");
        this.add((Block)FBContent.BLOCK_FRAMED_LARGE_CORNER_SLOPE_PANEL.value(), "Framed Large Corner Slope Panel");
        this.add((Block)FBContent.BLOCK_FRAMED_LARGE_CORNER_SLOPE_PANEL_WALL.value(), "Framed Large Corner Slope Panel");
        this.add((Block)FBContent.BLOCK_FRAMED_SMALL_INNER_CORNER_SLOPE_PANEL.value(), "Framed Small Inner Corner Slope Panel");
        this.add((Block)FBContent.BLOCK_FRAMED_SMALL_INNER_CORNER_SLOPE_PANEL_WALL.value(), "Framed Small Inner Corner Slope Panel");
        this.add((Block)FBContent.BLOCK_FRAMED_LARGE_INNER_CORNER_SLOPE_PANEL.value(), "Framed Large Inner Corner Slope Panel");
        this.add((Block)FBContent.BLOCK_FRAMED_LARGE_INNER_CORNER_SLOPE_PANEL_WALL.value(), "Framed Large Inner Corner Slope Panel");
        this.add((Block)FBContent.BLOCK_FRAMED_SMALL_DOUBLE_CORNER_SLOPE_PANEL.value(), "Framed Small Double Corner Slope Panel");
        this.add((Block)FBContent.BLOCK_FRAMED_SMALL_DOUBLE_CORNER_SLOPE_PANEL_WALL.value(), "Framed Small Double Corner Slope Panel");
        this.add((Block)FBContent.BLOCK_FRAMED_LARGE_DOUBLE_CORNER_SLOPE_PANEL.value(), "Framed Large Double Corner Slope Panel");
        this.add((Block)FBContent.BLOCK_FRAMED_LARGE_DOUBLE_CORNER_SLOPE_PANEL_WALL.value(), "Framed Large Double Corner Slope Panel");
        this.add((Block)FBContent.BLOCK_FRAMED_INVERSE_DOUBLE_CORNER_SLOPE_PANEL.value(), "Framed Inverse Double Corner Slope Panel");
        this.add((Block)FBContent.BLOCK_FRAMED_INVERSE_DOUBLE_CORNER_SLOPE_PANEL_WALL.value(), "Framed Inverse Double Corner Slope Panel");
        this.add((Block)FBContent.BLOCK_FRAMED_EXTENDED_CORNER_SLOPE_PANEL.value(), "Framed Extended Corner Slope Panel");
        this.add((Block)FBContent.BLOCK_FRAMED_EXTENDED_CORNER_SLOPE_PANEL_WALL.value(), "Framed Extended Corner Slope Panel");
        this.add((Block)FBContent.BLOCK_FRAMED_EXTENDED_INNER_CORNER_SLOPE_PANEL.value(), "Framed Extended Inner Corner Slope Panel");
        this.add((Block)FBContent.BLOCK_FRAMED_EXTENDED_INNER_CORNER_SLOPE_PANEL_WALL.value(), "Framed Extended Inner Corner Slope Panel");
        this.add((Block)FBContent.BLOCK_FRAMED_EXTENDED_DOUBLE_CORNER_SLOPE_PANEL.value(), "Framed Extended Double Corner Slope Panel");
        this.add((Block)FBContent.BLOCK_FRAMED_EXTENDED_DOUBLE_CORNER_SLOPE_PANEL_WALL.value(), "Framed Extended Double Corner Slope Panel");
        this.add((Block)FBContent.BLOCK_FRAMED_EXTENDED_INNER_DOUBLE_CORNER_SLOPE_PANEL.value(), "Framed Extended Inner Double Slope Panel Corner");
        this.add((Block)FBContent.BLOCK_FRAMED_EXTENDED_INNER_DOUBLE_CORNER_SLOPE_PANEL_WALL.value(), "Framed Extended Inner Double Slope Panel Corner");
        this.add((Block)FBContent.BLOCK_FRAMED_STACKED_CORNER_SLOPE_PANEL.value(), "Framed Stacked Corner Slope Panel");
        this.add((Block)FBContent.BLOCK_FRAMED_STACKED_CORNER_SLOPE_PANEL_WALL.value(), "Framed Stacked Corner Slope Panel");
        this.add((Block)FBContent.BLOCK_FRAMED_STACKED_INNER_CORNER_SLOPE_PANEL.value(), "Framed Stacked Inner Corner Slope Panel");
        this.add((Block)FBContent.BLOCK_FRAMED_STACKED_INNER_CORNER_SLOPE_PANEL_WALL.value(), "Framed Stacked Inner Corner Slope Panel");
        this.add((Block)FBContent.BLOCK_FRAMED_GLOWING_CUBE.value(), "Framed Glowing Cube");
        this.add((Block)FBContent.BLOCK_FRAMED_PYRAMID.value(), "Framed Pyramid");
        this.add((Block)FBContent.BLOCK_FRAMED_PYRAMID_SLAB.value(), "Framed Pyramid Slab");
        this.add((Block)FBContent.BLOCK_FRAMED_HORIZONTAL_PANE.value(), "Framed Horizontal Pane");
        this.add((Block)FBContent.BLOCK_FRAMED_TARGET.value(), "Framed Target");
        this.add((Block)FBContent.BLOCK_FRAMED_GATE.value(), "Framed Gate");
        this.add((Block)FBContent.BLOCK_FRAMED_IRON_GATE.value(), "Framed Iron Gate");
        this.add((Block)FBContent.BLOCK_FRAMED_ITEM_FRAME.value(), "Framed Item Frame");
        this.add((Block)FBContent.BLOCK_FRAMED_GLOWING_ITEM_FRAME.value(), "Framed Glow Item Frame");
        this.add((Block)FBContent.BLOCK_FRAMED_MINI_CUBE.value(), "Framed Mini Cube");
        this.add((Block)FBContent.BLOCK_FRAMED_ONE_WAY_WINDOW.value(), "Framed One-Way Window");
        this.add((Block)FBContent.BLOCK_FRAMED_BOOKSHELF.value(), "Framed Bookshelf");
        this.add((Block)FBContent.BLOCK_FRAMED_CHISELED_BOOKSHELF.value(), "Framed Chiseled Bookshelf");
        this.add((Block)FBContent.BLOCK_FRAMED_CENTERED_SLAB.value(), "Framed Centered Slab");
        this.add((Block)FBContent.BLOCK_FRAMED_CENTERED_PANEL.value(), "Framed Centered Panel");
        this.add((Block)FBContent.BLOCK_FRAMED_MASONRY_CORNER_SEGMENT.value(), "Framed Masonry Corner Segment");
        this.add((Block)FBContent.BLOCK_FRAMED_MASONRY_CORNER.value(), "Framed Masonry Corner");
        this.add((Block)FBContent.BLOCK_FRAMED_CHECKERED_CUBE_SEGMENT.value(), "Framed Checkered Cube Segment");
        this.add((Block)FBContent.BLOCK_FRAMED_CHECKERED_CUBE.value(), "Framed Checkered Cube");
        this.add((Block)FBContent.BLOCK_FRAMED_CHECKERED_SLAB_SEGMENT.value(), "Framed Checkered Slab Segment");
        this.add((Block)FBContent.BLOCK_FRAMED_CHECKERED_SLAB.value(), "Framed Checkered Slab");
        this.add((Block)FBContent.BLOCK_FRAMED_CHECKERED_PANEL_SEGMENT.value(), "Framed Checkered Panel Segment");
        this.add((Block)FBContent.BLOCK_FRAMED_CHECKERED_PANEL.value(), "Framed Checkered Panel");
        this.add((Block)FBContent.BLOCK_FRAMED_TUBE.value(), "Framed Tube");
    }

    private void addSpecialBlockTranslations() {
        this.add((Block)FBContent.BLOCK_FRAMING_SAW.value(), "Framing Saw");
        this.add((Block)FBContent.BLOCK_POWERED_FRAMING_SAW.value(), "Powered Framing Saw");
    }

    private void addItemTranslations() {
        this.add((Item)FBContent.ITEM_FRAMED_HAMMER.value(), "Framed Hammer");
        this.add((Item)FBContent.ITEM_FRAMED_WRENCH.value(), "Framed Wrench");
        this.add((Item)FBContent.ITEM_FRAMED_BLUEPRINT.value(), "Framed Blueprint");
        this.add((Item)FBContent.ITEM_FRAMED_KEY.value(), "Framed Key");
        this.add((Item)FBContent.ITEM_FRAMED_SCREWDRIVER.value(), "Framed Screwdriver");
        this.add((Item)FBContent.ITEM_FRAMED_REINFORCEMENT.value(), "Framed Reinforcement");
        this.add("item.framedblocks.framing_saw_pattern", "Framing Saw Pattern");
    }

    private void addSpecialTranslations() {
        this.add("framedblocks.key.categories.framedblocks", "FramedBlocks");
        this.add(((KeyMapping)KeyMappings.KEYMAPPING_UPDATE_CULLING.get()).getName(), "Update culling cache");
        this.add(((KeyMapping)KeyMappings.KEYMAPPING_WIPE_CACHE.get()).getName(), "Clear model cache");
        this.add(((CreativeModeTab)FBContent.MAIN_TAB.value()).getDisplayName(), "FramedBlocks");
        this.add((Component)EmptyCamoContainer.CAMO_NAME, "Empty");
        this.add(JeiMessages.MSG_INVALID_RECIPE, "Invalid recipe");
        this.add(JeiMessages.MSG_TRANSFER_NOT_IMPLEMENTED, "Transfer not implemented, no items will be transferred");
        this.add(AtlasViewerCompat.LABEL_TEXTURE, "Texture");
        this.add(AtlasViewerCompat.LABEL_FRAMES, "Frames");
        this.add(JadeCompat.configTranslation(JadeCompat.ID_FRAMED_BLOCK), "FramedBlocks camo");
        this.add(JadeCompat.configTranslation(JadeCompat.ID_ITEM_FRAME), "Framed Item Frame");
        this.add(JadeCompat.LABEL_CAMO, "Camo: %s");
        this.add(JadeCompat.LABEL_CAMO_ONE, "Camo one: %s");
        this.add(JadeCompat.LABEL_CAMO_TWO, "Camo two: %s");
        this.add(Utils.TOOL_WRENCH, "Wrenches");
        this.add(Utils.DISABLE_INTANGIBLE, "Disable Intangibility");
    }

    private void addStatusMessageTranslations() {
        this.add(FramedBlockEntity.MSG_BLACKLISTED, "This block is disallowed as a camo!");
        this.add(FramedBlockEntity.MSG_BLOCK_ENTITY, "Blocks with BlockEntities cannot be inserted into framed blocks!");
        this.add(FramedBlockEntity.MSG_NON_SOLID, "Untagged non-solid blocks cannot be inserted into framed blocks!");
        this.add(IFramedBlock.LOCK_MESSAGE, "The state of this block is now %s");
    }

    private void addScreenTranslations() {
        this.add(FramedChestBlockEntity.TITLE, "Framed Chest");
        this.add(FramedStorageBlockEntity.TITLE, "Framed Secret Storage");
        this.add(FramedSignScreen.TITLE, "Edit sign");
        this.add(FramingSawBlock.SAW_MENU_TITLE, "Framing Saw");
        this.add(PoweredFramingSawBlock.POWERED_SAW_MENU_TITLE, "Powered Framing Saw");
        this.add(FramingSawScreen.TOOLTIP_MATERIAL, "Material value: %s");
        this.add(FramingSawScreen.TOOLTIP_LOOSE_ADDITIVE, "Item was crafted with additive ingredients, these will be lost");
        this.add(FramingSawScreen.TOOLTIP_HAVE_X_BUT_NEED_Y_ITEM, "Have %s, but need %s");
        this.add(FramingSawScreen.TOOLTIP_HAVE_X_BUT_NEED_Y_ITEM_MULTI, "Have %s, but need %s or listed alternatives");
        this.add(FramingSawScreen.TOOLTIP_HAVE_X_BUT_NEED_Y_TAG, "Have %s, but need any %s");
        this.add(FramingSawScreen.TOOLTIP_HAVE_X_BUT_NEED_Y_ITEM_COUNT, "Have %s item(s), but need at least %s item(s)");
        this.add(FramingSawScreen.TOOLTIP_HAVE_X_BUT_NEED_Y_MATERIAL_COUNT, "Have %s material, but need at least %s material");
        this.add(FramingSawScreen.TOOLTIP_OUTPUT_COUNT, "Result size: %s, max size: %s");
        this.add(FramingSawScreen.TOOLTIP_HAVE_ITEM_NONE, "none");
        this.add(FramingSawScreen.TOOLTIP_PRESS_TO_SHOW, "Press [%s] to show all possible items");
        this.add(FramingSawScreen.MSG_HINT_SEARCH, "Search...");
        this.add(FramingSawWithEncoderScreen.TOOLTIP_TAB_CRAFTING, "Crafting");
        this.add(FramingSawWithEncoderScreen.TOOLTIP_TAB_PATTERN, "AE2 Pattern Encoding");
        this.add(PoweredFramingSawScreen.TITLE_TARGETBLOCK, "Target:");
        this.add((Component)PoweredFramingSawScreen.MSG_STATUS, "Status: ");
        this.add(PoweredFramingSawScreen.MSG_STATUS_NO_RECIPE, "No recipe");
        this.add(PoweredFramingSawScreen.MSG_STATUS_NO_MATCH, "Recipe doesn't match");
        this.add(PoweredFramingSawScreen.MSG_STATUS_READY, "Ready");
        this.add(PoweredFramingSawScreen.TOOLTIP_STATUS_NO_RECIPE, "No recipe selected, click the target slot with any framed block to select a recipe");
        this.add(PoweredFramingSawScreen.TOOLTIP_ENERGY, "%s / %s FE");
        this.add(FramingSawRecipeMatchResult.SUCCESS.translation(), "Craftable");
        this.add(FramingSawRecipeMatchResult.MATERIAL_VALUE.translation(), "Insufficient input material available");
        this.add(FramingSawRecipeMatchResult.MATERIAL_LCM.translation(), "Too few input items to evenly convert to this output");
        this.add(FramingSawRecipeMatchResult.OUTPUT_SIZE.translation(), "Result count exceeds maximum result stack size");
        this.add(FramingSawRecipeMatchResult.MISSING_ADDITIVE_0.translation(), "Missing additive ingredient in the first slot");
        this.add(FramingSawRecipeMatchResult.MISSING_ADDITIVE_1.translation(), "Missing additive ingredient in the second slot");
        this.add(FramingSawRecipeMatchResult.MISSING_ADDITIVE_2.translation(), "Missing additive ingredient in the third slot");
        this.add(FramingSawRecipeMatchResult.UNEXPECTED_ADDITIVE_0.translation(), "Unexpected additive ingredient present in the first slot");
        this.add(FramingSawRecipeMatchResult.UNEXPECTED_ADDITIVE_1.translation(), "Unexpected additive ingredient present in the second slot");
        this.add(FramingSawRecipeMatchResult.UNEXPECTED_ADDITIVE_2.translation(), "Unexpected additive ingredient present in the third slot");
        this.add(FramingSawRecipeMatchResult.INCORRECT_ADDITIVE_0.translation(), "Incorrect additive ingredient present in the first slot");
        this.add(FramingSawRecipeMatchResult.INCORRECT_ADDITIVE_1.translation(), "Incorrect additive ingredient present in the second slot");
        this.add(FramingSawRecipeMatchResult.INCORRECT_ADDITIVE_2.translation(), "Incorrect additive ingredient present in the third slot");
        this.add(FramingSawRecipeMatchResult.INSUFFICIENT_ADDITIVE_0.translation(), "Insufficient amount of additive ingredient present in the first slot");
        this.add(FramingSawRecipeMatchResult.INSUFFICIENT_ADDITIVE_1.translation(), "Insufficient amount of additive ingredient present in the second slot");
        this.add(FramingSawRecipeMatchResult.INSUFFICIENT_ADDITIVE_2.translation(), "Insufficient amount of additive ingredient present in the third slot");
    }

    private void addTooltipTranslations() {
        this.add("desc.framedblocks.blueprint_block", "Contained Block: %s");
        this.add("desc.framedblocks.blueprint_camo", "Camo Block: %s");
        this.add("desc.framedblocks.blueprint_illuminated", "Illuminated: %s");
        this.add("desc.framedblocks.blueprint_intangible", "Intangible: %s");
        this.add("desc.framedblocks.blueprint_reinforced", "Reinforced: %s");
        this.add(FramedBlueprintItem.MISSING_MATERIALS, "[Framed Blueprint] Missing required materials:");
        this.add((Component)FramedBlueprintItem.BLOCK_NONE, "None");
        this.add((Component)FramedBlueprintItem.BLOCK_INVALID, "Invalid");
        this.add((Component)FramedBlueprintItem.FALSE, "false");
        this.add((Component)FramedBlueprintItem.TRUE, "true");
        this.add((Component)FramedBlueprintItem.CANT_COPY, "[Framed Blueprint] This block can currently not be copied!");
        this.add(FramedBlueprintItem.CANT_PLACE_FLUID_CAMO, "[Framed Blueprint] Copying blocks with fluid camos is currently not possible!");
        this.add(IFramedBlock.CAMO_LABEL, "Camo: %s");
    }

    private void addOverlayTranslations() {
        this.add(StateLockOverlay.LOCK_MESSAGE, "State %s");
        this.add(IFramedBlock.STATE_LOCKED, "locked");
        this.add(IFramedBlock.STATE_UNLOCKED, "unlocked");
        this.add(ToggleWaterloggableOverlay.MSG_IS_WATERLOGGABLE, "Block is waterloggable.");
        this.add(ToggleWaterloggableOverlay.MSG_IS_NOT_WATERLOGGABLE, "Block is not waterloggable.");
        this.add(ToggleWaterloggableOverlay.MSG_MAKE_WATERLOGGABLE, "Hit with a Framed Hammer to make waterloggable");
        this.add(ToggleWaterloggableOverlay.MSG_MAKE_NOT_WATERLOGGABLE, "Hit with a Framed Hammer to make not waterloggable");
        this.add(ToggleYSlopeOverlay.SLOPE_MESSAGE, "Block uses %s faces for vertical sloped faces.");
        this.add(ToggleYSlopeOverlay.TOGGLE_MESSAGE, "Hit with a Framed Wrench to switch to %s faces");
        this.add(ToggleYSlopeOverlay.SLOPE_HOR, "horizontal");
        this.add(ToggleYSlopeOverlay.SLOPE_VERT, "vertical");
        this.add(ToggleYSlopeOverlay.SLOPE_MESSAGE_ALT, "Block uses the %s face for horizontal sloped faces.");
        this.add(ToggleYSlopeOverlay.TOGGLE_MESSAGE_ALT, "Hit with a Framed Wrench to switch to the %s face");
        this.add(ToggleYSlopeOverlay.SLOPE_FRONT, "front");
        this.add(ToggleYSlopeOverlay.SLOPE_SIDE, "right");
        this.add(ReinforcementOverlay.REINFORCE_MESSAGE, "Block is %s.");
        this.add(ReinforcementOverlay.STATE_NOT_REINFORCED, "not reinforced");
        this.add(ReinforcementOverlay.STATE_REINFORCED, "reinforced");
        this.add(PrismOffsetOverlay.PRISM_OFFSET_FALSE, "Triangle texture is not offset.");
        this.add(PrismOffsetOverlay.PRISM_OFFSET_TRUE, "Triangle texture is offset by half a block.");
        this.add(PrismOffsetOverlay.MSG_SWITCH_OFFSET, "Hit with a Framed Hammer to toggle the offset");
        this.add(SplitLineOverlay.SPLIT_LINE_FALSE, "Split-line of the deformed face runs along the steep diagonal.");
        this.add(SplitLineOverlay.SPLIT_LINE_TRUE, "Split-line of the deformed face runs along the shallow diagonal.");
        this.add(SplitLineOverlay.MSG_SWITCH_SPLIT_LINE, "Hit with a Framed Hammer to switch the orientation of the split-line");
        this.add(OneWayWindowOverlay.LINE_CURR_FACE, "Current see-through side: %s");
        this.add(OneWayWindowOverlay.LINE_SET_FACE, "Hit with a Framed Wrench to set the see-through side to %s");
        this.add(OneWayWindowOverlay.LINE_CLEAR_FACE, "Hit with a Framed Wrench while crouching to clear see-through side");
        this.add(OneWayWindowOverlay.FACE_VALUE_LINES[NullableDirection.NONE.ordinal()], "None");
        this.add(OneWayWindowOverlay.FACE_VALUE_LINES[NullableDirection.DOWN.ordinal()], "Down");
        this.add(OneWayWindowOverlay.FACE_VALUE_LINES[NullableDirection.UP.ordinal()], "Up");
        this.add(OneWayWindowOverlay.FACE_VALUE_LINES[NullableDirection.NORTH.ordinal()], "North");
        this.add(OneWayWindowOverlay.FACE_VALUE_LINES[NullableDirection.SOUTH.ordinal()], "South");
        this.add(OneWayWindowOverlay.FACE_VALUE_LINES[NullableDirection.WEST.ordinal()], "West");
        this.add(OneWayWindowOverlay.FACE_VALUE_LINES[NullableDirection.EAST.ordinal()], "East");
        this.add(OneWayWindowOverlay.DIR_VALUE_LINES[Direction.DOWN.ordinal()], "Down");
        this.add(OneWayWindowOverlay.DIR_VALUE_LINES[Direction.UP.ordinal()], "Up");
        this.add(OneWayWindowOverlay.DIR_VALUE_LINES[Direction.NORTH.ordinal()], "North");
        this.add(OneWayWindowOverlay.DIR_VALUE_LINES[Direction.SOUTH.ordinal()], "South");
        this.add(OneWayWindowOverlay.DIR_VALUE_LINES[Direction.WEST.ordinal()], "West");
        this.add(OneWayWindowOverlay.DIR_VALUE_LINES[Direction.EAST.ordinal()], "East");
        this.add(OneWayWindowOverlay.FACE_VALUE_ABBRS[NullableDirection.NONE.ordinal()], "-");
        this.add(OneWayWindowOverlay.FACE_VALUE_ABBRS[NullableDirection.DOWN.ordinal()], "D");
        this.add(OneWayWindowOverlay.FACE_VALUE_ABBRS[NullableDirection.UP.ordinal()], "U");
        this.add(OneWayWindowOverlay.FACE_VALUE_ABBRS[NullableDirection.NORTH.ordinal()], "N");
        this.add(OneWayWindowOverlay.FACE_VALUE_ABBRS[NullableDirection.SOUTH.ordinal()], "S");
        this.add(OneWayWindowOverlay.FACE_VALUE_ABBRS[NullableDirection.WEST.ordinal()], "W");
        this.add(OneWayWindowOverlay.FACE_VALUE_ABBRS[NullableDirection.EAST.ordinal()], "E");
        this.add(FrameBackgroundOverlay.LINE_USE_CAMO_BG, "Framed Item Frame uses the camo as background");
        this.add(FrameBackgroundOverlay.LINE_USE_LEATHER_BG, "Framed Item Frame uses leather as background");
        this.add(FrameBackgroundOverlay.LINE_SET_CAMO_BG, "Hit with a Framed Hammer to use the camo as background");
        this.add(FrameBackgroundOverlay.LINE_SET_LEATHER_BG, "Hit with a Framed Hammer to use leather as background");
        this.add(CamoRotationOverlay.ROTATEABLE_FALSE, "The targetted camo cannot be rotated");
        this.add(CamoRotationOverlay.ROTATEABLE_TRUE, "The targetted camo can be rotated");
    }

    private void addConfigTranslations() {
        this.add("framedblocks.configuration.general", "General");
        this.add("framedblocks.configuration.powered_framing_saw", "Powered Framing Saw");
        this.add(ServerConfig.TRANSLATION_ALLOW_BLOCK_ENTITIES, "Allow BlockEntities");
        this.add(ServerConfig.TRANSLATION_ENABLE_INTANGIBILITY, "Enable intangibility feature");
        this.add(ServerConfig.TRANSLATION_INTANGIBLE_MARKER, "Intangibility marker item");
        this.add(ServerConfig.TRANSLATION_ONE_WAY_WINDOW_OWNABLE, "One-Way Window ownability");
        this.add(ServerConfig.TRANSLATION_CONSUME_CAMO_ITEM, "Consume camo item");
        this.add(ServerConfig.TRANSLATION_GLOWSTONE_LIGHT_LEVEL, "Glowstone Light Level");
        this.add(ServerConfig.TRANSLATION_FIREPROOF_BLOCKS, "Fireproof blocks");
        this.add(ServerConfig.TRANSLATION_POWERED_SAW_ENERGY_CAPACITY, "Energy Capacity");
        this.add(ServerConfig.TRANSLATION_POWERED_SAW_MAX_RECEIVE, "Max input");
        this.add(ServerConfig.TRANSLATION_POWERED_SAW_CONSUMPTION, "Consumption");
        this.add(ServerConfig.TRANSLATION_POWERED_SAW_RECIPE_DURATION, "Crafting Duration");
        this.add("framedblocks.configuration.overlay", "Overlays");
        this.add(ClientConfig.TRANSLATION_SHOW_GHOST_BLOCKS, "Show ghost blocks");
        this.add(ClientConfig.TRANSLATION_ALT_GHOST_RENDERER, "Use alternative placement preview renderer");
        this.add(ClientConfig.TRANSLATION_GHOST_RENDER_OPACITY, "Placement preview opacity");
        this.add(ClientConfig.TRANSLATION_FANCY_HITBOXES, "Fancy hitboxes");
        this.add(ClientConfig.TRANSLATION_DETAILED_CULLING, "Detailed culling");
        this.add(ClientConfig.TRANSLATION_USE_DISCRETE_UV_STEPS, "Use discrete UV steps");
        this.add(ClientConfig.TRANSLATION_CON_TEX_MODE, "Connected textures mode");
        this.add(ClientConfig.TRANSLATION_CAMO_MESSAGE_VERBOSITY, "Disallowed camo message verbosity");
        this.add(ClientConfig.TRANSLATION_FORCE_AO_ON_GLOWING_BLOCKS, "Force ambient occlusion on glowing framed blocks");
        this.add(ClientConfig.TRANSLATION_RENDER_ITEM_MODELS_WITH_CAMO, "Render item models with camo");
        this.add(ClientConfig.TRANSLATION_SHOW_ALL_RECIPE_PERMUTATIONS_IN_EMI, "Show all Framing Saw recipe permutations in EMI");
        this.add(ClientConfig.TRANSLATION_SOLID_FRAME_MODE, "Solid frame mode");
        this.add(ClientConfig.TRANSLATION_SHOW_BUTTON_PLATE_OVERLAY, "Show button and pressure plate type overlay");
        this.add(ClientConfig.TRANSLATION_SHOW_SPECIAL_CUBE_OVERLAY, "Show special cube type overlay");
        this.add(ClientConfig.TRANSLATION_RENDER_CAMO_IN_JADE, "Render camo in Jade overlay");
        this.add(ClientConfig.TRANSLATION_STATE_LOCK_MODE, "State lock overlay: Display mode");
        this.add(ClientConfig.TRANSLATION_TOGGLE_WATERLOG_MODE, "Toggle waterloggable overlay: Display mode");
        this.add(ClientConfig.TRANSLATION_TOGGLE_Y_SLOPE_MODE, "Toggle Y slope overlay: Display mode");
        this.add(ClientConfig.TRANSLATION_REINFORCEMENT_MODE, "Reinforcement overlay: Display mode");
        this.add(ClientConfig.TRANSLATION_PRISM_OFFSET_MODE, "Prism offset overlay: Display mode");
        this.add(ClientConfig.TRANSLATION_SPLIT_LINES_MODE, "Collapsible block split lines overlay: Display mode");
        this.add(ClientConfig.TRANSLATION_ONE_WAY_WINDOW_MODE, "One-Way Window overlay: Display mode");
        this.add(ClientConfig.TRANSLATION_FRAME_BACKGROUND_MODE, "Item Frame Background overlay: Display mode");
        this.add(ClientConfig.TRANSLATION_CAMO_ROTATION_MODE, "Camo Rotation overlay: Display mode");
        this.add("framedblocks.configuration.section.framedblocks.devtools.toml", "Dev Tools Settings");
        this.add("framedblocks.configuration.section.framedblocks.devtools.toml.title", "FramedBlocks Dev Tools Configuration");
        this.add(DevToolsConfig.TRANSLATION_DOUBLE_BLOCK_PART_DEBUG, "Double-block part debug");
        this.add(DevToolsConfig.TRANSLATION_CONNECTION_DEBUG, "ConnectionPredicate debug");
        this.add(DevToolsConfig.TRANSLATION_QUAD_WINDING_DEBUG, "Quad-winding debug");
        this.add(DevToolsConfig.TRANSLATION_STATE_MERGER_DEBUG, "StateMerger debug");
        this.add(DevToolsConfig.TRANSLATION_STATE_MERGER_DEBUG_FILTER, "StateMerger debug filter");
        this.add(DevToolsConfig.TRANSLATION_OCCLUSION_SHAPE_DEBUG, "Occlusion shape debug");
    }

    private void add(Component key, String value) {
        ComponentContents contents = key.getContents();
        if (contents instanceof TranslatableContents) {
            TranslatableContents translatable = (TranslatableContents)contents;
            this.add(translatable.getKey(), value);
        } else {
            this.add(key.getString(), value);
        }
    }
}

