/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.net.payload;

import java.util.List;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.FilteredText;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import xfacthd.framedblocks.FramedBlocks;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.blockentity.special.FramedSignBlockEntity;
import xfacthd.framedblocks.common.net.FramedByteBufCodecs;

public record ServerboundSignUpdatePayload(BlockPos pos, boolean front, String[] lines) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ServerboundSignUpdatePayload> TYPE = Utils.payloadType("sign_update");
    public static final StreamCodec<FriendlyByteBuf, ServerboundSignUpdatePayload> CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, ServerboundSignUpdatePayload::pos, (StreamCodec)ByteBufCodecs.BOOL, ServerboundSignUpdatePayload::front, FramedByteBufCodecs.array(ByteBufCodecs.stringUtf8((int)384), String[]::new, 4), ServerboundSignUpdatePayload::lines, ServerboundSignUpdatePayload::new);

    public CustomPacketPayload.Type<ServerboundSignUpdatePayload> type() {
        return TYPE;
    }

    public void handle(IPayloadContext ctx) {
        ServerPlayer player = (ServerPlayer)ctx.player();
        List<String> strippedLines = Stream.of(this.lines).map(ChatFormatting::stripFormatting).toList();
        player.connection.filterTextPacket(strippedLines).thenAccept(filteredText -> ctx.enqueueWork(() -> {
            BlockEntity patt0$temp;
            Level level = player.level();
            if (level.hasChunkAt(this.pos) && (patt0$temp = level.getBlockEntity(this.pos)) instanceof FramedSignBlockEntity) {
                FramedSignBlockEntity sign = (FramedSignBlockEntity)patt0$temp;
                if (sign.isWaxed() || !player.getUUID().equals(sign.getEditingPlayer())) {
                    FramedBlocks.LOGGER.warn("Player {} just tried to change non-editable sign at {}", (Object)player.getName().getString(), (Object)this.pos);
                    return;
                }
                player.resetLastActionTime();
                sign.updateTextFromPacket((Player)player, this.front, (List<FilteredText>)filteredText);
            }
        }));
    }
}

