/*
 * Decompiled with CFR 0.152.
 */
package com.frikinjay.letmedespawn.mixin;

import com.frikinjay.letmedespawn.LetMeDespawn;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Mob.class}, remap=false)
public abstract class MobMixin
extends LivingEntity {
    @Unique
    private boolean letmedespawn$pickedItems = false;
    @Shadow
    private boolean persistenceRequired;

    protected MobMixin(EntityType<? extends LivingEntity> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(at={@At(value="TAIL")}, method={"setItemSlotAndDropWhenKilled"})
    private void letmedespawn$setItemSlotAndDropWhenKilled(EquipmentSlot p_21469_, ItemStack p_21470_, CallbackInfo info) {
        EquipmentSlot equipmentSlot = this.getEquipmentSlotForItem(p_21470_);
        ItemStack itemStack = this.getItemBySlot(equipmentSlot);
        CustomData component = (CustomData)itemStack.get(DataComponents.CUSTOM_DATA);
        CompoundTag nbt = component != null ? component.copyTag() : new CompoundTag();
        nbt.putBoolean("picked", true);
        itemStack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)nbt));
        this.letmedespawn$pickedItems = true;
        this.persistenceRequired = LetMeDespawn.config.getMobNames().contains(BuiltInRegistries.ENTITY_TYPE.getKey((Object)this.getType()).toString()) || this.hasCustomName();
    }

    @Redirect(method={"checkDespawn"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/Mob;discard()V"))
    private void letmedespawn$yeetusCheckus(Mob instance) {
        if (this.letmedespawn$pickedItems) {
            this.letmedespawn$dropEquipmentOnDespawn();
        }
        this.discard();
    }

    @Unique
    protected void letmedespawn$dropEquipmentOnDespawn() {
        for (EquipmentSlot equipmentSlot : EquipmentSlot.values()) {
            ItemStack itemStack = this.getItemBySlot(equipmentSlot);
            if (itemStack.isEmpty() || !((CustomData)itemStack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).contains("picked") || EnchantmentHelper.has((ItemStack)itemStack, (DataComponentType)EnchantmentEffectComponents.PREVENT_EQUIPMENT_DROP)) continue;
            this.spawnAtLocation(itemStack);
            this.setItemSlot(equipmentSlot, ItemStack.EMPTY);
        }
    }
}

