/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.block;

import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.block.HangingStrandBottomBlock;
import biomesoplenty.init.ModParticles;
import biomesoplenty.init.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class FleshTendonsBottomBlock
extends HangingStrandBottomBlock {
    public FleshTendonsBottomBlock(BlockBehaviour.Properties p_i241195_1_) {
        super(p_i241195_1_);
    }

    @Override
    protected Block getBodyBlock() {
        return BOPBlocks.FLESH_TENDONS_STRAND;
    }

    @Override
    public boolean canSurvive(BlockState p_196260_1_, LevelReader p_196260_2_, BlockPos p_196260_3_) {
        BlockPos blockpos = p_196260_3_.relative(this.growthDirection.getOpposite());
        BlockState blockstate = p_196260_2_.getBlockState(blockpos);
        Block block = blockstate.getBlock();
        if (!this.canAttachTo(blockstate)) {
            return false;
        }
        return block == this.getHeadBlock() || block == this.getBodyBlock() || blockstate.is(ModTags.Blocks.FLESH);
    }

    public void animateTick(BlockState stateIn, Level worldIn, BlockPos pos, RandomSource rand) {
        super.animateTick(stateIn, worldIn, pos, rand);
        if (rand.nextInt(7) == 0) {
            worldIn.addAlwaysVisibleParticle((ParticleOptions)ModParticles.DRIPPING_BLOOD, (double)pos.getX() + 0.5 + (rand.nextDouble() - rand.nextDouble()) / 2.0, (double)pos.getY() + 0.5 + (rand.nextDouble() - rand.nextDouble()) / 2.0, (double)pos.getZ() + 0.5 + (rand.nextDouble() - rand.nextDouble()) / 2.0, 0.0, 0.0, 0.0);
        }
    }
}

