/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.block;

import com.mojang.serialization.MapCodec;
import com.stal111.forbidden_arcanus.common.block.entity.NipaBlockEntity;
import com.stal111.forbidden_arcanus.common.block.properties.ModBlockStateProperties;
import com.stal111.forbidden_arcanus.core.init.ModBlockEntities;
import com.stal111.forbidden_arcanus.core.init.ModItems;
import com.stal111.forbidden_arcanus.core.init.ModParticles;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class NipaBlock
extends BushBlock
implements EntityBlock {
    public static final MapCodec<NipaBlock> CODEC = NipaBlock.simpleCodec(NipaBlock::new);
    public static final BooleanProperty SPECK = ModBlockStateProperties.SPECK;
    private static final VoxelShape SHAPE = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)11.0, (double)14.0);

    public NipaBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)SPECK, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    protected MapCodec<? extends BushBlock> codec() {
        return CODEC;
    }

    @Nonnull
    public VoxelShape getShape(@Nonnull BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return SHAPE;
    }

    @Nullable
    public BlockEntity newBlockEntity(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return new NipaBlockEntity(pos, state);
    }

    public boolean canBeReplaced(@Nonnull BlockState state, @Nonnull BlockPlaceContext useContext) {
        return false;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult result) {
        BlockEntity blockEntity;
        if (((Boolean)state.getValue((Property)SPECK)).booleanValue() && (blockEntity = level.getBlockEntity(pos)) instanceof NipaBlockEntity) {
            NipaBlockEntity blockEntity2 = (NipaBlockEntity)blockEntity;
            this.harvestSpeck(state, level, pos, blockEntity2);
            return InteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        return super.useWithoutItem(state, level, pos, player, result);
    }

    public void onRemove(BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, BlockState newState, boolean isMoving) {
        NipaBlockEntity blockEntity;
        if (!state.is(newState.getBlock()) && ((Boolean)state.getValue((Property)SPECK)).booleanValue() && (blockEntity = (NipaBlockEntity)level.getBlockEntity(pos)) != null) {
            level.addFreshEntity((Entity)new ItemEntity(level, (double)pos.getX() + 0.5, (double)pos.getY() + blockEntity.getSpeckHeight(), (double)pos.getZ() + 0.5, new ItemStack((ItemLike)ModItems.ARCANE_CRYSTAL_DUST_SPECK.get())));
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }

    public void neighborChanged(@Nonnull BlockState state, Level level, @Nonnull BlockPos pos, @Nonnull Block block, @Nonnull BlockPos fromPos, boolean isMoving) {
        NipaBlockEntity blockEntity = (NipaBlockEntity)level.getBlockEntity(pos);
        if (blockEntity != null) {
            int power = level.getBestNeighborSignal(pos);
            if (((Boolean)state.getValue((Property)SPECK)).booleanValue() && blockEntity.getCachedPower() != power && power != 0) {
                this.harvestSpeck(state, level, pos, blockEntity);
            }
            blockEntity.setCachedPower(power);
        }
        super.neighborChanged(state, level, pos, block, fromPos, isMoving);
    }

    public void animateTick(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull RandomSource random) {
        if (Objects.requireNonNull(Minecraft.getInstance().player).getInventory().contains(ModItems.Stacks.LENS_OF_VERITATIS)) {
            double j = 0.4 * (double)random.nextFloat();
            double k = 0.4 * (double)random.nextFloat();
            double posX = (double)pos.getX() + 0.5 + (random.nextBoolean() ? j : -j);
            double posY = (double)pos.getY() + 0.1 + (double)random.nextFloat() / 2.5;
            double posZ = (double)pos.getZ() + 0.5 + (random.nextBoolean() ? k : -k);
            double ySpeed = ((double)random.nextFloat() - 0.4) * 0.1;
            level.addParticle((ParticleOptions)ModParticles.AUREAL_MOTE.get(), posX, posY, posZ, 0.0, ySpeed, 0.0);
        }
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(@Nonnull Level level, @Nonnull BlockState state, @Nonnull BlockEntityType<T> blockEntityType) {
        if (level.isClientSide() && ((Boolean)state.getValue((Property)SPECK)).booleanValue()) {
            return BaseEntityBlock.createTickerHelper(blockEntityType, (BlockEntityType)((BlockEntityType)ModBlockEntities.NIPA.get()), NipaBlockEntity::clientTick);
        }
        if (!level.isClientSide()) {
            return BaseEntityBlock.createTickerHelper(blockEntityType, (BlockEntityType)((BlockEntityType)ModBlockEntities.NIPA.get()), NipaBlockEntity::serverTick);
        }
        return null;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{SPECK});
    }

    private void harvestSpeck(BlockState state, Level world, BlockPos pos, NipaBlockEntity blockEntity) {
        world.addFreshEntity((Entity)new ItemEntity(world, (double)pos.getX() + 0.5, (double)pos.getY() + blockEntity.getSpeckHeight(), (double)pos.getZ() + 0.5, new ItemStack((ItemLike)ModItems.ARCANE_CRYSTAL_DUST_SPECK.get())));
        world.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)SPECK, (Comparable)Boolean.valueOf(false)));
        blockEntity.setSpeckHeight(10);
    }
}

