/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.block.clibano;

import com.mojang.serialization.DynamicOps;
import com.stal111.forbidden_arcanus.ForbiddenArcanus;
import com.stal111.forbidden_arcanus.common.block.entity.clibano.ClibanoFireType;
import com.stal111.forbidden_arcanus.common.block.entity.clibano.ClibanoFrameBlockEntity;
import com.stal111.forbidden_arcanus.common.block.entity.clibano.ClibanoMainBlockEntity;
import com.stal111.forbidden_arcanus.common.block.entity.clibano.ResiduesStorage;
import com.stal111.forbidden_arcanus.core.init.other.ModPOITypes;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.NbtOps;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractClibanoFrameBlock
extends Block
implements EntityBlock {
    public static final ResourceLocation DYNAMIC_DROP_ID = ForbiddenArcanus.location("dynamic_block");

    public AbstractClibanoFrameBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new ClibanoFrameBlockEntity(pos, state);
    }

    public abstract DirectionProperty getFacingProperty();

    public BlockState updateAppearance(BlockState state, boolean isLit, ClibanoFireType fireType) {
        return state;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult result) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.getPoiManager().find(poiType -> poiType.value() == ModPOITypes.CLIBANO_MAIN_PART.get(), blockPos -> !level.getBlockState(blockPos).isAir(), pos, 2, PoiManager.Occupancy.ANY).ifPresent(blockPos -> {
                BlockEntity blockEntity = level.getBlockEntity(blockPos);
                if (blockEntity instanceof ClibanoMainBlockEntity) {
                    ClibanoMainBlockEntity clibanoMainBlockEntity = (ClibanoMainBlockEntity)blockEntity;
                    player.openMenu((MenuProvider)clibanoMainBlockEntity, buffer -> buffer.writeWithCodec((DynamicOps)RegistryOps.create((DynamicOps)NbtOps.INSTANCE, (HolderLookup.Provider)level.registryAccess()), ResiduesStorage.MAP_CODEC, clibanoMainBlockEntity.getResiduesStorage().getResidueTypeAmountMap()));
                }
            });
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide());
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.is(newState.getBlock())) {
            return;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof ClibanoFrameBlockEntity) {
            ClibanoFrameBlockEntity clibanoFrameBlockEntity = (ClibanoFrameBlockEntity)blockEntity;
            BlockPos mainPos = clibanoFrameBlockEntity.getFrameData().mainPos();
            level.removeBlock(mainPos, false);
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }

    public BlockState rotate(BlockState state, LevelAccessor level, BlockPos pos, Rotation rotation) {
        return (BlockState)state.setValue((Property)this.getFacingProperty(), (Comparable)rotation.rotate((Direction)state.getValue((Property)this.getFacingProperty())));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return (BlockState)state.setValue((Property)this.getFacingProperty(), (Comparable)mirror.mirror((Direction)state.getValue((Property)this.getFacingProperty())));
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        BlockEntity blockentity = (BlockEntity)builder.getOptionalParameter(LootContextParams.BLOCK_ENTITY);
        if (blockentity instanceof ClibanoFrameBlockEntity) {
            ClibanoFrameBlockEntity clibanoFrameBlockEntity = (ClibanoFrameBlockEntity)blockentity;
            builder.withDynamicDrop(DYNAMIC_DROP_ID, consumer -> consumer.accept(new ItemStack((ItemLike)clibanoFrameBlockEntity.getFrameData().replaceState().getBlock())));
        }
        return super.getDrops(state, builder);
    }
}

