/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.block.entity;

import com.stal111.forbidden_arcanus.common.block.entity.forge.essence.EssenceType;
import com.stal111.forbidden_arcanus.common.block.properties.ModBlockStateProperties;
import com.stal111.forbidden_arcanus.common.essence.EssenceData;
import com.stal111.forbidden_arcanus.common.essence.EssenceStorage;
import com.stal111.forbidden_arcanus.core.init.ModBlockEntities;
import com.stal111.forbidden_arcanus.core.init.ModDataComponents;
import com.stal111.forbidden_arcanus.core.init.ModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EssenceUtremJarBlockEntity
extends BlockEntity {
    public static final String TAG_AMOUNT = "essence_amount";
    public static final String TAG_LIMIT = "essence_limit";
    public static final int DEFAULT_LIMIT = 10000;
    public final AnimationState rotateAnimation = new AnimationState();
    private int tickCount = -1;
    private int amount = 0;
    private int limit = 10000;

    public EssenceUtremJarBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.ESSENCE_UTREM_JAR.get(), pos, state);
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, EssenceUtremJarBlockEntity blockEntity) {
        blockEntity.rotateAnimation.startIfStopped(blockEntity.tickCount);
        ++blockEntity.tickCount;
    }

    public ItemStack getAsItem() {
        ItemStack stack = ((BlockItem)ModItems.ESSENCE_UTREM_JAR.get()).getDefaultInstance();
        stack.applyComponents(this.collectComponents());
        return stack;
    }

    public void addEssence(int amount) {
        this.amount = Math.min(this.amount + amount, this.limit);
        this.setChanged();
    }

    public int getAmount() {
        return this.amount;
    }

    public int getLimit() {
        return this.limit;
    }

    public int getTickCount() {
        return this.tickCount;
    }

    protected void saveAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider lookupProvider) {
        super.saveAdditional(tag, lookupProvider);
        tag.putInt(TAG_AMOUNT, this.amount);
        tag.putInt(TAG_LIMIT, this.limit);
    }

    protected void loadAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider lookupProvider) {
        super.loadAdditional(tag, lookupProvider);
        this.amount = tag.getInt(TAG_AMOUNT);
        this.limit = tag.getInt(TAG_LIMIT);
    }

    protected void applyImplicitComponents(@NotNull BlockEntity.DataComponentInput input) {
        super.applyImplicitComponents(input);
        EssenceStorage storage = (EssenceStorage)input.get(ModDataComponents.ESSENCE_STORAGE);
        if (storage != null) {
            this.amount = storage.data().amount();
            this.limit = storage.limit();
        }
    }

    protected void collectImplicitComponents(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull DataComponentMap.Builder builder) {
        super.collectImplicitComponents(builder);
        builder.set(ModDataComponents.ESSENCE_STORAGE, (Object)new EssenceStorage(EssenceData.of((EssenceType)((Object)this.getBlockState().getValue(ModBlockStateProperties.ESSENCE_TYPE)), this.amount), this.limit, true));
    }

    public void removeComponentsFromTag(@NotNull CompoundTag tag) {
        super.removeComponentsFromTag(tag);
        tag.remove(TAG_AMOUNT);
        tag.remove(TAG_LIMIT);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    @NotNull
    public CompoundTag getUpdateTag(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider lookupProvider) {
        return this.saveWithoutMetadata(lookupProvider);
    }
}

