/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.block.entity;

import com.stal111.forbidden_arcanus.common.block.entity.forge.essence.EssenceType;
import com.stal111.forbidden_arcanus.common.block.properties.ModBlockStateProperties;
import com.stal111.forbidden_arcanus.common.essence.EssenceHelper;
import com.stal111.forbidden_arcanus.core.init.ModBlockEntities;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;

public class NipaBlockEntity
extends BlockEntity {
    private int lastSpeck = 0;
    private int speckHeight = 10;
    private Map<UUID, Integer> players = new HashMap<UUID, Integer>();
    private int cachedPower = 0;

    public NipaBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.NIPA.get(), pos, state);
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, NipaBlockEntity blockEntity) {
        if (blockEntity.speckHeight < 75) {
            ++blockEntity.speckHeight;
        }
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, NipaBlockEntity blockEntity) {
        if (!((Boolean)state.getValue((Property)ModBlockStateProperties.SPECK)).booleanValue()) {
            ++blockEntity.lastSpeck;
            if (blockEntity.lastSpeck >= 3600) {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)ModBlockStateProperties.SPECK, (Comparable)Boolean.valueOf(true)));
                blockEntity.lastSpeck = 0;
            }
        }
        if (level.getGameTime() % 20L == 0L) {
            AABB axisAlignedBB = new AABB(pos).inflate(3.0);
            List playersInRange = level.getEntitiesOfClass(ServerPlayer.class, axisAlignedBB);
            HashMap<UUID, Integer> players = new HashMap<UUID, Integer>();
            for (ServerPlayer player : playersInRange) {
                UUID uuid = player.getUUID();
                players.put(uuid, blockEntity.players.getOrDefault(uuid, 0) + 1);
                if ((Integer)players.get(uuid) != 30) continue;
                EssenceHelper.getEssenceProvider((LivingEntity)player).ifPresent(provider -> provider.updateAmount(EssenceType.AUREAL, integer -> integer + 1));
                players.remove(uuid);
            }
            blockEntity.players = players;
        }
    }

    protected void loadAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider lookupProvider) {
        super.loadAdditional(tag, lookupProvider);
        this.lastSpeck = tag.getInt("LastSpeck");
        this.players.clear();
        ListTag players = tag.getList("Players", 10);
        players.forEach(nbt -> {
            if (nbt instanceof CompoundTag) {
                CompoundTag player = (CompoundTag)nbt;
                this.players.put(player.getUUID("Player"), player.getInt("Time"));
            }
        });
    }

    public void saveAdditional(@Nonnull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider lookupProvider) {
        super.saveAdditional(tag, lookupProvider);
        tag.putInt("LastSpeck", this.lastSpeck);
        ListTag players = new ListTag();
        this.players.forEach((uuid, integer) -> {
            CompoundTag player = new CompoundTag();
            player.putUUID("Player", uuid);
            player.putInt("Time", integer.intValue());
            players.add((Object)player);
        });
        tag.put("Players", (Tag)players);
    }

    public double getSpeckHeight() {
        return (float)this.speckHeight / 100.0f;
    }

    public void setSpeckHeight(int speckHeight) {
        this.speckHeight = speckHeight;
    }

    public int getCachedPower() {
        return this.cachedPower;
    }

    public void setCachedPower(int cachedPower) {
        this.cachedPower = cachedPower;
    }
}

