/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.block.entity.clibano.logic;

import com.stal111.forbidden_arcanus.common.block.entity.clibano.ClibanoFireType;
import com.stal111.forbidden_arcanus.common.block.entity.clibano.logic.ClibanoAccessor;
import com.stal111.forbidden_arcanus.common.item.crafting.ClibanoRecipe;
import java.util.List;
import net.minecraft.util.Mth;
import net.minecraft.world.item.crafting.RecipeHolder;

public abstract class ClibanoSmeltLogic {
    public final ClibanoAccessor clibano;
    public int[] cookingProgress = new int[2];
    public int[] cookingDuration = new int[2];

    protected ClibanoSmeltLogic(ClibanoAccessor clibano) {
        this.clibano = clibano;
    }

    public void tick(boolean isLit) {
        if (!isLit) {
            this.cookingProgress[0] = Mth.clamp((int)0, (int)(this.cookingProgress[0] - 2), (int)this.cookingDuration[0]);
            this.cookingProgress[1] = Mth.clamp((int)0, (int)(this.cookingProgress[1] - 2), (int)this.cookingDuration[1]);
        }
    }

    public abstract boolean canSmelt();

    public abstract void onFireTypeChange(ClibanoFireType var1);

    public void resetCookingProgress(int slot) {
        this.cookingProgress[slot] = 0;
    }

    public abstract void updateRecipes(List<RecipeHolder<ClibanoRecipe>> var1);

    protected void updateCookingProgress(ClibanoFireType fireType, RecipeHolder<ClibanoRecipe> recipeHolder, int slot) {
        if (recipeHolder != null) {
            int oldDuration = this.cookingDuration[slot];
            this.cookingDuration[slot] = ((ClibanoRecipe)recipeHolder.value()).getCookingTime(fireType);
            this.cookingProgress[slot] = (int)((float)this.cookingProgress[slot] / (float)oldDuration * (float)this.cookingDuration[slot]);
        }
    }
}

