/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.block.entity.forge.ritual;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.stal111.forbidden_arcanus.common.block.entity.forge.TierPredicate;
import com.stal111.forbidden_arcanus.common.block.entity.forge.essence.EssencesDefinition;
import com.stal111.forbidden_arcanus.common.item.enhancer.EnhancerDefinition;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import org.jetbrains.annotations.Nullable;

public record RitualRequirements(EssencesDefinition essences, TierPredicate tier, Optional<HolderSet<EnhancerDefinition>> enhancers) {
    public static final RitualRequirements NONE = new RitualRequirements(EssencesDefinition.EMPTY, TierPredicate.ANY, Optional.empty());
    public static final MapCodec<RitualRequirements> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)EssencesDefinition.CODEC.fieldOf("essences").forGetter(ritual -> ritual.essences), (App)TierPredicate.CODEC.forGetter(requirements -> requirements.tier), (App)EnhancerDefinition.LIST_CODEC.optionalFieldOf("enhancers").forGetter(requirements -> requirements.enhancers)).apply((Applicative)instance, RitualRequirements::new));

    public static Builder builder(EssencesDefinition essences) {
        return new Builder(essences);
    }

    public boolean checkRequirements(int forgeTier, HolderSet<EnhancerDefinition> enhancers) {
        if (!this.tier.test(forgeTier)) {
            return false;
        }
        for (Holder enhancer : this.enhancers.orElse((HolderSet<EnhancerDefinition>)HolderSet.empty())) {
            if (enhancers.contains(enhancer)) continue;
            return false;
        }
        return true;
    }

    public static class Builder {
        private final EssencesDefinition essences;
        private TierPredicate tier = TierPredicate.ANY;
        @Nullable
        private HolderSet<EnhancerDefinition> enhancers;

        private Builder(EssencesDefinition essences) {
            this.essences = essences;
        }

        public Builder tier(TierPredicate tier) {
            this.tier = tier;
            return this;
        }

        public Builder enhancer(Holder<EnhancerDefinition> enhancer) {
            this.enhancers = HolderSet.direct((Holder[])new Holder[]{enhancer});
            return this;
        }

        public Builder enhancers(HolderSet<EnhancerDefinition> enhancers) {
            this.enhancers = enhancers;
            return this;
        }

        public RitualRequirements build() {
            return new RitualRequirements(this.essences, this.tier, Optional.ofNullable(this.enhancers));
        }
    }
}

