/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.effect;

import com.stal111.forbidden_arcanus.core.init.ModMobEffects;
import com.stal111.forbidden_arcanus.util.ModUtils;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.server.ServerScoreboard;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ambient.AmbientCreature;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Scoreboard;

public class SpectralEyeEffect
extends MobEffect {
    private static final int EFFECT_RADIUS = 60;

    public SpectralEyeEffect(MobEffectCategory effectCategory, int color) {
        super(effectCategory, color);
    }

    public boolean applyEffectTick(LivingEntity entity, int amplifier) {
        int i = entity.getEffect(ModMobEffects.SPECTRAL_VISION).getDuration();
        if (!entity.getCommandSenderWorld().isClientSide()) {
            ServerScoreboard scoreboard = entity.getCommandSenderWorld().getServer().getScoreboard();
            PlayerTeam teamPassiveOrNeutral = ModUtils.createTeam((Scoreboard)scoreboard, "PassiveOrNeutral", ChatFormatting.GREEN);
            PlayerTeam teamHostile = ModUtils.createTeam((Scoreboard)scoreboard, "Hostile", ChatFormatting.RED);
            PlayerTeam teamWater = ModUtils.createTeam((Scoreboard)scoreboard, "Water", ChatFormatting.BLUE);
            double k = entity.getX();
            double l = entity.getY();
            double i1 = entity.getZ();
            AABB aabb = new AABB(k, l, i1, k + 1.0, l + 1.0, i1 + 1.0).inflate(60.0).expandTowards(0.0, (double)entity.level().getMaxBuildHeight(), 0.0);
            List list = entity.level().getEntitiesOfClass(LivingEntity.class, aabb);
            for (LivingEntity livingEntity : list) {
                if (livingEntity instanceof Animal || livingEntity instanceof AmbientCreature) {
                    scoreboard.addPlayerToTeam(livingEntity.getScoreboardName(), teamPassiveOrNeutral);
                } else if (livingEntity instanceof Monster) {
                    scoreboard.addPlayerToTeam(livingEntity.getScoreboardName(), teamHostile);
                } else if (!(livingEntity instanceof Player)) {
                    scoreboard.addPlayerToTeam(livingEntity.getScoreboardName(), teamWater);
                }
                livingEntity.addEffect(new MobEffectInstance(MobEffects.GLOWING, 5, 0, true, true, false));
            }
            if (i <= 5) {
                ModUtils.removeTeam((Scoreboard)scoreboard, teamPassiveOrNeutral);
                ModUtils.removeTeam((Scoreboard)scoreboard, teamHostile);
                ModUtils.removeTeam((Scoreboard)scoreboard, teamWater);
            }
        }
        return true;
    }
}

