/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.entity.lostsoul;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Dynamic;
import com.stal111.forbidden_arcanus.ForbiddenArcanus;
import com.stal111.forbidden_arcanus.common.entity.lostsoul.LostSoulAi;
import com.stal111.forbidden_arcanus.common.entity.lostsoul.SoulExtractable;
import com.stal111.forbidden_arcanus.core.init.ModEntities;
import com.stal111.forbidden_arcanus.core.init.ModItems;
import com.stal111.forbidden_arcanus.core.init.ModMemoryModules;
import com.stal111.forbidden_arcanus.core.init.other.ModActivities;
import com.stal111.forbidden_arcanus.data.ModDamageTypes;
import com.stal111.forbidden_arcanus.util.ModTags;
import java.util.Arrays;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public class LostSoul
extends PathfinderMob
implements SoulExtractable {
    protected static final ImmutableList<MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of((Object)MemoryModuleType.LOOK_TARGET, (Object)MemoryModuleType.NEAREST_LIVING_ENTITIES, (Object)MemoryModuleType.WALK_TARGET, (Object)MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE, (Object)MemoryModuleType.PATH, (Object)MemoryModuleType.HURT_BY, (Object)MemoryModuleType.HURT_BY_ENTITY, (Object)MemoryModuleType.IS_IN_WATER, (Object)MemoryModuleType.IS_PANICKING, (Object)((MemoryModuleType)ModMemoryModules.SCARED_TIME.get()));
    protected static final ImmutableList<SensorType<? extends Sensor<? super LostSoul>>> SENSOR_TYPES = ImmutableList.of((Object)SensorType.NEAREST_LIVING_ENTITIES, (Object)SensorType.HURT_BY, (Object)SensorType.IS_IN_WATER);
    private static final EntityDataAccessor<Integer> DATA_VARIANT = SynchedEntityData.defineId(LostSoul.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Boolean> DATA_SCARED = SynchedEntityData.defineId(LostSoul.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final double ENCHANTED_CHANCE = 0.04;
    public static final double ENTITY_DEATH_SPAWN_CHANCE = 0.05;
    private static final int EXTRACT_STUNNED_TIME = 30;
    private static final float EXTRACT_DAMAGE = 2.0f;
    private int extractCounter = 0;
    public final AnimationState stillAnimationState = new AnimationState();
    public final AnimationState fearAnimationState = new AnimationState();

    public LostSoul(Level level, double x, double y, double z) {
        this((EntityType<? extends PathfinderMob>)((EntityType)ModEntities.LOST_SOUL.get()), level);
        this.setPos(x, y, z);
    }

    public LostSoul(EntityType<? extends PathfinderMob> entityType, Level level) {
        super(entityType, level);
        this.setPathfindingMalus(PathType.BLOCKED, 16.0f);
        this.setPathfindingMalus(PathType.DANGER_FIRE, 16.0f);
        this.setPathfindingMalus(PathType.DAMAGE_FIRE, -1.0f);
        this.moveControl = new FlyingMoveControl((Mob)this, 15, true);
        this.noPhysics = true;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 14.0).add(Attributes.FLYING_SPEED, 0.5).add(Attributes.MOVEMENT_SPEED, 0.3);
    }

    public static boolean canSpawn(EntityType<LostSoul> entityType, LevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return true;
    }

    protected void actuallyHurt(@Nonnull DamageSource source, float amount) {
        if (source.is(ModDamageTypes.EXTRACT_SOUL)) {
            super.actuallyHurt(source, amount);
        }
    }

    public void knockback(double strength, double x, double z) {
    }

    @Nonnull
    protected Brain.Provider<LostSoul> brainProvider() {
        return Brain.provider(MEMORY_TYPES, SENSOR_TYPES);
    }

    @Nonnull
    protected Brain<?> makeBrain(@Nonnull Dynamic<?> dynamic) {
        return LostSoulAi.makeBrain((Brain<LostSoul>)this.brainProvider().makeBrain(dynamic));
    }

    @Nonnull
    public Brain<LostSoul> getBrain() {
        return super.getBrain();
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(@Nonnull ServerLevelAccessor level, @Nonnull DifficultyInstance difficulty, @Nonnull MobSpawnType reason, @Nullable SpawnGroupData spawnData) {
        boolean enchanted;
        boolean bl = enchanted = this.random.nextDouble() < 0.04;
        if (enchanted) {
            this.setVariant(Variant.ENCHANTED_LOST_SOUL);
        } else if (level.getBiome(this.blockPosition()).is(ModTags.Biomes.SPAWNS_CORRUPT_LOST_SOUL)) {
            this.setVariant(Variant.CORRUPT_LOST_SOUL);
        }
        return super.finalizeSpawn(level, difficulty, reason, spawnData);
    }

    public float getWalkTargetValue(@Nonnull BlockPos pos, @Nonnull LevelReader level) {
        return level.getBlockState(pos).isAir() ? 35.0f : 0.0f;
    }

    @Nonnull
    protected PathNavigation createNavigation(@Nonnull Level level) {
        FlyingPathNavigation navigation = new FlyingPathNavigation((Mob)this, level);
        navigation.setCanOpenDoors(false);
        navigation.setCanFloat(true);
        navigation.setCanPassDoors(true);
        return navigation;
    }

    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_VARIANT, (Object)0);
        builder.define(DATA_SCARED, (Object)false);
    }

    public void tick() {
        if (!this.level().isClientSide()) {
            boolean isPanicking = this.brain.getMemory(MemoryModuleType.IS_PANICKING).orElse(false);
            boolean isScared = this.getBrain().checkMemory((MemoryModuleType)ModMemoryModules.SCARED_TIME.get(), MemoryStatus.VALUE_PRESENT);
            if (this.extractCounter != 0) {
                --this.extractCounter;
            }
            if (this.getBrain().hasMemoryValue(MemoryModuleType.HURT_BY_ENTITY) && !this.isScared()) {
                this.entityData.set(DATA_SCARED, (Object)true);
                this.setPathfindingMalus(PathType.BLOCKED, 0.0f);
                this.getBrain().setActiveActivityIfPossible(Activity.PANIC);
            }
        } else if (this.level().getGameTime() % 10L == 0L) {
            Vec3 viewVector = this.calculateViewVector(this.getXRot(), this.getYRot());
            this.level().addParticle((ParticleOptions)new DustParticleOptions(this.getVariant().getTrailColor(), 1.0f), this.getX() - viewVector.x * 0.5, this.getY() + 0.2, this.getZ() - viewVector.z * 0.5, 0.0, 0.0, 0.0);
        }
        super.tick();
    }

    public boolean canBeCollidedWith() {
        return false;
    }

    public boolean isNoGravity() {
        return true;
    }

    protected void checkFallDamage(double y, boolean onGround, @Nonnull BlockState state, @Nonnull BlockPos pos) {
    }

    public boolean causeFallDamage(float fallDistance, float multiplier, @Nonnull DamageSource source) {
        return false;
    }

    public void onSyncedDataUpdated(@Nonnull EntityDataAccessor<?> key) {
        if (key.equals(DATA_SCARED)) {
            if (this.isScared()) {
                this.fearAnimationState.startIfStopped(this.tickCount);
                this.stillAnimationState.stop();
            } else {
                this.stillAnimationState.startIfStopped(this.tickCount);
                this.fearAnimationState.stop();
            }
        }
        super.onSyncedDataUpdated(key);
    }

    protected void customServerAiStep() {
        this.level().getProfiler().push("lostSoulBrain");
        this.getBrain().tick((ServerLevel)this.level(), (LivingEntity)this);
        this.level().getProfiler().pop();
        super.customServerAiStep();
    }

    public void addAdditionalSaveData(@Nonnull CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("Variant", this.getVariant().getId());
        tag.putBoolean("Scared", ((Boolean)this.entityData.get(DATA_SCARED)).booleanValue());
    }

    public void readAdditionalSaveData(@Nonnull CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setVariant(Variant.FROM_ID.apply(tag.getInt("Variant")));
        this.entityData.set(DATA_SCARED, (Object)tag.getBoolean("Scared"));
    }

    @Nonnull
    protected InteractionResult mobInteract(@Nonnull Player player, @Nonnull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        Variant variant = this.getVariant();
        if (variant != Variant.CORRUPT_LOST_SOUL && stack.is((Item)ModItems.CORRUPTI_DUST.get())) {
            this.setVariant(Variant.CORRUPT_LOST_SOUL);
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        }
        if (variant == Variant.CORRUPT_LOST_SOUL && stack.is((Item)ModItems.AUREAL_BOTTLE.get())) {
            this.setVariant(Variant.LOST_SOUL);
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        }
        if (variant == Variant.LOST_SOUL && stack.is((Item)ModItems.AUREAL_BOTTLE.get())) {
            this.setVariant(Variant.ENCHANTED_LOST_SOUL);
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        }
        return super.mobInteract(player, hand);
    }

    public Variant getVariant() {
        return Variant.FROM_ID.apply((Integer)this.entityData.get(DATA_VARIANT));
    }

    public void setVariant(Variant variant) {
        this.entityData.set(DATA_VARIANT, (Object)variant.getId());
    }

    public boolean isScared() {
        return (Boolean)this.entityData.get(DATA_SCARED);
    }

    @Override
    public ItemStack getSoulItem() {
        return new ItemStack((ItemLike)this.getVariant().getSoulItem());
    }

    @Override
    public void setExtracting() {
        if (!this.getBrain().getActiveActivities().contains(ModActivities.SOUL_EXTRACTING.get())) {
            this.getBrain().setActiveActivityIfPossible((Activity)ModActivities.SOUL_EXTRACTING.get());
        }
    }

    @Override
    public void extractTick(Player player) {
        this.extractCounter = 30;
        this.hurt(this.level().damageSources().source(ModDamageTypes.EXTRACT_SOUL), 2.0f);
        if (this.isDeadOrDying()) {
            this.level().addFreshEntity((Entity)new ItemEntity(this.level(), this.getX(), this.getY(), this.getZ(), this.getSoulItem()));
        }
    }

    public boolean isExtracting() {
        return this.extractCounter > 0;
    }

    public static enum Variant {
        LOST_SOUL(0, "lost_soul", (Item)ModItems.SOUL.get(), 15001592),
        CORRUPT_LOST_SOUL(1, "corrupt_lost_soul", (Item)ModItems.CORRUPT_SOUL.get(), 4477845),
        ENCHANTED_LOST_SOUL(2, "enchanted_lost_soul", (Item)ModItems.ENCHANTED_SOUL.get(), 16638446);

        public static final Function<Integer, Variant> FROM_ID;
        private final int id;
        private final String name;
        private final Item soulItem;
        private final Vector3f trailColor;

        private Variant(int id, String name, Item soulItem, int trailColor) {
            this.id = id;
            this.name = name;
            this.soulItem = soulItem;
            this.trailColor = Vec3.fromRGB24((int)trailColor).toVector3f();
        }

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public Item getSoulItem() {
            return this.soulItem;
        }

        public Vector3f getTrailColor() {
            return this.trailColor;
        }

        public ResourceLocation getTexture() {
            return ForbiddenArcanus.location("textures/entity/lost_soul/" + this.name + ".png");
        }

        static {
            FROM_ID = integer -> Arrays.stream(Variant.values()).filter(variant -> variant.id == integer).findFirst().orElse(LOST_SOUL);
        }
    }
}

