/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.entity.lostsoul;

import com.google.common.collect.ImmutableMap;
import com.stal111.forbidden_arcanus.common.entity.lostsoul.LostSoul;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.VillagerPanicTrigger;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.level.pathfinder.PathType;

public class LostSoulCalmDown
extends Behavior<LostSoul> {
    private static final int SAFE_DISTANCE_FROM_DANGER = 15;
    private static final Function<LostSoul, Boolean> CLOSE_TO_ENTITY_THAT_HURT = lostSoul -> lostSoul.getBrain().getMemory(MemoryModuleType.HURT_BY_ENTITY).filter(entity -> entity.distanceTo((Entity)lostSoul) <= 15.0f).isPresent();

    public LostSoulCalmDown() {
        super((Map)ImmutableMap.of());
    }

    protected void start(@Nonnull ServerLevel level, @Nonnull LostSoul entity, long gameTime) {
        boolean flag;
        boolean bl = flag = VillagerPanicTrigger.isHurt((LivingEntity)entity) || VillagerPanicTrigger.hasHostile((LivingEntity)entity) || CLOSE_TO_ENTITY_THAT_HURT.apply(entity) != false;
        if (!flag) {
            entity.getBrain().eraseMemory(MemoryModuleType.HURT_BY);
            entity.getBrain().eraseMemory(MemoryModuleType.HURT_BY_ENTITY);
            entity.getEntityData().set(LostSoul.DATA_SCARED, (Object)false);
            entity.setPathfindingMalus(PathType.BLOCKED, 16.0f);
            entity.getBrain().useDefaultActivity();
        }
    }
}

