/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.essence;

import com.stal111.forbidden_arcanus.common.block.entity.forge.essence.EssenceType;
import com.stal111.forbidden_arcanus.common.essence.EssenceProvider;
import com.stal111.forbidden_arcanus.common.essence.EssenceStorage;
import com.stal111.forbidden_arcanus.common.network.clientbound.UpdateEssencePayload;
import com.stal111.forbidden_arcanus.core.init.other.ModAttachmentTypes;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.network.PacketDistributor;

public class EntityEssenceProvider<T extends LivingEntity>
implements EssenceProvider {
    private static final Map<EssenceType, AttachmentType<EssenceStorage>> ATTACHMENT_BY_TYPE = (Map)Util.make(new EnumMap(EssenceType.class), map -> {
        map.put(EssenceType.AUREAL, ModAttachmentTypes.AUREAL.get());
        map.put(EssenceType.SOULS, ModAttachmentTypes.SOULS.get());
        map.put(EssenceType.BLOOD, ModAttachmentTypes.BLOOD.get());
        map.put(EssenceType.EXPERIENCE, ModAttachmentTypes.EXPERIENCE.get());
    });
    T entity;

    public EntityEssenceProvider(T entity) {
        this.entity = entity;
    }

    @Override
    public EssenceStorage asStorage(EssenceType type) {
        return (EssenceStorage)this.entity.getData(ATTACHMENT_BY_TYPE.get((Object)type));
    }

    @Override
    public void setStorage(EssenceStorage storage) {
        this.entity.setData(ATTACHMENT_BY_TYPE.get((Object)storage.data().type()), (Object)storage);
        T t = this.entity;
        if (t instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)t;
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new UpdateEssencePayload(storage), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }
}

