/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.event;

import com.stal111.forbidden_arcanus.common.entity.lostsoul.LostSoul;
import com.stal111.forbidden_arcanus.util.ModTags;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;

public final class DeathEvents {
    @SubscribeEvent
    public void onLivingDeath(LivingDeathEvent event) {
        LivingEntity entity = event.getEntity();
        RandomSource random = entity.getRandom();
        Entity entity2 = event.getSource().getEntity();
        if (entity2 instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity2;
            this.spawnLostSoul(entity, random);
        }
    }

    private void spawnLostSoul(LivingEntity entity, RandomSource random) {
        EntityType type = entity.getType();
        Level level = entity.level();
        double chance = 0.05;
        if (type.is(ModTags.EntityTypes.SPAWNS_LOST_SOUL_CHANCE) && random.nextDouble() < chance) {
            level.addFreshEntity((Entity)new LostSoul(level, entity.getX(), entity.getY(), entity.getZ()));
        } else if (type.is(ModTags.EntityTypes.SPAWNS_CORRUPT_LOST_SOUL_CHANCE) && random.nextDouble() < chance) {
            LostSoul lostSoul = new LostSoul(level, entity.getX(), entity.getY(), entity.getZ());
            lostSoul.setVariant(LostSoul.Variant.CORRUPT_LOST_SOUL);
            level.addFreshEntity((Entity)lostSoul);
        }
    }
}

