/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.integration.hephaestus_forge;

import com.google.common.collect.ImmutableList;
import com.stal111.forbidden_arcanus.common.block.entity.forge.HephaestusForgeLevel;
import com.stal111.forbidden_arcanus.common.block.entity.forge.ritual.Ritual;
import com.stal111.forbidden_arcanus.common.block.entity.forge.ritual.RitualInput;
import com.stal111.forbidden_arcanus.common.integration.hephaestus_forge.EssenceInfo;
import com.stal111.forbidden_arcanus.common.item.enhancer.EnhancerDefinition;
import com.stal111.forbidden_arcanus.common.item.enhancer.EnhancerHelper;
import com.stal111.forbidden_arcanus.core.init.ModBlocks;
import it.unimi.dsi.fastutil.ints.IntIntPair;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public abstract class HephaestusForgeCategory
implements IRecipeCategory<Ritual> {
    private static final List<IntIntPair> INPUT_POSITIONS = ImmutableList.of((Object)IntIntPair.of((int)63, (int)13), (Object)IntIntPair.of((int)82, (int)16), (Object)IntIntPair.of((int)85, (int)35), (Object)IntIntPair.of((int)82, (int)54), (Object)IntIntPair.of((int)63, (int)57), (Object)IntIntPair.of((int)44, (int)54), (Object)IntIntPair.of((int)41, (int)35), (Object)IntIntPair.of((int)44, (int)16));
    private static final IntIntPair FORGE_ITEM_POSITION = IntIntPair.of((int)63, (int)35);
    private static final IntIntPair ENHANCER_POSITION = IntIntPair.of((int)10, (int)12);
    private static final int ENHANCER_Y_OFFSET = 21;
    private final String name;
    private final IDrawable background;
    private final IDrawable icon;
    private final List<EssenceInfo> essences;

    public HephaestusForgeCategory(String name, IGuiHelper guiHelper, ResourceLocation texture, int essencesStartX, int essencesStartY) {
        this.name = name;
        this.background = guiHelper.createDrawable(texture, 0, 0, 148, 108);
        this.icon = guiHelper.createDrawableItemStack(new ItemStack((ItemLike)ModBlocks.HEPHAESTUS_FORGE_TIER_1.get()));
        this.essences = EssenceInfo.create(guiHelper, essencesStartX, essencesStartY);
    }

    @NotNull
    public Component getTitle() {
        return Component.translatable((String)("jei.forbidden_arcanus.category." + this.name));
    }

    @NotNull
    public IDrawable getBackground() {
        return this.background;
    }

    @NotNull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(@NotNull IRecipeLayoutBuilder builder, @NotNull Ritual ritual, @NotNull IFocusGroup focusGroup) {
        this.addInputs(builder, ritual.inputs(), ritual.mainIngredient());
        if (ritual.requirements() != null && this.displayEnhancers()) {
            ritual.requirements().enhancers().ifPresent(holders -> this.addEnhancers(builder, (HolderSet<EnhancerDefinition>)holders));
        }
        this.buildRecipe(builder, ritual);
    }

    protected abstract void buildRecipe(@NotNull IRecipeLayoutBuilder var1, @NotNull Ritual var2);

    protected boolean displayEnhancers() {
        return true;
    }

    private void addInputs(@NotNull IRecipeLayoutBuilder builder, List<RitualInput> inputs, Ingredient mainIngredient) {
        builder.addSlot(RecipeIngredientRole.INPUT, FORGE_ITEM_POSITION.firstInt(), FORGE_ITEM_POSITION.secondInt()).addIngredients(mainIngredient);
        int index = 0;
        for (RitualInput input : inputs) {
            for (int j = 0; j < input.amount(); ++j) {
                builder.addSlot(RecipeIngredientRole.INPUT, INPUT_POSITIONS.get(index).firstInt(), INPUT_POSITIONS.get(index).secondInt()).addIngredients(input.ingredient());
                ++index;
            }
        }
    }

    private void addEnhancers(@NotNull IRecipeLayoutBuilder builder, HolderSet<EnhancerDefinition> enhancers) {
        for (int i = 0; i < enhancers.size(); ++i) {
            Holder enhancer = enhancers.get(i);
            RegistryAccess registryAccess = Minecraft.getInstance().level.registryAccess();
            builder.addSlot(RecipeIngredientRole.CATALYST, ENHANCER_POSITION.firstInt(), ENHANCER_POSITION.secondInt() + i * 21).addItemStack(EnhancerHelper.createEnhancer((HolderLookup.Provider)registryAccess, (ItemLike)((EnhancerDefinition)enhancer.value()).displayItem().value(), (Holder<EnhancerDefinition>)enhancer));
        }
    }

    public void draw(@NotNull Ritual recipe, @NotNull IRecipeSlotsView slotsView, @NotNull GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.essences.forEach(essenceInfo -> essenceInfo.drawable().draw(guiGraphics, essenceInfo.posX(), essenceInfo.posY()));
    }

    @NotNull
    public List<Component> getTooltipStrings(@NotNull Ritual recipe, @NotNull IRecipeSlotsView slotsView, double mouseX, double mouseY) {
        for (EssenceInfo essenceInfo : this.essences) {
            if (!essenceInfo.shouldDisplayTooltip(mouseX, mouseY)) continue;
            return Collections.singletonList(essenceInfo.getTooltip(recipe.requirements().essences()));
        }
        return Collections.emptyList();
    }

    public static ItemStack getForgeItem(int tier) {
        return HephaestusForgeLevel.values()[tier].getBlock().asItem().getDefaultInstance();
    }
}

