/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.inventory;

import com.stal111.forbidden_arcanus.common.block.entity.forge.HephaestusForgeBlockEntity;
import com.stal111.forbidden_arcanus.common.block.entity.forge.HephaestusForgeLevel;
import com.stal111.forbidden_arcanus.common.block.entity.forge.essence.EssenceType;
import com.stal111.forbidden_arcanus.common.inventory.EnhancerSlot;
import com.stal111.forbidden_arcanus.common.inventory.InputSlot;
import com.stal111.forbidden_arcanus.common.inventory.MainSlot;
import com.stal111.forbidden_arcanus.common.item.enhancer.EnhancerHelper;
import com.stal111.forbidden_arcanus.core.init.other.ModMenuTypes;
import com.stal111.forbidden_arcanus.core.registry.FARegistries;
import it.unimi.dsi.fastutil.ints.IntImmutableList;
import it.unimi.dsi.fastutil.ints.IntList;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.core.Holder;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import net.valhelsia.valhelsia_core.api.common.block.entity.MenuCreationContext;

public class HephaestusForgeMenu
extends AbstractContainerMenu {
    public static final String UNLOCKED_AT_KEY = "gui.forbidden_arcanus.hephaestus_forge.unlocked_at";
    public static final IntList ENHANCERS_SLOTS = IntImmutableList.of((int[])new int[]{0, 1, 2, 3});
    private final ContainerData hephaestusForgeData;
    private final ContainerLevelAccess levelAccess;
    private final DataSlot hephaestusForgeLevel = DataSlot.standalone();

    public HephaestusForgeMenu(int id, Inventory inventory, FriendlyByteBuf buffer) {
        this(id, new ItemStackHandler(9), (ContainerData)new SimpleContainerData(4), (MenuCreationContext<HephaestusForgeBlockEntity, IItemHandler>)MenuCreationContext.of((Inventory)inventory), HephaestusForgeLevel.ONE);
    }

    public HephaestusForgeMenu(int id, ItemStackHandler handler, ContainerData containerData, MenuCreationContext<HephaestusForgeBlockEntity, IItemHandler> creationContext, HephaestusForgeLevel level) {
        super((MenuType)ModMenuTypes.HEPHAESTUS_FORGE.get(), id);
        this.levelAccess = creationContext.levelAccess();
        this.hephaestusForgeData = containerData;
        HephaestusForgeMenu.checkContainerDataCount((ContainerData)this.hephaestusForgeData, (int)4);
        this.addDataSlots(this.hephaestusForgeData);
        this.addDataSlot(this.hephaestusForgeLevel);
        this.hephaestusForgeLevel.set(level.getAsInt());
        this.addEnhancerSlot(handler, 0, 36, 24);
        this.addEnhancerSlot(handler, 1, 36, 46);
        this.addEnhancerSlot(handler, 2, 124, 24);
        this.addEnhancerSlot(handler, 3, 124, 46);
        this.addSlot((Slot)new MainSlot((IItemHandler)handler, 4, 80, 24, this));
        this.addSlot((Slot)new InputSlot((IItemHandler)handler, 5, -18, 25, EssenceType.AUREAL));
        this.addSlot((Slot)new InputSlot((IItemHandler)handler, 6, -18, 43, EssenceType.SOULS));
        this.addSlot((Slot)new InputSlot((IItemHandler)handler, 7, 178, 25, EssenceType.BLOOD));
        this.addSlot((Slot)new InputSlot((IItemHandler)handler, 8, 178, 43, EssenceType.EXPERIENCE));
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot((Slot)new SlotItemHandler((IItemHandler)creationContext.inventory(), j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.addSlot((Slot)new SlotItemHandler((IItemHandler)creationContext.inventory(), k, 8 + k * 18, 142));
        }
    }

    private void addEnhancerSlot(ItemStackHandler handler, int index, int x, int y) {
        this.addSlot((Slot)new EnhancerSlot((IItemHandler)handler, index, x, y, () -> this.isSlotLocked(index), Tooltip.create((Component)Component.translatable((String)UNLOCKED_AT_KEY, (Object[])new Object[]{index + 1}))));
    }

    @Nonnull
    public ItemStack quickMoveStack(@Nonnull Player player, int index) {
        ItemStack result = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        Level level = player.level();
        if (!slot.hasItem()) {
            return result;
        }
        ItemStack stack = slot.getItem();
        result = stack.copy();
        if (index <= 4) {
            if (!this.moveItemStackTo(stack, 5, 41, true)) {
                return ItemStack.EMPTY;
            }
            slot.onQuickCraft(stack, result);
        } else if (index <= 8 ? !this.moveItemStackTo(stack, 9, 41, true) : (this.canInput(level, EssenceType.AUREAL, stack) ? !this.moveItemStackTo(stack, 5, 6, false) : (this.canInput(level, EssenceType.SOULS, stack) ? !this.moveItemStackTo(stack, 6, 7, false) : (this.canInput(level, EssenceType.BLOOD, stack) ? !this.moveItemStackTo(stack, 7, 8, false) : (this.canInput(level, EssenceType.EXPERIENCE, stack) ? !this.moveItemStackTo(stack, 8, 9, false) : (EnhancerHelper.getEnhancer(stack).isPresent() ? !this.moveItemStackTo(stack, 0, this.getLevel().getAsInt() + 1, false) : (!this.getSlot(4).hasItem() ? !this.moveItemStackTo(stack, 4, 5, false) : (index < 36 ? !this.moveItemStackTo(stack, 36, 45, false) : index < 45 && !this.moveItemStackTo(stack, 9, 36, false))))))))) {
            return ItemStack.EMPTY;
        }
        if (index == 4) {
            this.levelAccess.execute((level1, pos) -> level.sendBlockUpdated(pos, level1.getBlockState(pos), level1.getBlockState(pos), 3));
        }
        slot.onTake(player, stack);
        return result;
    }

    public boolean canInput(Level level, EssenceType type, ItemStack stack) {
        return level.registryAccess().registryOrThrow(FARegistries.FORGE_INPUT).holders().map(Holder.Reference::value).anyMatch(input -> input.canInput(type, stack));
    }

    public boolean stillValid(@Nonnull Player player) {
        return HephaestusForgeMenu.stillValid((ContainerLevelAccess)this.levelAccess, (Player)player, (Block)this.getLevel().getBlock());
    }

    public ContainerData getHephaestusForgeData() {
        return this.hephaestusForgeData;
    }

    public HephaestusForgeLevel getLevel() {
        return HephaestusForgeLevel.getFromIndex(this.hephaestusForgeLevel.get());
    }

    public boolean isSlotLocked(int slot) {
        return ((Slot)this.slots.get(slot)).getSlotIndex() >= this.getLevel().getAsInt();
    }
}

