/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.inventory.clibano;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.stal111.forbidden_arcanus.common.block.entity.clibano.ClibanoFireType;
import com.stal111.forbidden_arcanus.common.block.entity.clibano.ClibanoMainBlockEntity;
import com.stal111.forbidden_arcanus.common.block.entity.clibano.ResiduesStorage;
import com.stal111.forbidden_arcanus.common.block.entity.clibano.residue.ResidueType;
import com.stal111.forbidden_arcanus.common.inventory.EnhancerSlot;
import com.stal111.forbidden_arcanus.common.inventory.clibano.ClibanoFuelSlot;
import com.stal111.forbidden_arcanus.common.inventory.clibano.ClibanoResultSlot;
import com.stal111.forbidden_arcanus.common.inventory.clibano.ClibanoSoulSlot;
import com.stal111.forbidden_arcanus.common.item.crafting.ClibanoRecipe;
import com.stal111.forbidden_arcanus.common.item.enhancer.EnhancerHelper;
import com.stal111.forbidden_arcanus.core.init.ModBlocks;
import com.stal111.forbidden_arcanus.core.init.ModRecipeTypes;
import com.stal111.forbidden_arcanus.core.init.other.ModMenuTypes;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.RegistryOps;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import net.valhelsia.valhelsia_core.api.common.block.entity.MenuCreationContext;

public class ClibanoMenu
extends AbstractContainerMenu {
    public static final int SLOT_COUNT = 7;
    public static final int BASE_DATA_COUNT = 10;
    public static final int ENHANCER_SLOT = 0;
    public static final int SOUL_SLOT = 1;
    public static final int FUEL_SLOT = 2;
    public static final Pair<Integer, Integer> INPUT_SLOTS = Pair.of((Object)3, (Object)4);
    public static final Pair<Integer, Integer> RESULT_SLOTS = Pair.of((Object)5, (Object)6);
    private final ContainerData containerData;
    private Map<Holder<ResidueType>, Integer> residueData;
    private final MenuCreationContext<ClibanoMainBlockEntity, IItemHandler> context;

    public ClibanoMenu(int id, Inventory inventory, FriendlyByteBuf buffer) {
        this(id, new ItemStackHandler(7), (ContainerData)new SimpleContainerData(10), (Map)buffer.readWithCodecTrusted((DynamicOps)RegistryOps.create((DynamicOps)NbtOps.INSTANCE, (HolderLookup.Provider)Minecraft.getInstance().level.registryAccess()), ResiduesStorage.MAP_CODEC), (MenuCreationContext<ClibanoMainBlockEntity, IItemHandler>)MenuCreationContext.of((Inventory)inventory));
    }

    public ClibanoMenu(int containerId, ItemStackHandler handler, ContainerData containerData, Map<Holder<ResidueType>, Integer> residueData, MenuCreationContext<ClibanoMainBlockEntity, IItemHandler> context) {
        super((MenuType)ModMenuTypes.CLIBANO.get(), containerId);
        this.containerData = containerData;
        this.residueData = residueData;
        this.context = context;
        this.addSlots(handler);
        ClibanoMenu.checkContainerDataCount((ContainerData)containerData, (int)10);
    }

    private void addSlots(ItemStackHandler handler) {
        this.addSlot((Slot)new EnhancerSlot((IItemHandler)handler, 0, 18, 20));
        this.addSlot((Slot)new ClibanoSoulSlot((IItemHandler)handler, 1, 18, 56));
        this.addSlot((Slot)new ClibanoFuelSlot(this, (IItemHandler)handler, 2, 53, 56));
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)handler, ((Integer)INPUT_SLOTS.getFirst()).intValue(), 44, 20));
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)handler, ((Integer)INPUT_SLOTS.getSecond()).intValue(), 62, 20));
        ClibanoMainBlockEntity blockEntity = (ClibanoMainBlockEntity)this.context.getBlockEntity();
        this.addSlot((Slot)new ClibanoResultSlot(this.context.player(), (IItemHandler)handler, blockEntity, (Integer)RESULT_SLOTS.getFirst(), 116, 32));
        this.addSlot((Slot)new ClibanoResultSlot(this.context.player(), (IItemHandler)handler, blockEntity, (Integer)RESULT_SLOTS.getSecond(), 142, 28));
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot((Slot)new SlotItemHandler((IItemHandler)this.context.inventory(), j + i * 9 + 9, 8 + j * 18, 91 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.addSlot((Slot)new SlotItemHandler((IItemHandler)this.context.inventory(), k, 8 + k * 18, 149));
        }
        this.addDataSlots(this.containerData);
    }

    @Nonnull
    public ItemStack quickMoveStack(@Nonnull Player player, int index) {
        ItemStack result = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (!slot.hasItem()) {
            return result;
        }
        ItemStack stack = slot.getItem();
        result = stack.copy();
        if (index == (Integer)RESULT_SLOTS.getFirst() || index == (Integer)RESULT_SLOTS.getSecond()) {
            if (!this.moveItemStackTo(stack, 7, 43, true)) {
                return ItemStack.EMPTY;
            }
            slot.onQuickCraft(stack, result);
        } else if (index < 7 ? !this.moveItemStackTo(stack, 7, 43, false) : (this.canSmelt(stack) ? !this.moveItemStackTo(stack, (Integer)INPUT_SLOTS.getFirst(), (Integer)INPUT_SLOTS.getSecond() + 1, false) : (this.isFuel(stack) ? !this.moveItemStackTo(stack, 2, 3, false) : (this.isSoul(stack) ? !this.moveItemStackTo(stack, 1, 2, false) : (EnhancerHelper.getEnhancer(stack).isPresent() ? !this.moveItemStackTo(stack, 0, 1, false) : (index < 34 ? !this.moveItemStackTo(stack, 34, 43, false) : index < 43 && !this.moveItemStackTo(stack, 7, 34, false))))))) {
            return ItemStack.EMPTY;
        }
        if (stack.isEmpty()) {
            slot.set(ItemStack.EMPTY);
        } else {
            slot.setChanged();
        }
        if (stack.getCount() == result.getCount()) {
            return ItemStack.EMPTY;
        }
        slot.onTake(player, stack);
        return result;
    }

    protected boolean canSmelt(ItemStack stack) {
        return (Boolean)this.context.levelAccess().evaluate((level, pos) -> {
            for (RecipeHolder recipe : level.getRecipeManager().getAllRecipesFor((RecipeType)ModRecipeTypes.CLIBANO_COMBUSTION.get())) {
                for (Ingredient ingredient : ((ClibanoRecipe)recipe.value()).getIngredients()) {
                    if (!ingredient.test(stack)) continue;
                    return true;
                }
            }
            return false;
        }, (Object)false);
    }

    protected boolean isFuel(ItemStack stack) {
        return stack.getBurnTime(RecipeType.BLASTING) > 0;
    }

    protected boolean isSoul(ItemStack stack) {
        return ClibanoFireType.fromItem(stack) != ClibanoFireType.FIRE;
    }

    public boolean isSoulActive() {
        return this.getSoulDuration() > 0;
    }

    public int getSoulDuration() {
        return this.containerData.get(0);
    }

    public int getBurnTime() {
        return this.containerData.get(1);
    }

    public int getBurnDuration() {
        return this.containerData.get(2);
    }

    public Pair<Integer, Integer> getCookingProgress() {
        return Pair.of((Object)this.containerData.get(3), (Object)this.containerData.get(4));
    }

    public Pair<Integer, Integer> getCookingDuration() {
        return Pair.of((Object)this.containerData.get(5), (Object)this.containerData.get(6));
    }

    public boolean stillValid(@Nonnull Player player) {
        return ClibanoMenu.stillValid((ContainerLevelAccess)this.context.levelAccess(), (Player)player, (Block)((Block)ModBlocks.CLIBANO_MAIN_PART.get()));
    }

    public int getFireType() {
        return this.containerData.get(7);
    }

    public int getResidueFullness() {
        return this.containerData.get(8);
    }

    public boolean isDoubleRecipe() {
        return this.containerData.get(9) == 1;
    }

    public void setResidueData(Map<Holder<ResidueType>, Integer> residueData) {
        this.residueData = residueData;
    }

    public Map<Holder<ResidueType>, Integer> getResidueData() {
        return this.residueData;
    }
}

