/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.item;

import com.stal111.forbidden_arcanus.ForbiddenArcanus;
import com.stal111.forbidden_arcanus.common.item.RitualStarterItem;
import com.stal111.forbidden_arcanus.core.init.ModDataComponents;
import com.stal111.forbidden_arcanus.core.init.ModSounds;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class BlacksmithGavelItem
extends PickaxeItem
implements RitualStarterItem {
    private static final String TOOLTIP_KEY = Util.makeDescriptionId((String)"tooltip", (ResourceLocation)ForbiddenArcanus.location("remaining_ritual_uses"));

    public BlacksmithGavelItem(Tier tier, Item.Properties properties) {
        super(tier, properties);
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> components, @NotNull TooltipFlag isAdvanced) {
        components.add((Component)Component.translatable((String)TOOLTIP_KEY, (Object[])new Object[]{this.getRemainingUses(stack)}).withStyle(ChatFormatting.GRAY));
    }

    @Override
    public int getRitualUses(ItemStack stack) {
        return (Integer)stack.getOrDefault(ModDataComponents.RITUAL_USES, (Object)0);
    }

    @Override
    public int getRemainingUses(ItemStack stack) {
        return (Integer)stack.getOrDefault(ModDataComponents.REMAINING_RITUAL_USES, (Object)this.getRitualUses(stack));
    }

    @Override
    public void setRemainingUses(ItemStack stack, int remainingUses) {
        stack.set(ModDataComponents.REMAINING_RITUAL_USES, (Object)remainingUses);
    }

    @Override
    public void playAdditionalEffect(Level level, BlockPos pos, Player player) {
        level.playSound(null, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, (SoundEvent)ModSounds.BLACKSMITH_GAVEL_RITUAL_START.get(), SoundSource.PLAYERS, 0.85f, level.getRandom().nextFloat() * 0.15f + 0.9f);
    }
}

