/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.item.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.stal111.forbidden_arcanus.common.item.modifier.ItemModifier;
import com.stal111.forbidden_arcanus.common.item.modifier.ModifierHelper;
import com.stal111.forbidden_arcanus.core.init.ModRecipeSerializers;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SmithingRecipe;
import net.minecraft.world.item.crafting.SmithingRecipeInput;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public record ApplyModifierRecipe(Ingredient template, Ingredient addition, Holder<ItemModifier> modifier) implements SmithingRecipe
{
    public boolean matches(@NotNull SmithingRecipeInput recipeInput, @NotNull Level level) {
        ItemStack base = recipeInput.base();
        if (ModifierHelper.hasModifier(base) || !this.isTemplateIngredient(recipeInput.template())) {
            return false;
        }
        return ((ItemModifier)this.modifier.value()).canItemContainModifier(base, (HolderLookup.Provider)level.registryAccess()) && this.isAdditionIngredient(recipeInput.addition());
    }

    @NotNull
    public ItemStack assemble(@NotNull SmithingRecipeInput recipeInput, @NotNull HolderLookup.Provider provider) {
        ItemStack stack = recipeInput.base().copy();
        ModifierHelper.setModifier(stack, this.modifier);
        return stack;
    }

    @NotNull
    public ItemStack getResultItem(@NotNull HolderLookup.Provider provider) {
        return ItemStack.EMPTY;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipeSerializers.APPLY_MODIFIER.get();
    }

    public boolean isSpecial() {
        return true;
    }

    public boolean isTemplateIngredient(@NotNull ItemStack stack) {
        return this.template.test(stack);
    }

    public boolean isBaseIngredient(@NotNull ItemStack stack) {
        return ((ItemModifier)this.modifier.value()).isValidItem(stack);
    }

    public boolean isAdditionIngredient(@NotNull ItemStack stack) {
        return this.addition.test(stack);
    }

    public static class Serializer
    implements RecipeSerializer<ApplyModifierRecipe> {
        private static final MapCodec<ApplyModifierRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC_NONEMPTY.fieldOf("template").forGetter(recipe -> recipe.template), (App)Ingredient.CODEC_NONEMPTY.fieldOf("addition").forGetter(recipe -> recipe.addition), (App)ItemModifier.CODEC.fieldOf("modifier").forGetter(recipe -> recipe.modifier)).apply((Applicative)instance, ApplyModifierRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, ApplyModifierRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        @NotNull
        public MapCodec<ApplyModifierRecipe> codec() {
            return CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, ApplyModifierRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        public static ApplyModifierRecipe fromNetwork(@NotNull RegistryFriendlyByteBuf buffer) {
            Ingredient template = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
            Ingredient addition = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
            Holder modifier = (Holder)ItemModifier.STREAM_CODEC.decode((Object)buffer);
            return new ApplyModifierRecipe(template, addition, (Holder<ItemModifier>)modifier);
        }

        public static void toNetwork(@NotNull RegistryFriendlyByteBuf buffer, ApplyModifierRecipe recipe) {
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.template);
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.addition);
            ItemModifier.STREAM_CODEC.encode((Object)buffer, recipe.modifier);
        }
    }
}

