/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.item.crafting;

import com.google.errorprone.annotations.DoNotCall;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.stal111.forbidden_arcanus.common.block.entity.clibano.ClibanoFireType;
import com.stal111.forbidden_arcanus.common.block.entity.clibano.residue.ResidueChance;
import com.stal111.forbidden_arcanus.common.item.crafting.ClibanoRecipeInput;
import com.stal111.forbidden_arcanus.common.item.enhancer.EnhancerDefinition;
import com.stal111.forbidden_arcanus.core.init.ModBlocks;
import com.stal111.forbidden_arcanus.core.init.ModRecipeSerializers;
import com.stal111.forbidden_arcanus.core.init.ModRecipeTypes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CookingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.util.RecipeMatcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClibanoRecipe
implements Recipe<ClibanoRecipeInput> {
    public static final int DEFAULT_COOKING_TIME = 100;
    private final Map<ClibanoFireType, Integer> cookingTimes = new EnumMap<ClibanoFireType, Integer>(ClibanoFireType.class);
    protected final CookingBookCategory category;
    private final String group;
    private final Either<Ingredient, Pair<Ingredient, Ingredient>> ingredients;
    private final ItemStack result;
    private final float experience;
    private final int cookingTime;
    @Nullable
    private final ResidueChance residueChance;
    private final ClibanoFireType requiredFireType;
    @Nullable
    private final Holder<EnhancerDefinition> requiredEnhancer;

    public ClibanoRecipe(String group, CookingBookCategory category, Either<Ingredient, Pair<Ingredient, Ingredient>> ingredients, ItemStack result, float experience, int cookingTime, @Nullable ResidueChance residueChance, ClibanoFireType requiredFireType, @Nullable Holder<EnhancerDefinition> requiredEnhancer) {
        this.group = group;
        this.category = category;
        this.ingredients = ingredients;
        this.result = result;
        this.experience = experience;
        this.cookingTime = cookingTime;
        this.residueChance = residueChance;
        this.requiredFireType = requiredFireType;
        this.requiredEnhancer = requiredEnhancer;
        for (ClibanoFireType fireType : ClibanoFireType.values()) {
            this.cookingTimes.put(fireType, (int)((double)cookingTime / fireType.getCookingSpeedMultiplier()));
        }
    }

    public boolean matches(@NotNull ClibanoRecipeInput recipeInput, @NotNull Level level, List<EnhancerDefinition> enhancers) {
        List list;
        if (this.getRequiredEnhancer() != null && !enhancers.contains(this.getRequiredEnhancer().value())) {
            return false;
        }
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>(recipeInput.getInputs());
        return RecipeMatcher.findMatches(inputs, (List)(list = (List)this.ingredients.map(List::of, pair -> List.of((Ingredient)pair.getFirst(), (Ingredient)pair.getSecond())))) != null;
    }

    @DoNotCall
    public boolean matches(@NotNull ClibanoRecipeInput recipeInput, @NotNull Level level) {
        return this.matches(recipeInput, level, Collections.emptyList());
    }

    @NotNull
    public ItemStack assemble(@NotNull ClibanoRecipeInput recipeInput, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider lookupProvider) {
        return this.result.copy();
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    @NotNull
    public ItemStack getResultItem(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider lookupProvider) {
        return this.result;
    }

    @NotNull
    public NonNullList<Ingredient> getIngredients() {
        return (NonNullList)this.ingredients.map(ingredient -> NonNullList.of((Object)Ingredient.EMPTY, (Object[])new Ingredient[]{ingredient}), pair -> NonNullList.of((Object)Ingredient.EMPTY, (Object[])new Ingredient[]{(Ingredient)pair.getFirst(), (Ingredient)pair.getSecond()}));
    }

    public int getCookingTime(ClibanoFireType fireType) {
        return this.cookingTimes.get((Object)fireType);
    }

    @Nullable
    public ResidueChance getResidueChance() {
        return this.residueChance;
    }

    public ClibanoFireType getRequiredFireType() {
        return this.requiredFireType;
    }

    @Nullable
    public Holder<EnhancerDefinition> getRequiredEnhancer() {
        return this.requiredEnhancer;
    }

    public float getExperience() {
        return this.experience;
    }

    public boolean isDoubleRecipe() {
        return this.getIngredients().size() == 2;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipeSerializers.CLIBANO_SERIALIZER.get();
    }

    @NotNull
    public RecipeType<?> getType() {
        return (RecipeType)ModRecipeTypes.CLIBANO_COMBUSTION.get();
    }

    @NotNull
    public ItemStack getToastSymbol() {
        return new ItemStack((ItemLike)ModBlocks.CLIBANO_CORE.get());
    }

    public static class Serializer
    implements RecipeSerializer<ClibanoRecipe> {
        private static final Function<NonNullList<Ingredient>, DataResult<NonNullList<Ingredient>>> INGREDIENT_CHECK = ingredients -> {
            if (ingredients.isEmpty() || ingredients.size() >= 3) {
                return DataResult.error(() -> "Invalid number of ingredients", (Object)ingredients);
            }
            return DataResult.success((Object)ingredients);
        };
        private static final MapCodec<ClibanoRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(recipe -> recipe.group), (App)CookingBookCategory.CODEC.fieldOf("category").orElse((Object)CookingBookCategory.MISC).forGetter(recipe -> recipe.category), (App)Codec.either((Codec)Ingredient.CODEC_NONEMPTY, (Codec)Codec.mapPair((MapCodec)Ingredient.MAP_CODEC_NONEMPTY.fieldOf("first"), (MapCodec)Ingredient.MAP_CODEC_NONEMPTY.fieldOf("second")).codec()).fieldOf("ingredients").forGetter(recipe -> recipe.ingredients), (App)BuiltInRegistries.ITEM.byNameCodec().xmap(ItemStack::new, ItemStack::getItem).fieldOf("result").forGetter(recipe -> recipe.result), (App)Codec.FLOAT.fieldOf("experience").orElse((Object)Float.valueOf(0.0f)).forGetter(recipe -> Float.valueOf(recipe.experience)), (App)Codec.INT.fieldOf("cooking_time").orElse((Object)100).forGetter(recipe -> recipe.cookingTime), (App)ResidueChance.CODEC.optionalFieldOf("residue").forGetter(recipe -> Optional.ofNullable(recipe.residueChance)), (App)ClibanoFireType.CODEC.fieldOf("fire_type").orElse((Object)ClibanoFireType.FIRE).forGetter(recipe -> recipe.requiredFireType), (App)EnhancerDefinition.REFERENCE_CODEC.optionalFieldOf("enhancer").forGetter(recipe -> Optional.ofNullable(recipe.requiredEnhancer))).apply((Applicative)instance, (s, category, ingredients, stack, experience, cooking_time, residue, fireType, enhancer) -> new ClibanoRecipe((String)s, (CookingBookCategory)category, (Either<Ingredient, Pair<Ingredient, Ingredient>>)ingredients, (ItemStack)stack, experience.floatValue(), (int)cooking_time, residue.orElse(null), (ClibanoFireType)((Object)((Object)fireType)), (Holder<EnhancerDefinition>)((Holder)enhancer.orElse(null)))));
        public static final StreamCodec<RegistryFriendlyByteBuf, ClibanoRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        @NotNull
        public MapCodec<ClibanoRecipe> codec() {
            return CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, ClibanoRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        @NotNull
        public static ClibanoRecipe fromNetwork(@NotNull FriendlyByteBuf buffer) {
            return (ClibanoRecipe)buffer.readJsonWithCodec(CODEC.codec());
        }

        public static void toNetwork(@NotNull FriendlyByteBuf buffer, @NotNull ClibanoRecipe recipe) {
            buffer.writeJsonWithCodec(CODEC.codec(), (Object)recipe);
        }
    }
}

