/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.item.crafting;

import com.stal111.forbidden_arcanus.common.essence.EssenceData;
import com.stal111.forbidden_arcanus.common.essence.EssenceStorage;
import com.stal111.forbidden_arcanus.core.init.ModDataComponents;
import com.stal111.forbidden_arcanus.core.init.ModItems;
import com.stal111.forbidden_arcanus.core.init.ModRecipeSerializers;
import java.util.List;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class CombineAurealTankRecipe
extends CustomRecipe {
    public CombineAurealTankRecipe(CraftingBookCategory category) {
        super(category);
    }

    public boolean matches(@NotNull CraftingInput input, @NotNull Level level) {
        EssenceStorage data = this.getCombinedStorage(input.items());
        boolean multipleStacks = input.items().stream().filter(stack -> !stack.isEmpty()).toList().size() > 1;
        return data != EssenceStorage.EMPTY && multipleStacks && data.limit() <= 3000;
    }

    @NotNull
    public ItemStack assemble(@NotNull CraftingInput input, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider lookupProvider) {
        EssenceStorage data = this.getCombinedStorage(input.items());
        ItemStack stack = new ItemStack((ItemLike)ModItems.AUREAL_TANK.get());
        stack.set(ModDataComponents.ESSENCE_STORAGE, (Object)data);
        return stack;
    }

    private EssenceStorage getCombinedStorage(List<ItemStack> stacks) {
        EssenceData combined = EssenceData.EMPTY;
        int limit = 0;
        for (ItemStack stack : stacks) {
            if (stack.isEmpty()) continue;
            if (!stack.is((Item)ModItems.AUREAL_TANK.get())) {
                return EssenceStorage.EMPTY;
            }
            EssenceStorage storage = (EssenceStorage)stack.get(ModDataComponents.ESSENCE_STORAGE);
            if (storage == null) continue;
            combined = combined.combine(storage.data());
        }
        return new EssenceStorage(combined, limit, true);
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= 2;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipeSerializers.COMBINE_AUREAL_TANK.get();
    }
}

