/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.item.enhancer;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Keyable;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.stal111.forbidden_arcanus.common.item.enhancer.EnhancerTarget;
import com.stal111.forbidden_arcanus.common.item.enhancer.effect.EnhancerEffect;
import com.stal111.forbidden_arcanus.core.registry.FARegistries;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public record EnhancerDefinition(Map<EnhancerTarget, Component> description, Holder<Item> displayItem, List<EnhancerEffect> effects) {
    public static final Codec<EnhancerDefinition> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.simpleMap(EnhancerTarget.CODEC, (Codec)ComponentSerialization.CODEC, (Keyable)StringRepresentable.keys((StringRepresentable[])EnhancerTarget.values())).fieldOf("description").forGetter(definition -> definition.description), (App)ItemStack.ITEM_NON_AIR_CODEC.fieldOf("display_item").forGetter(definition -> definition.displayItem), (App)EnhancerEffect.DIRECT_CODEC.listOf().fieldOf("effects").forGetter(definition -> definition.effects)).apply((Applicative)instance, EnhancerDefinition::new));
    public static final Codec<Holder<EnhancerDefinition>> REFERENCE_CODEC = RegistryFileCodec.create(FARegistries.ENHANCER_DEFINITION, CODEC);
    public static final Codec<HolderSet<EnhancerDefinition>> LIST_CODEC = RegistryCodecs.homogeneousList(FARegistries.ENHANCER_DEFINITION, CODEC);
    public static final Codec<EnhancerDefinition> NETWORK_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.simpleMap(EnhancerTarget.CODEC, (Codec)ComponentSerialization.CODEC, (Keyable)StringRepresentable.keys((StringRepresentable[])EnhancerTarget.values())).fieldOf("description").forGetter(definition -> definition.description), (App)ItemStack.ITEM_NON_AIR_CODEC.fieldOf("display_item").forGetter(definition -> definition.displayItem)).apply((Applicative)instance, (description, item) -> new EnhancerDefinition((Map<EnhancerTarget, Component>)description, (Holder<Item>)item, (List<EnhancerEffect>)ImmutableList.of())));
    public static final StreamCodec<RegistryFriendlyByteBuf, Holder<EnhancerDefinition>> STREAM_CODEC = ByteBufCodecs.holderRegistry(FARegistries.ENHANCER_DEFINITION);

    public static EnhancerDefinition create(Map<EnhancerTarget, Component> description, Item item, EnhancerEffect ... effects) {
        return new EnhancerDefinition(description, (Holder<Item>)item.builtInRegistryHolder(), List.of(effects));
    }

    public Stream<EnhancerEffect> getEffects(EnhancerTarget target) {
        return this.effects.stream().filter(effect -> effect.getType().target() == target);
    }
}

