/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.loot;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.stal111.forbidden_arcanus.util.ModTags;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;

public class BlacksmithGavelLootModifier
extends LootModifier {
    public static final Supplier<MapCodec<BlacksmithGavelLootModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.mapCodec(instance -> BlacksmithGavelLootModifier.codecStart((RecordCodecBuilder.Instance)instance).apply((Applicative)instance, BlacksmithGavelLootModifier::new)));

    public BlacksmithGavelLootModifier(LootItemCondition[] conditions) {
        super(conditions);
    }

    @Nonnull
    protected ObjectArrayList<ItemStack> doApply(@NotNull ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        BlockState state = (BlockState)context.getParamOrNull(LootContextParams.BLOCK_STATE);
        ItemStack stack = (ItemStack)context.getParamOrNull(LootContextParams.TOOL);
        if (state == null || stack == null) {
            return generatedLoot;
        }
        if (this.isValidGavel(stack, (HolderLookup.Provider)context.getLevel().registryAccess()) && state.is(Tags.Blocks.ORES) && !state.is(ModTags.Blocks.BLACKSMITH_GAVEL_UNAFFECTED)) {
            generatedLoot.addAll((ObjectList)generatedLoot.clone());
        }
        return generatedLoot;
    }

    private boolean isValidGavel(ItemStack stack, HolderLookup.Provider lookupProvider) {
        return stack.is(ModTags.Items.BLACKSMITH_GAVEL) && stack.getEnchantmentLevel((Holder)lookupProvider.lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(Enchantments.SILK_TOUCH)) == 0;
    }

    public MapCodec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }
}

