/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.world.feature;

import com.mojang.serialization.Codec;
import com.stal111.forbidden_arcanus.common.world.feature.config.BigFungyssFeatureConfig;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.HugeMushroomBlock;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.neoforged.neoforge.common.Tags;

public class MegaFungyssFeature
extends Feature<BigFungyssFeatureConfig> {
    public MegaFungyssFeature(Codec<BigFungyssFeatureConfig> codec) {
        super(codec);
    }

    private int getRandomHeight(RandomSource random) {
        return random.nextInt(4) + 11;
    }

    private boolean canGenerate(LevelAccessor world, ChunkGenerator generator, BlockPos pos, int height, BlockPos.MutableBlockPos mutable) {
        if (pos.getY() < 1 || pos.getY() + height + 1 >= generator.getGenDepth()) {
            return false;
        }
        if (!world.getBlockState(pos.below()).is(Tags.Blocks.STONES)) {
            return false;
        }
        for (int i = 0; i <= height; ++i) {
            BlockState state = world.getBlockState((BlockPos)mutable.setWithOffset((Vec3i)pos, 0, i, 0));
            if (state.isAir()) continue;
            return false;
        }
        return true;
    }

    public boolean place(@Nonnull FeaturePlaceContext<BigFungyssFeatureConfig> context) {
        WorldGenLevel level = context.level();
        BlockPos pos = context.origin();
        RandomSource rand = context.random();
        int height = this.getRandomHeight(context.random());
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        if (!this.canGenerate((LevelAccessor)level, context.chunkGenerator(), pos, height, mutable)) {
            return false;
        }
        this.placeStem((LevelAccessor)level, rand, pos, height, mutable, (BigFungyssFeatureConfig)context.config());
        this.placeCap((LevelAccessor)level, rand, pos, height, mutable, (BigFungyssFeatureConfig)context.config());
        return true;
    }

    private void placeStem(LevelAccessor world, RandomSource random, BlockPos pos, int height, BlockPos.MutableBlockPos mutable, BigFungyssFeatureConfig config) {
        for (int i = 0; i < height; ++i) {
            this.placeStemBlock(world, config.stemProvider.getState(random, pos), mutable, pos, 0, i, 0);
            this.placeStemBlock(world, config.stemProvider.getState(random, pos), mutable, pos, 1, i, 0);
            this.placeStemBlock(world, config.stemProvider.getState(random, pos), mutable, pos, 1, i, 1);
            this.placeStemBlock(world, config.stemProvider.getState(random, pos), mutable, pos, 0, i, 1);
        }
    }

    private void placeStemBlock(LevelAccessor world, BlockState state, BlockPos.MutableBlockPos mutable, BlockPos pos, int xOffset, int yOffset, int zOffset) {
        mutable.set((Vec3i)pos).move(xOffset, yOffset, zOffset);
        if (!world.getBlockState((BlockPos)mutable).isSolidRender((BlockGetter)world, (BlockPos)mutable)) {
            this.setBlock((LevelWriter)world, (BlockPos)mutable, state);
        }
    }

    private void placeCap(LevelAccessor world, RandomSource random, BlockPos pos, int height, BlockPos.MutableBlockPos mutable, BigFungyssFeatureConfig config) {
        for (int i = height - 3; i <= height; ++i) {
            int zOffset;
            int xOffset;
            int distanceToStem = 2;
            for (xOffset = -distanceToStem; xOffset <= distanceToStem + 1; ++xOffset) {
                for (zOffset = -distanceToStem; zOffset <= distanceToStem + 1; ++zOffset) {
                    boolean moveDown;
                    boolean flag2;
                    boolean flag1 = i >= height && xOffset != -distanceToStem && xOffset != distanceToStem + 1 && zOffset != -distanceToStem && zOffset != distanceToStem + 1;
                    boolean bl = flag2 = i < height && (xOffset == -distanceToStem || xOffset == distanceToStem + 1 || zOffset == -distanceToStem || zOffset == distanceToStem + 1) && (xOffset != -distanceToStem && xOffset != distanceToStem + 1 || zOffset != -distanceToStem && zOffset != distanceToStem + 1);
                    if (!flag1 && !flag2) continue;
                    mutable.setWithOffset((Vec3i)pos, xOffset, i, zOffset);
                    boolean bl2 = moveDown = xOffset == -1 && zOffset == -1 || xOffset == -1 && zOffset == 2 || xOffset == 2 && zOffset == -1 || xOffset == 2 && zOffset == 2;
                    if (moveDown) {
                        mutable.move(Direction.DOWN);
                    }
                    BlockState state = i == height && !moveDown ? config.capProvider.getState(random, pos) : (BlockState)((BlockState)((BlockState)((BlockState)config.capProvider.getState(random, pos).setValue((Property)HugeMushroomBlock.WEST, (Comparable)Boolean.valueOf(xOffset < 0))).setValue((Property)HugeMushroomBlock.EAST, (Comparable)Boolean.valueOf(xOffset > 0))).setValue((Property)HugeMushroomBlock.NORTH, (Comparable)Boolean.valueOf(zOffset < 0))).setValue((Property)HugeMushroomBlock.SOUTH, (Comparable)Boolean.valueOf(zOffset > 0));
                    this.setBlock((LevelWriter)world, (BlockPos)mutable, state);
                }
            }
            for (xOffset = 0; xOffset <= 1; ++xOffset) {
                for (zOffset = 0; zOffset <= 1; ++zOffset) {
                    for (Direction direction : Direction.values()) {
                        if (direction.getAxis() == Direction.Axis.Y) continue;
                        mutable.setWithOffset((Vec3i)pos, xOffset, height - 5, zOffset);
                        mutable.move(direction);
                        if (!world.getBlockState((BlockPos)mutable).isAir()) continue;
                        this.setBlock((LevelWriter)world, (BlockPos)mutable, (BlockState)config.capProvider.getState(random, pos).setValue((Property)PipeBlock.PROPERTY_BY_DIRECTION.get(direction.getOpposite()), (Comparable)Boolean.valueOf(false)));
                    }
                }
            }
        }
        int xOffset = random.nextInt(2);
        int zOffset = random.nextInt(2);
        if (config.variant == 0) {
            this.placeSmallCap(world, random, pos, height, mutable, xOffset, zOffset, config);
            this.placeSmallCap(world, random, pos, height - 2, mutable, xOffset == 0 ? 1 : 0, zOffset == 0 ? 1 : 0, config);
        } else {
            this.placeSmallFungyss(world, random, pos, height - 1, mutable, xOffset, zOffset, config);
            this.placeSmallFungyss(world, random, pos, height - 2, mutable, xOffset == 0 ? 1 : 0, zOffset == 0 ? 1 : 0, config);
        }
    }

    private void placeSmallCap(LevelAccessor world, RandomSource random, BlockPos pos, int height, BlockPos.MutableBlockPos mutable, int xOffset, int zOffset, BigFungyssFeatureConfig config) {
        Direction direction = this.getDirectionFromOffset(xOffset, zOffset);
        mutable.setWithOffset((Vec3i)pos, xOffset, height - 8, zOffset);
        mutable.move(direction);
        this.setBlock((LevelWriter)world, (BlockPos)mutable, (BlockState)config.capProvider.getState(random, pos).setValue((Property)PipeBlock.PROPERTY_BY_DIRECTION.get(direction.getOpposite()), (Comparable)Boolean.valueOf(false)));
        for (int i = 0; i <= 1; ++i) {
            direction = direction == Direction.SOUTH ? Direction.EAST : Direction.from2DDataValue((int)(direction.get2DDataValue() - 1));
            mutable.move(direction);
            this.setBlock((LevelWriter)world, (BlockPos)mutable, (BlockState)config.capProvider.getState(random, pos).setValue((Property)PipeBlock.PROPERTY_BY_DIRECTION.get(direction.getOpposite().getClockWise()), (Comparable)Boolean.valueOf(false)));
        }
    }

    private void placeSmallFungyss(LevelAccessor world, RandomSource random, BlockPos pos, int height, BlockPos.MutableBlockPos mutable, int xOffset, int zOffset, BigFungyssFeatureConfig config) {
        Direction direction = this.getDirectionFromOffset(xOffset, zOffset);
        int stemHeight = world.getRandom().nextInt(2) + 2;
        mutable.setWithOffset((Vec3i)pos, xOffset, height - 8, zOffset);
        mutable.move(direction);
        if (stemHeight == 3) {
            mutable.move(Direction.DOWN);
        }
        this.setBlock((LevelWriter)world, (BlockPos)mutable, (BlockState)config.stemProvider.getState(random, pos).setValue((Property)BlockStateProperties.AXIS, (Comparable)direction.getAxis()));
        mutable.move(direction);
        this.setBlock((LevelWriter)world, (BlockPos)mutable, (BlockState)config.hyphaeProvider.getState(random, pos).setValue((Property)BlockStateProperties.AXIS, (Comparable)direction.getAxis()));
        for (int i = 0; i < stemHeight; ++i) {
            mutable.move(Direction.UP);
            this.setBlock((LevelWriter)world, (BlockPos)mutable, (BlockState)config.stemProvider.getState(random, pos).setValue((Property)BlockStateProperties.AXIS, (Comparable)Direction.Axis.Y));
        }
        pos = mutable.immutable();
        int distanceToStem = 1;
        for (int i = stemHeight; i <= stemHeight + 1; ++i) {
            for (int xPos = -distanceToStem; xPos <= distanceToStem; ++xPos) {
                for (int zPos = -distanceToStem; zPos <= distanceToStem; ++zPos) {
                    if ((i >= stemHeight + 1 || xPos == 0 && zPos == 0) && this.isCorner(xPos, zPos, distanceToStem)) continue;
                    mutable.setWithOffset((Vec3i)pos, xPos, i - stemHeight, zPos);
                    this.setBlock((LevelWriter)world, (BlockPos)mutable, config.capProvider.getState(random, pos));
                }
            }
        }
        this.setBlock((LevelWriter)world, pos.above(), config.capProvider.getState(random, pos));
    }

    private Direction getDirectionFromOffset(int xOffset, int zOffset) {
        if (xOffset == 0 && zOffset == 0) {
            return Direction.NORTH;
        }
        if (xOffset == 0 && zOffset == 1) {
            return Direction.WEST;
        }
        if (xOffset == 1 && zOffset == 0) {
            return Direction.EAST;
        }
        return Direction.SOUTH;
    }

    private boolean isCorner(int xOffset, int zOffset, int distanceToStem) {
        return (xOffset == -distanceToStem || xOffset == distanceToStem) == (zOffset == -distanceToStem || zOffset == distanceToStem);
    }
}

