/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.world.structure;

import com.stal111.forbidden_arcanus.ForbiddenArcanus;
import com.stal111.forbidden_arcanus.core.init.world.ModStructurePieces;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.TemplateStructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockIgnoreProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public class NipaPieces {
    public static final ResourceLocation NIPA = ForbiddenArcanus.location("nipa");
    public static final ResourceLocation NIPA_FLOATING = ForbiddenArcanus.location("nipa_floating");

    public static class Piece
    extends TemplateStructurePiece {
        private final boolean floating;

        public Piece(StructureTemplateManager structureManager, ResourceLocation templateName, BlockPos templatePosition, Rotation rotation, boolean floating) {
            super((StructurePieceType)ModStructurePieces.NIPA.get(), 0, structureManager, templateName, templateName.toString(), Piece.makeSettings(rotation), templatePosition);
            this.floating = floating;
        }

        public Piece(StructurePieceSerializationContext context, CompoundTag tag) {
            super((StructurePieceType)ModStructurePieces.NIPA.get(), tag, context.structureTemplateManager(), resourceLocation -> Piece.makeSettings(Rotation.valueOf((String)tag.getString("Rot"))));
            this.floating = tag.getBoolean("Floating");
        }

        private static StructurePlaceSettings makeSettings(Rotation rotation) {
            return new StructurePlaceSettings().setRotation(rotation).setMirror(Mirror.NONE).addProcessor((StructureProcessor)BlockIgnoreProcessor.STRUCTURE_BLOCK);
        }

        protected void addAdditionalSaveData(@Nonnull StructurePieceSerializationContext context, @Nonnull CompoundTag tag) {
            super.addAdditionalSaveData(context, tag);
            tag.putString("Rot", this.placeSettings.getRotation().name());
            tag.putBoolean("Floating", this.floating);
        }

        protected void handleDataMarker(@Nonnull String marker, @Nonnull BlockPos pos, @Nonnull ServerLevelAccessor level, @Nonnull RandomSource random, @Nonnull BoundingBox box) {
        }

        public void postProcess(WorldGenLevel level, @Nonnull StructureManager structureManager, @Nonnull ChunkGenerator generator, @Nonnull RandomSource random, @Nonnull BoundingBox boundingBox, @Nonnull ChunkPos chunkPos, BlockPos pos) {
            int i = level.getHeight(Heightmap.Types.WORLD_SURFACE_WG, pos.getX(), pos.getZ());
            this.templatePosition = new BlockPos(this.templatePosition.getX(), this.floating ? i + 60 : i - 3, this.templatePosition.getZ());
            super.postProcess(level, structureManager, generator, random, boundingBox, chunkPos, pos);
        }
    }
}

