/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.world.structure;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.stal111.forbidden_arcanus.common.world.structure.NipaPieces;
import com.stal111.forbidden_arcanus.core.init.world.ModStructureTypes;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;

public class NipaStructure
extends Structure {
    public static final MapCodec<NipaStructure> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)NipaStructure.settingsCodec((RecordCodecBuilder.Instance)instance), (App)Codec.BOOL.fieldOf("floating").forGetter(structure -> structure.floating)).apply((Applicative)instance, NipaStructure::new));
    private final boolean floating;

    public NipaStructure(Structure.StructureSettings settings, boolean floating) {
        super(settings);
        this.floating = floating;
    }

    private void generatePieces(StructurePiecesBuilder piecesBuilder, Structure.GenerationContext context) {
        BlockPos pos = new BlockPos(context.chunkPos().getWorldPosition().getX(), 90, context.chunkPos().getWorldPosition().getZ());
        WorldgenRandom random = context.random();
        piecesBuilder.addPiece((StructurePiece)new NipaPieces.Piece(context.structureTemplateManager(), this.floating ? NipaPieces.NIPA_FLOATING : NipaPieces.NIPA, pos, Rotation.getRandom((RandomSource)random), this.floating));
    }

    @Nonnull
    public GenerationStep.Decoration step() {
        return GenerationStep.Decoration.SURFACE_STRUCTURES;
    }

    @Nonnull
    public Optional<Structure.GenerationStub> findGenerationPoint(@Nonnull Structure.GenerationContext generationContext) {
        return NipaStructure.onTopOfChunkCenter((Structure.GenerationContext)generationContext, (Heightmap.Types)Heightmap.Types.WORLD_SURFACE_WG, piecesBuilder -> this.generatePieces((StructurePiecesBuilder)piecesBuilder, generationContext));
    }

    @Nonnull
    public StructureType<?> type() {
        return (StructureType)ModStructureTypes.NIPA.get();
    }
}

