/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.data.model;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.stal111.forbidden_arcanus.ForbiddenArcanus;
import com.stal111.forbidden_arcanus.common.block.DeskBlock;
import com.stal111.forbidden_arcanus.common.block.EssenceUtremJarBlock;
import com.stal111.forbidden_arcanus.common.block.HephaestusForgeBlock;
import com.stal111.forbidden_arcanus.common.block.pedestal.PedestalBlock;
import com.stal111.forbidden_arcanus.common.block.properties.ModBlockStateProperties;
import com.stal111.forbidden_arcanus.common.block.properties.PillarType;
import com.stal111.forbidden_arcanus.core.init.ModBlocks;
import com.stal111.forbidden_arcanus.data.FABlockFamilies;
import com.stal111.forbidden_arcanus.data.model.ModModelTemplates;
import com.stal111.forbidden_arcanus.data.model.ModTextureMapping;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.data.BlockFamily;
import net.minecraft.data.models.BlockModelGenerators;
import net.minecraft.data.models.blockstates.BlockStateGenerator;
import net.minecraft.data.models.blockstates.MultiVariantGenerator;
import net.minecraft.data.models.blockstates.PropertyDispatch;
import net.minecraft.data.models.blockstates.Variant;
import net.minecraft.data.models.blockstates.VariantProperties;
import net.minecraft.data.models.model.DelegatedModel;
import net.minecraft.data.models.model.ModelLocationUtils;
import net.minecraft.data.models.model.ModelTemplates;
import net.minecraft.data.models.model.TextureMapping;
import net.minecraft.data.models.model.TextureSlot;
import net.minecraft.data.models.model.TexturedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class ModBlockModels {
    private final BlockModelGenerators generators;
    private final Consumer<BlockStateGenerator> blockStateOutput;
    private final BiConsumer<ResourceLocation, Supplier<JsonElement>> modelOutput;
    private final Consumer<Item> skippedAutoItemModels;
    private final Map<Block, TexturedModel> texturedModels = ImmutableMap.builder().put((Object)((Block)ModBlocks.CUT_SOULLESS_SANDSTONE.get()), (Object)TexturedModel.COLUMN.get((Block)ModBlocks.CUT_SOULLESS_SANDSTONE.get())).build();

    private ModBlockModels(BlockModelGenerators generators, Consumer<Item> skippedAutoItemModels) {
        this.generators = generators;
        this.blockStateOutput = generators.blockStateOutput;
        this.modelOutput = generators.modelOutput;
        this.skippedAutoItemModels = skippedAutoItemModels;
        this.generators.fullBlockModelCustomGenerators = ImmutableMap.builder().put((Object)((Block)ModBlocks.DARKSTONE.get()), BlockModelGenerators::createMirroredCubeGenerator).build();
    }

    public static void create(BlockModelGenerators generators, Consumer<Item> skippedAutoItemModels) {
        new ModBlockModels(generators, skippedAutoItemModels).createModels();
    }

    public void createModels() {
        FABlockFamilies.getAllFamilies().filter(BlockFamily::shouldGenerateModel).forEach(blockFamily -> this.family(blockFamily.getBaseBlock()).generateFor(blockFamily));
        this.createSimpleFlatItemModel((ItemLike)ModBlocks.DEORUM_CHAIN.get());
        this.createSimpleFlatItemModel((ItemLike)ModBlocks.NIPA.get());
        this.createSimpleFlatItemModel((ItemLike)ModBlocks.ARCANE_DRAGON_EGG.get());
        this.generators.createTrivialCube((Block)ModBlocks.SOULLESS_SAND.get());
        this.generators.createTrivialCube((Block)ModBlocks.GILDED_CHISELED_POLISHED_DARKSTONE.get());
        this.generators.createTrivialCube((Block)ModBlocks.TILED_POLISHED_DARKSTONE_BRICKS.get());
        this.generators.createTrivialCube((Block)ModBlocks.QUANTUM_INJECTOR.get());
        this.createEmissiveLayerCube((Block)ModBlocks.ARCANE_CRYSTAL_ORE.get(), "arcane_crystal_ore");
        this.createEmissiveLayerCube((Block)ModBlocks.DEEPSLATE_ARCANE_CRYSTAL_ORE.get(), "arcane_crystal_ore");
        this.createEmissiveLayerCube((Block)ModBlocks.RUNIC_STONE.get(), "runic_stone");
        this.createEmissiveLayerCube((Block)ModBlocks.RUNIC_DEEPSLATE.get(), "runic_stone");
        this.createEmissiveLayerCube((Block)ModBlocks.RUNIC_DARKSTONE.get(), "runic_stone");
        this.generators.createTrivialCube((Block)ModBlocks.STELLA_ARCANUM.get());
        this.createEmissiveCube((Block)ModBlocks.ARCANE_CRYSTAL_BLOCK.get());
        this.generators.createTrivialCube((Block)ModBlocks.CORRUPTED_ARCANE_CRYSTAL_BLOCK.get());
        this.generators.createTrivialCube((Block)ModBlocks.RUNE_BLOCK.get());
        this.generators.createTrivialCube((Block)ModBlocks.DARK_RUNE_BLOCK.get());
        this.generators.createTrivialCube((Block)ModBlocks.STELLARITE_BLOCK.get());
        this.generators.createTrivialCube((Block)ModBlocks.DEORUM_BLOCK.get());
        this.generators.createTrivialCube((Block)ModBlocks.OBSIDIANSTEEL_BLOCK.get());
        this.generators.createTrivialCube((Block)ModBlocks.AURUM_LEAVES.get());
        this.generators.createTrivialCube((Block)ModBlocks.NUGGETY_AURUM_LEAVES.get());
        this.generators.createTrivialCube((Block)ModBlocks.FUNGYSS_BLOCK.get());
        this.createForbiddenomicon((Block)ModBlocks.FORBIDDENOMICON.get());
        this.createDesk((DeskBlock)((Object)ModBlocks.DESK.get()), false);
        this.createDesk((DeskBlock)((Object)ModBlocks.RESEARCH_DESK.get()), true);
        this.createPedestal((PedestalBlock)((Object)ModBlocks.DARKSTONE_PEDESTAL.get()));
        this.createPedestal((PedestalBlock)((Object)ModBlocks.MAGNETIZED_DARKSTONE_PEDESTAL.get()));
        this.createClibanoCore((Block)ModBlocks.CLIBANO_CORE.get());
        this.createClibanoCenter((Block)ModBlocks.CLIBANO_CENTER.get());
        this.createClibanoCorner((Block)ModBlocks.CLIBANO_CORNER.get());
        this.createClibanoSideHorizontal((Block)ModBlocks.CLIBANO_SIDE_HORIZONTAL.get());
        this.createClibanoSideVertical((Block)ModBlocks.CLIBANO_SIDE_VERTICAL.get());
        this.createHephaestusForge((HephaestusForgeBlock)((Object)ModBlocks.HEPHAESTUS_FORGE_TIER_1.get()));
        this.createHephaestusForge((HephaestusForgeBlock)((Object)ModBlocks.HEPHAESTUS_FORGE_TIER_2.get()));
        this.createHephaestusForge((HephaestusForgeBlock)((Object)ModBlocks.HEPHAESTUS_FORGE_TIER_3.get()));
        this.createHephaestusForge((HephaestusForgeBlock)((Object)ModBlocks.HEPHAESTUS_FORGE_TIER_4.get()));
        this.createHephaestusForge((HephaestusForgeBlock)((Object)ModBlocks.HEPHAESTUS_FORGE_TIER_5.get()));
        this.createObelisk((Block)ModBlocks.ARCANE_CRYSTAL_OBELISK.get());
        this.createObelisk((Block)ModBlocks.CORRUPTED_ARCANE_CRYSTAL_OBELISK.get());
        this.createUtremJar((Block)ModBlocks.UTREM_JAR.get());
        this.blockStateOutput.accept((BlockStateGenerator)ModBlockModels.createSimpleBlock((Block)ModBlocks.ESSENCE_UTREM_JAR.get(), ModelLocationUtils.getModelLocation((Block)((Block)ModBlocks.UTREM_JAR.get()))));
        ModModelTemplates.UTREM_JAR_ITEM.create(ModelLocationUtils.getModelLocation((Item)((EssenceUtremJarBlock)((Object)ModBlocks.ESSENCE_UTREM_JAR.get())).asItem()), TextureMapping.particle((Block)((Block)ModBlocks.UTREM_JAR.get())), this.modelOutput);
        this.createPillar((Block)ModBlocks.ARCANE_POLISHED_DARKSTONE_PILLAR.get());
        this.createNonTemplateModelBlock((Block)ModBlocks.QUANTUM_CORE.get());
        this.generators.createDoor((Block)ModBlocks.DEORUM_DOOR.get());
        this.generators.createTrapdoor((Block)ModBlocks.DEORUM_TRAPDOOR.get());
        this.generators.createAxisAlignedPillarBlockCustomModel((Block)ModBlocks.DEORUM_CHAIN.get(), ModelLocationUtils.getModelLocation((Block)((Block)ModBlocks.DEORUM_CHAIN.get())));
        this.generators.createGlassBlocks((Block)ModBlocks.DEORUM_GLASS.get(), (Block)ModBlocks.DEORUM_GLASS_PANE.get());
        this.generators.createGlassBlocks((Block)ModBlocks.RUNIC_GLASS.get(), (Block)ModBlocks.RUNIC_GLASS_PANE.get());
        this.generators.createGlassBlocks((Block)ModBlocks.DARK_RUNIC_GLASS.get(), (Block)ModBlocks.DARK_RUNIC_GLASS_PANE.get());
        this.generators.createLantern((Block)ModBlocks.DEORUM_LANTERN.get());
        this.generators.createLantern((Block)ModBlocks.DEORUM_SOUL_LANTERN.get());
        this.generators.createPlant((Block)ModBlocks.FUNGYSS.get(), (Block)ModBlocks.POTTED_FUNGYSS.get(), BlockModelGenerators.TintState.NOT_TINTED);
        this.generators.createPlant((Block)ModBlocks.AURUM_SAPLING.get(), (Block)ModBlocks.POTTED_AURUM_SAPLING.get(), BlockModelGenerators.TintState.NOT_TINTED);
        this.generators.createPlant((Block)ModBlocks.GROWING_EDELWOOD.get(), (Block)ModBlocks.POTTED_GROWING_EDELWOOD.get(), BlockModelGenerators.TintState.NOT_TINTED);
        this.generators.createPlant((Block)ModBlocks.YELLOW_ORCHID.get(), (Block)ModBlocks.POTTED_YELLOW_ORCHID.get(), BlockModelGenerators.TintState.NOT_TINTED);
        this.generators.woodProvider((Block)ModBlocks.FUNGYSS_STEM.get()).log((Block)ModBlocks.FUNGYSS_STEM.get()).wood((Block)ModBlocks.FUNGYSS_HYPHAE.get());
        this.generators.woodProvider((Block)ModBlocks.AURUM_LOG.get()).logWithHorizontal((Block)ModBlocks.AURUM_LOG.get()).wood((Block)ModBlocks.AURUM_WOOD.get());
        this.generators.woodProvider((Block)ModBlocks.STRIPPED_AURUM_LOG.get()).logWithHorizontal((Block)ModBlocks.STRIPPED_AURUM_LOG.get()).wood((Block)ModBlocks.STRIPPED_AURUM_WOOD.get());
        this.createHollowLog((Block)ModBlocks.EDELWOOD_LOG.get());
        this.createHollowLogWithFace((Block)ModBlocks.CARVED_EDELWOOD_LOG.get());
        this.blockStateOutput.accept((BlockStateGenerator)ModBlockModels.createSimpleBlock((Block)ModBlocks.EDELWOOD_BRANCH.get(), ModelLocationUtils.getModelLocation((Block)((Block)ModBlocks.EDELWOOD_BRANCH.get()))));
        this.createMagicalFarmland();
        this.blockEntityModels(ModelLocationUtils.getModelLocation((Block)ModBlocks.OBSIDIAN_SKULL.getSkull()), Blocks.SOUL_SAND).createWithCustomBlockItemModel(ModelTemplates.SKULL_INVENTORY, new Block[]{ModBlocks.OBSIDIAN_SKULL.getSkull(), ModBlocks.CRACKED_OBSIDIAN_SKULL.getSkull(), ModBlocks.FRAGMENTED_OBSIDIAN_SKULL.getSkull(), ModBlocks.FADING_OBSIDIAN_SKULL.getSkull(), ModBlocks.AUREALIC_OBSIDIAN_SKULL.getSkull(), ModBlocks.ETERNAL_OBSIDIAN_SKULL.getSkull()}).createWithoutBlockItem(new Block[]{ModBlocks.OBSIDIAN_SKULL.getWallSkull(), ModBlocks.CRACKED_OBSIDIAN_SKULL.getWallSkull(), ModBlocks.FRAGMENTED_OBSIDIAN_SKULL.getWallSkull(), ModBlocks.FADING_OBSIDIAN_SKULL.getWallSkull(), ModBlocks.AUREALIC_OBSIDIAN_SKULL.getWallSkull(), ModBlocks.ETERNAL_OBSIDIAN_SKULL.getWallSkull()});
    }

    public BlockModelGenerators.BlockFamilyProvider family(Block block) {
        TexturedModel texturedmodel = this.texturedModels.getOrDefault(block, TexturedModel.CUBE.get(block));
        BlockModelGenerators blockModelGenerators = this.generators;
        Objects.requireNonNull(blockModelGenerators);
        return new BlockModelGenerators.BlockFamilyProvider(blockModelGenerators, texturedmodel.getMapping()).fullBlock(block, texturedmodel.getTemplate());
    }

    private BlockModelGenerators.BlockEntityModelGenerator blockEntityModels(ResourceLocation modelLocation, Block block) {
        BlockModelGenerators blockModelGenerators = this.generators;
        Objects.requireNonNull(blockModelGenerators);
        return new BlockModelGenerators.BlockEntityModelGenerator(blockModelGenerators, modelLocation, block);
    }

    private void createEmissiveCube(Block block) {
        this.blockStateOutput.accept((BlockStateGenerator)ModBlockModels.createSimpleBlock(block, ModModelTemplates.CUBE_ALL_EMISSIVE.create(block, ModTextureMapping.emissiveCube(block), this.modelOutput)));
    }

    private void createEmissiveLayerCube(Block block, String folder) {
        this.blockStateOutput.accept((BlockStateGenerator)ModBlockModels.createSimpleBlock(block, ModModelTemplates.CUBE_ALL_EMISSIVE_LAYER.create(block, ModTextureMapping.emissiveLayerCube(block, folder), this.modelOutput)));
    }

    private void createForbiddenomicon(Block block) {
        TextureMapping textureMapping = ModTextureMapping.forbiddenomicon(block);
        ResourceLocation model = ModModelTemplates.FORBIDDENOMICON.create(block, textureMapping, this.modelOutput);
        this.blockStateOutput.accept((BlockStateGenerator)ModBlockModels.createSimpleBlock(block, model).with(BlockModelGenerators.createHorizontalFacingDispatch()));
    }

    private void createDesk(DeskBlock block, boolean research) {
        TextureMapping textureMapping = ModTextureMapping.desk(research);
        ResourceLocation model = ModModelTemplates.DESK.create((Block)block, textureMapping, this.modelOutput);
        this.blockStateOutput.accept((BlockStateGenerator)ModBlockModels.createSimpleBlock((Block)block, model).with(BlockModelGenerators.createHorizontalFacingDispatch()));
    }

    private void createPedestal(PedestalBlock block) {
        TextureMapping textureMapping = ModTextureMapping.pedestal(block);
        ResourceLocation model = ModModelTemplates.PEDESTAL.create((Block)block, textureMapping, this.modelOutput);
        this.blockStateOutput.accept((BlockStateGenerator)ModBlockModels.createSimpleBlock(block, model));
    }

    private void createClibanoCore(Block block) {
        TextureMapping textureMapping = ModTextureMapping.clibanoCore();
        ResourceLocation model = ModelTemplates.CUBE_ORIENTABLE.create(block, textureMapping, this.modelOutput);
        this.blockStateOutput.accept((BlockStateGenerator)ModBlockModels.createSimpleBlock(block, model).with(BlockModelGenerators.createHorizontalFacingDispatch()));
    }

    private void createClibanoCenter(Block block) {
        PropertyDispatch dispatch = PropertyDispatch.property(ModBlockStateProperties.CLIBANO_CENTER_TYPE).generate(type -> {
            ResourceLocation model = ModModelTemplates.CLIBANO_CENTER.createWithSuffix(block, "_" + type.getSerializedName(), ModTextureMapping.clibanoCenter(type), this.modelOutput);
            return Variant.variant().with(VariantProperties.MODEL, (Object)model);
        });
        this.blockStateOutput.accept((BlockStateGenerator)MultiVariantGenerator.multiVariant((Block)block).with(dispatch).with(BlockModelGenerators.createFacingDispatch()));
    }

    private void createClibanoCorner(Block block) {
        ResourceLocation model = ForbiddenArcanus.location("block/clibano_corner");
        PropertyDispatch dispatch = PropertyDispatch.property((Property)BlockStateProperties.BOTTOM).generate(bottom -> Variant.variant().with(VariantProperties.X_ROT, (Object)(bottom != false ? VariantProperties.Rotation.R90 : VariantProperties.Rotation.R0)));
        this.blockStateOutput.accept((BlockStateGenerator)ModBlockModels.createSimpleBlock(block, model).with(dispatch).with(BlockModelGenerators.createHorizontalFacingDispatch()));
    }

    private void createClibanoSideHorizontal(Block block) {
        PropertyDispatch typeDispatch = PropertyDispatch.property(ModBlockStateProperties.CLIBANO_SIDE_TYPE).generate(type -> {
            TextureMapping textureMapping = ModTextureMapping.clibanoSide(type);
            ResourceLocation model = ModModelTemplates.CLIBANO_SIDE_HORIZONTAL.createWithSuffix(block, "_" + type.getSerializedName(), textureMapping, this.modelOutput);
            return Variant.variant().with(VariantProperties.MODEL, (Object)model);
        });
        PropertyDispatch.C2 facingDispatch = PropertyDispatch.properties((Property)BlockStateProperties.HORIZONTAL_FACING, (Property)ModBlockStateProperties.MIRRORED).select((Comparable)Direction.EAST, (Comparable)Boolean.valueOf(false), Variant.variant().with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R90)).select((Comparable)Direction.EAST, (Comparable)Boolean.valueOf(true), Variant.variant().with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R0).with(VariantProperties.X_ROT, (Object)VariantProperties.Rotation.R180)).select((Comparable)Direction.SOUTH, (Comparable)Boolean.valueOf(false), Variant.variant().with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R180)).select((Comparable)Direction.SOUTH, (Comparable)Boolean.valueOf(true), Variant.variant().with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R90).with(VariantProperties.X_ROT, (Object)VariantProperties.Rotation.R180)).select((Comparable)Direction.WEST, (Comparable)Boolean.valueOf(false), Variant.variant().with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R270)).select((Comparable)Direction.WEST, (Comparable)Boolean.valueOf(true), Variant.variant().with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R180).with(VariantProperties.X_ROT, (Object)VariantProperties.Rotation.R180)).select((Comparable)Direction.NORTH, (Comparable)Boolean.valueOf(false), Variant.variant()).select((Comparable)Direction.NORTH, (Comparable)Boolean.valueOf(true), Variant.variant().with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R270).with(VariantProperties.X_ROT, (Object)VariantProperties.Rotation.R180));
        this.blockStateOutput.accept((BlockStateGenerator)MultiVariantGenerator.multiVariant((Block)block).with(typeDispatch).with((PropertyDispatch)facingDispatch));
    }

    private void createClibanoSideVertical(Block block) {
        PropertyDispatch typeDispatch = PropertyDispatch.property(ModBlockStateProperties.CLIBANO_SIDE_TYPE).generate(type -> {
            TextureMapping textureMapping = ModTextureMapping.clibanoSide(type);
            ResourceLocation model = ModModelTemplates.CLIBANO_SIDE_VERTICAL.createWithSuffix(block, "_" + type.getSerializedName(), textureMapping, this.modelOutput);
            return Variant.variant().with(VariantProperties.MODEL, (Object)model);
        });
        PropertyDispatch.C2 facingDispatch = PropertyDispatch.properties((Property)BlockStateProperties.HORIZONTAL_FACING, (Property)ModBlockStateProperties.MIRRORED).select((Comparable)Direction.EAST, (Comparable)Boolean.valueOf(false), Variant.variant().with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R90)).select((Comparable)Direction.EAST, (Comparable)Boolean.valueOf(true), Variant.variant().with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R270).with(VariantProperties.X_ROT, (Object)VariantProperties.Rotation.R180)).select((Comparable)Direction.SOUTH, (Comparable)Boolean.valueOf(false), Variant.variant().with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R180)).select((Comparable)Direction.SOUTH, (Comparable)Boolean.valueOf(true), Variant.variant().with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R0).with(VariantProperties.X_ROT, (Object)VariantProperties.Rotation.R180)).select((Comparable)Direction.WEST, (Comparable)Boolean.valueOf(false), Variant.variant().with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R270)).select((Comparable)Direction.WEST, (Comparable)Boolean.valueOf(true), Variant.variant().with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R90).with(VariantProperties.X_ROT, (Object)VariantProperties.Rotation.R180)).select((Comparable)Direction.NORTH, (Comparable)Boolean.valueOf(false), Variant.variant()).select((Comparable)Direction.NORTH, (Comparable)Boolean.valueOf(true), Variant.variant().with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R180).with(VariantProperties.X_ROT, (Object)VariantProperties.Rotation.R180));
        this.blockStateOutput.accept((BlockStateGenerator)MultiVariantGenerator.multiVariant((Block)block).with(typeDispatch).with((PropertyDispatch)facingDispatch));
    }

    private void createHephaestusForge(HephaestusForgeBlock block) {
        TextureMapping textureMapping = ModTextureMapping.hephaestusForge(block.getLevel().getAsInt());
        ResourceLocation model = ModModelTemplates.HEPHAESTUS_FORGE.create((Block)block, textureMapping, this.modelOutput);
        this.blockStateOutput.accept((BlockStateGenerator)ModBlockModels.createSimpleBlock(block, model));
    }

    private void createObelisk(Block block) {
        PropertyDispatch dispatch = PropertyDispatch.property(ModBlockStateProperties.OBELISK_PART).generate(part -> {
            TextureMapping textureMapping = ModTextureMapping.obelisk(block, part);
            ResourceLocation model = ModModelTemplates.OBELISK.get(part).createWithSuffix(block, "_" + part.getSerializedName(), textureMapping, this.modelOutput);
            return Variant.variant().with(VariantProperties.MODEL, (Object)model);
        });
        this.createSimpleFlatItemModel((ItemLike)block);
        this.blockStateOutput.accept((BlockStateGenerator)MultiVariantGenerator.multiVariant((Block)block).with(dispatch));
    }

    private void createUtremJar(Block block) {
        TextureMapping textureMapping = ModTextureMapping.utremJar(block);
        ResourceLocation model = ModModelTemplates.UTREM_JAR.create(block, textureMapping, this.modelOutput);
        this.blockStateOutput.accept((BlockStateGenerator)ModBlockModels.createSimpleBlock(block, model));
    }

    private void createPillar(Block block) {
        PropertyDispatch dispatch = PropertyDispatch.properties(ModBlockStateProperties.PILLAR_TYPE, (Property)RotatedPillarBlock.AXIS).generate((part, axis) -> Variant.variant().with(VariantProperties.MODEL, (Object)ForbiddenArcanus.location("block/arcane_polished_darkstone_pillar" + (String)(part == PillarType.SINGLE ? "" : "_" + (axis == Direction.Axis.Z ? part.getOpposite() : part).getSerializedName()))).with(VariantProperties.Y_ROT, (Object)(axis == Direction.Axis.X ? VariantProperties.Rotation.R90 : VariantProperties.Rotation.R0)).with(VariantProperties.X_ROT, (Object)(axis == Direction.Axis.Y ? VariantProperties.Rotation.R0 : VariantProperties.Rotation.R90)));
        this.blockStateOutput.accept((BlockStateGenerator)MultiVariantGenerator.multiVariant((Block)block).with(dispatch));
    }

    private void createHollowLog(Block block) {
        TextureMapping textureMapping = ModTextureMapping.edelwoodLog();
        ResourceLocation model = ModModelTemplates.HOLLOW_LOG.create(block, textureMapping, this.modelOutput);
        this.blockStateOutput.accept((BlockStateGenerator)ModBlockModels.createSimpleBlock(block, model));
    }

    private void createHollowLogWithFace(Block block) {
        TextureMapping textureMapping = ModTextureMapping.edelwoodLogWithFace(false);
        TextureMapping textureMappingWithLeaves = ModTextureMapping.edelwoodLogWithFace(true);
        ResourceLocation model = ModModelTemplates.HOLLOW_LOG_FACE.create(block, textureMapping, this.modelOutput);
        ResourceLocation modelWithLaves = ModModelTemplates.HOLLOW_LOG_FACE_AND_LEAVES.createWithSuffix(block, "_leaves", textureMappingWithLeaves, this.modelOutput);
        PropertyDispatch dispatch = PropertyDispatch.property((Property)ModBlockStateProperties.LEAVES).generate(hasLeaves -> Variant.variant().with(VariantProperties.MODEL, (Object)(hasLeaves != false ? modelWithLaves : model)));
        this.blockStateOutput.accept((BlockStateGenerator)ModBlockModels.createSimpleBlock(block, model).with(BlockModelGenerators.createHorizontalFacingDispatch()).with(dispatch));
    }

    private void createMagicalFarmland() {
        TextureMapping textureMapping = new TextureMapping().put(TextureSlot.DIRT, ForbiddenArcanus.location("block/magical_dirt")).put(TextureSlot.TOP, TextureMapping.getBlockTexture((Block)((Block)ModBlocks.MAGICAL_FARMLAND.get())));
        TextureMapping moistTextureMapping = new TextureMapping().put(TextureSlot.DIRT, ForbiddenArcanus.location("block/magical_dirt")).put(TextureSlot.TOP, TextureMapping.getBlockTexture((Block)((Block)ModBlocks.MAGICAL_FARMLAND.get()), (String)"_moist"));
        ResourceLocation model = ModelTemplates.FARMLAND.create((Block)ModBlocks.MAGICAL_FARMLAND.get(), textureMapping, this.modelOutput);
        ResourceLocation moistModel = ModelTemplates.FARMLAND.create(TextureMapping.getBlockTexture((Block)((Block)ModBlocks.MAGICAL_FARMLAND.get()), (String)"_moist"), moistTextureMapping, this.modelOutput);
        this.blockStateOutput.accept((BlockStateGenerator)MultiVariantGenerator.multiVariant((Block)((Block)ModBlocks.MAGICAL_FARMLAND.get())).with(BlockModelGenerators.createEmptyOrFullDispatch((Property)BlockStateProperties.MOISTURE, (Comparable)Integer.valueOf(7), (ResourceLocation)moistModel, (ResourceLocation)model)));
    }

    private void createNonTemplateModelBlock(Block pBlock) {
        this.createNonTemplateModelBlock(pBlock, pBlock);
    }

    private void createNonTemplateModelBlock(Block pBlock, Block pModelBlock) {
        this.blockStateOutput.accept((BlockStateGenerator)ModBlockModels.createSimpleBlock(pBlock, ModelLocationUtils.getModelLocation((Block)pModelBlock)));
    }

    static MultiVariantGenerator createSimpleBlock(Block block, ResourceLocation resourceLocation) {
        return MultiVariantGenerator.multiVariant((Block)block, (Variant)Variant.variant().with(VariantProperties.MODEL, (Object)resourceLocation));
    }

    void createSimpleFlatItemModel(ItemLike item) {
        ModelTemplates.FLAT_ITEM.create(ModelLocationUtils.getModelLocation((Item)item.asItem()), TextureMapping.layer0((Item)item.asItem()), this.modelOutput);
    }

    void delegateItemModel(Block block, ResourceLocation resourceLocation) {
        this.modelOutput.accept(ModelLocationUtils.getModelLocation((Item)block.asItem()), (Supplier<JsonElement>)new DelegatedModel(resourceLocation));
    }
}

