/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.data.recipes;

import com.stal111.forbidden_arcanus.core.init.ModBlocks;
import com.stal111.forbidden_arcanus.core.init.ModItems;
import com.stal111.forbidden_arcanus.data.FABlockFamilies;
import com.stal111.forbidden_arcanus.util.ModTags;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentPredicate;
import net.minecraft.core.component.DataComponents;
import net.minecraft.data.BlockFamily;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.flag.FeatureFlag;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.crafting.DataComponentIngredient;
import net.valhelsia.valhelsia_core.datagen.recipes.RecipePart;
import net.valhelsia.valhelsia_core.datagen.recipes.RecipeSubProvider;
import net.valhelsia.valhelsia_core.datagen.recipes.ValhelsiaRecipeProvider;

public class CraftingRecipeProvider
extends RecipeSubProvider {
    private final ValhelsiaRecipeProvider provider;

    public CraftingRecipeProvider(ValhelsiaRecipeProvider provider) {
        super(provider);
        this.provider = provider;
    }

    protected void registerRecipes(HolderLookup.Provider lookupProvider) {
        FABlockFamilies.getAllFamilies().filter(BlockFamily::shouldGenerateRecipe).forEach(family -> RecipeProvider.generateRecipes((RecipeOutput)this.provider.getRecipeOutput(), (BlockFamily)family, (FeatureFlagSet)FeatureFlagSet.of((FeatureFlag)FeatureFlags.VANILLA)));
        this.shaped(RecipeCategory.TOOLS, (ItemLike)ModItems.SANITY_METER.get(), builder -> builder.pattern("AXA").pattern("X#X").pattern("AXA").define(Character.valueOf('X'), Tags.Items.INGOTS_GOLD).define(Character.valueOf('#'), Tags.Items.ENDER_PEARLS).define(Character.valueOf('A'), (ItemLike)ModItems.ARCANE_CRYSTAL_DUST.get()).unlockedBy((RecipeSubProvider)this, RecipePart.of((Object)Tags.Items.INGOTS_GOLD)));
        this.shaped(RecipeCategory.TOOLS, (ItemLike)ModItems.LENS_OF_VERITATIS.get(), builder -> builder.pattern(" # ").pattern("#X#").pattern("S# ").define(Character.valueOf('#'), (ItemLike)ModItems.SPAWNER_SCRAP.get()).define(Character.valueOf('X'), (ItemLike)ModItems.ARCANE_CRYSTAL.get()).define(Character.valueOf('S'), Tags.Items.RODS_WOODEN).unlockedBy((RecipeSubProvider)this, (ItemLike)ModItems.ARCANE_CRYSTAL.get()));
        this.shaped(RecipeCategory.DECORATIONS, (ItemLike)ModBlocks.UTREM_JAR.get(), builder -> builder.pattern("#X#").pattern("# #").pattern("###").define(Character.valueOf('#'), Tags.Items.GLASS_BLOCKS_COLORLESS).define(Character.valueOf('X'), (ItemLike)ModBlocks.EDELWOOD_PLANKS.get()).unlockedBy((RecipeSubProvider)this, RecipePart.of((Object)Tags.Items.GLASS_BLOCKS_COLORLESS)));
        this.shaped(RecipeCategory.MISC, (ItemLike)ModItems.ARCANE_CRYSTAL_DUST.get(), builder -> builder.pattern("###").pattern("###").pattern("###").define(Character.valueOf('#'), (ItemLike)ModItems.ARCANE_CRYSTAL_DUST_SPECK.get()).unlockedBy((RecipeSubProvider)this, (ItemLike)ModItems.ARCANE_CRYSTAL_DUST_SPECK.get()));
        this.shaped(RecipeCategory.TOOLS, (ItemLike)ModItems.SOUL_EXTRACTOR.get(), builder -> builder.pattern("U  ").pattern("##X").pattern("Q  ").define(Character.valueOf('U'), (ItemLike)ModBlocks.UTREM_JAR.get()).define(Character.valueOf('#'), (ItemLike)Blocks.NETHER_BRICKS).define(Character.valueOf('X'), (ItemLike)Blocks.QUARTZ_BLOCK).define(Character.valueOf('Q'), (ItemLike)Items.QUARTZ).unlockedBy((RecipeSubProvider)this, (ItemLike)ModBlocks.UTREM_JAR.get()));
        this.shaped(RecipeCategory.MISC, (ItemLike)ModItems.ARCANE_BONE_MEAL.get(), 4, builder -> builder.pattern(" # ").pattern("#X#").pattern(" # ").define(Character.valueOf('#'), (ItemLike)Items.BONE_MEAL).define(Character.valueOf('X'), (ItemLike)ModItems.ARCANE_CRYSTAL_DUST.get()).unlockedBy((RecipeSubProvider)this, (ItemLike)ModItems.ARCANE_CRYSTAL_DUST.get()));
        this.shaped(RecipeCategory.MISC, (ItemLike)ModItems.AUREAL_BOTTLE.get(), builder -> builder.pattern("###").pattern("#X#").pattern("###").define(Character.valueOf('#'), (ItemLike)ModItems.ARCANE_CRYSTAL_DUST.get()).define(Character.valueOf('X'), DataComponentIngredient.of((boolean)true, (DataComponentPredicate)DataComponentPredicate.builder().expect(DataComponents.POTION_CONTENTS, (Object)new PotionContents(Potions.STRONG_REGENERATION)).build(), (ItemLike[])new ItemLike[]{Items.POTION})).unlockedBy((RecipeSubProvider)this, (ItemLike)ModItems.ARCANE_CRYSTAL_DUST.get()));
        this.shaped(RecipeCategory.BUILDING_BLOCKS, (ItemLike)ModBlocks.DARKSTONE_PEDESTAL.get(), builder -> builder.pattern("###").pattern(" * ").pattern("XXX").define(Character.valueOf('#'), (ItemLike)ModBlocks.ARCANE_POLISHED_DARKSTONE_SLAB.get()).define(Character.valueOf('*'), (ItemLike)ModBlocks.ARCANE_POLISHED_DARKSTONE_PILLAR.get()).define(Character.valueOf('X'), (ItemLike)ModBlocks.POLISHED_DARKSTONE.get()).unlockedBy((RecipeSubProvider)this, (ItemLike)ModBlocks.POLISHED_DARKSTONE.get()));
        this.shaped(RecipeCategory.MISC, (ItemLike)ModItems.DARK_NETHER_STAR.get(), builder -> builder.pattern(" # ").pattern("#X#").pattern(" # ").define(Character.valueOf('#'), (ItemLike)ModItems.OBSIDIANSTEEL_INGOT.get()).define(Character.valueOf('X'), (ItemLike)Items.NETHER_STAR).unlockedBy((RecipeSubProvider)this, (ItemLike)ModItems.OBSIDIANSTEEL_INGOT.get()).unlockedBy((RecipeSubProvider)this, (ItemLike)Items.NETHER_STAR));
        this.shaped(RecipeCategory.MISC, (ItemLike)ModItems.DEORUM_INGOT.get(), builder -> builder.pattern("#*#").pattern("MXM").pattern("#*#").define(Character.valueOf('#'), (ItemLike)Items.CHARCOAL).define(Character.valueOf('X'), (ItemLike)Items.GOLD_INGOT).define(Character.valueOf('M'), (ItemLike)ModItems.MUNDABITUR_DUST.get()).define(Character.valueOf('*'), (ItemLike)ModItems.ARCANE_CRYSTAL_DUST.get()).unlockedBy((RecipeSubProvider)this, (ItemLike)Items.GOLD_INGOT).unlockedBy((RecipeSubProvider)this, (ItemLike)ModItems.ARCANE_CRYSTAL_DUST.get()).unlockedBy((RecipeSubProvider)this, (ItemLike)ModItems.MUNDABITUR_DUST.get()));
        this.shaped(RecipeCategory.DECORATIONS, (ItemLike)ModBlocks.DEORUM_CHAIN.get(), builder -> builder.pattern("#").pattern("X").pattern("#").define(Character.valueOf('#'), ModTags.Items.DEORUM_NUGGETS).define(Character.valueOf('X'), ModTags.Items.DEORUM_INGOTS).unlockedBy((RecipeSubProvider)this, RecipePart.of(ModTags.Items.DEORUM_INGOTS)).unlockedBy((RecipeSubProvider)this, RecipePart.of(ModTags.Items.DEORUM_NUGGETS)));
        for (DyeColor color : DyeColor.values()) {
            this.shaped(RecipeCategory.TOOLS, (ItemLike)ModItems.DYED_QUANTUM_CATCHERS.get((Object)color), builder -> builder.pattern(" # ").pattern("#X#").pattern(" # ").define(Character.valueOf('X'), ModItems.QUANTUM_CATCHER).define(Character.valueOf('#'), color.getTag()).unlockedBy((RecipeSubProvider)this, ModItems.QUANTUM_CATCHER).unlockedBy((RecipeSubProvider)this, RecipePart.of((Object)color.getTag())));
        }
        this.shaped(RecipeCategory.BUILDING_BLOCKS, (ItemLike)ModBlocks.EDELWOOD_LADDER.get(), 3, builder -> builder.pattern("# #").pattern("#X#").pattern("# #").define(Character.valueOf('#'), Tags.Items.RODS_WOODEN).define(Character.valueOf('X'), (ItemLike)ModBlocks.EDELWOOD_PLANKS.get()).unlockedBy((RecipeSubProvider)this, RecipePart.of((Object)Tags.Items.RODS_WOODEN)).unlockedBy((RecipeSubProvider)this, (ItemLike)ModBlocks.EDELWOOD_PLANKS.get()));
        this.shaped(RecipeCategory.MISC, (ItemLike)ModItems.EDELWOOD_BUCKET.get(), builder -> builder.pattern("# #").pattern("# #").pattern(" # ").define(Character.valueOf('#'), (ItemLike)ModBlocks.EDELWOOD_PLANKS.get()).unlockedBy("has_planks", CraftingRecipeProvider.has((ItemLike[])new ItemLike[]{(ItemLike)ModBlocks.EDELWOOD_PLANKS.get()})));
        this.shaped(RecipeCategory.MISC, (ItemLike)ModItems.BOOM_ARROW, 4, builder -> builder.pattern(" # ").pattern("#X#").pattern(" # ").define(Character.valueOf('X'), (ItemLike)Blocks.TNT).define(Character.valueOf('#'), (ItemLike)Items.ARROW).unlockedBy((RecipeSubProvider)this, (ItemLike)Blocks.TNT).unlockedBy((RecipeSubProvider)this, (ItemLike)Items.ARROW));
        this.surroundingItem(RecipeCategory.MISC, (ItemLike)ModBlocks.ARCANE_POLISHED_DARKSTONE.get(), this.item((ItemLike)ModItems.DEORUM_INGOT), this.item((ItemLike)ModBlocks.POLISHED_DARKSTONE.get()), 8);
        this.surroundingItem(RecipeCategory.MISC, (ItemLike)ModBlocks.OBSIDIAN_SKULL.getSkull(), this.item((ItemLike)Items.SKELETON_SKULL), this.item((ItemLike)ModItems.OBSIDIANSTEEL_INGOT), 1);
        this.surroundingItem(RecipeCategory.MISC, (ItemLike)ModItems.APPLY_MODIFIER_SMITHING_TEMPLATE, this.item((ItemLike)Items.NETHERITE_UPGRADE_SMITHING_TEMPLATE), this.item((ItemLike)ModBlocks.DARKSTONE.get()), 1);
        this.shapeless(RecipeCategory.MISC, (ItemLike)ModItems.TEST_TUBE, builder -> builder.requires((ItemLike)Items.GLASS_BOTTLE).requires(ModItems.RUNE).unlockedBy("has_item", CraftingRecipeProvider.has((ItemLike[])new ItemLike[]{ModItems.RUNE})));
        this.shapeless(RecipeCategory.MISC, (ItemLike)ModItems.DARK_RUNE, 2, builder -> builder.requires(ModItems.RUNE).requires(ModItems.RUNE).requires(ModItems.CORRUPTI_DUST).unlockedBy("has_rune", CraftingRecipeProvider.has((ItemLike[])new ItemLike[]{ModItems.RUNE})).unlockedBy("has_dust", CraftingRecipeProvider.has((ItemLike[])new ItemLike[]{ModItems.CORRUPTI_DUST})));
        this.shapeless(RecipeCategory.MISC, (ItemLike)ModItems.MUNDABITUR_DUST, 4, builder -> builder.requires(ModItems.ARCANE_CRYSTAL_DUST).requires((ItemLike)Items.REDSTONE).requires((ItemLike)Items.BLAZE_POWDER).requires((ItemLike)Items.BONE_MEAL).requires((ItemLike)Items.PHANTOM_MEMBRANE).requires((ItemLike)Items.GUNPOWDER).unlockedBy("has_arcane_crystal_dust", CraftingRecipeProvider.has((ItemLike[])new ItemLike[]{ModItems.ARCANE_CRYSTAL_DUST})).unlockedBy("has_redstone", CraftingRecipeProvider.has((ItemLike[])new ItemLike[]{Items.REDSTONE})).unlockedBy("has_blaze_powder", CraftingRecipeProvider.has((ItemLike[])new ItemLike[]{Items.BLAZE_POWDER})).unlockedBy("has_bone_meal", CraftingRecipeProvider.has((ItemLike[])new ItemLike[]{Items.BONE_MEAL})).unlockedBy("has_phantom_membrane", CraftingRecipeProvider.has((ItemLike[])new ItemLike[]{Items.PHANTOM_MEMBRANE})).unlockedBy("has_gunpowder", CraftingRecipeProvider.has((ItemLike[])new ItemLike[]{Items.GUNPOWDER})));
        this.shapeless(RecipeCategory.MISC, (ItemLike)ModItems.WAX, 2, builder -> builder.requires((ItemLike)Items.HONEY_BOTTLE).requires((ItemLike)Items.SLIME_BALL).unlockedBy("has_honey_bottle", CraftingRecipeProvider.has((ItemLike[])new ItemLike[]{Items.HONEY_BOTTLE})).unlockedBy("has_slime_ball", CraftingRecipeProvider.has((ItemLike[])new ItemLike[]{Items.SLIME_BALL})));
        this.shapeless(RecipeCategory.MISC, (ItemLike)ModItems.CORRUPTI_DUST, 4, builder -> builder.requires(ModItems.OBSIDIANSTEEL_INGOT).requires((ItemLike)Items.BLAZE_POWDER).requires((ItemLike)Items.NETHER_WART).requires(ModItems.ARCANE_CRYSTAL_DUST).requires(ModItems.ENDER_PEARL_FRAGMENT).unlockedBy("has_obsidiansteel_ingot", CraftingRecipeProvider.has((ItemLike[])new ItemLike[]{ModItems.OBSIDIANSTEEL_INGOT})).unlockedBy("has_blaze_powder", CraftingRecipeProvider.has((ItemLike[])new ItemLike[]{Items.BLAZE_POWDER})).unlockedBy("has_nether_wart", CraftingRecipeProvider.has((ItemLike[])new ItemLike[]{Items.NETHER_WART})).unlockedBy("has_arcane_crystal_dust", CraftingRecipeProvider.has((ItemLike[])new ItemLike[]{ModItems.ARCANE_CRYSTAL_DUST})).unlockedBy("has_ender_pearl_fragment", CraftingRecipeProvider.has((ItemLike[])new ItemLike[]{ModItems.ENDER_PEARL_FRAGMENT})));
        this.shapeless(RecipeCategory.MISC, (ItemLike)ModBlocks.OBSIDIAN_SKULL.getSkull(), builder -> builder.requires((ItemLike)ModBlocks.CRACKED_OBSIDIAN_SKULL.getSkull()).requires(ModItems.OBSIDIANSTEEL_INGOT, 2).unlockedBy("has_cracked_obsidian_skull", CraftingRecipeProvider.has((ItemLike[])new ItemLike[]{ModBlocks.CRACKED_OBSIDIAN_SKULL.getSkull()})).unlockedBy("has_obsidiansteel_ingot", CraftingRecipeProvider.has((ItemLike[])new ItemLike[]{ModItems.OBSIDIANSTEEL_INGOT})), "obsidian_skull_from_cracked_obsidian_skull");
        this.shapeless(RecipeCategory.MISC, (ItemLike)ModBlocks.CRACKED_OBSIDIAN_SKULL.getSkull(), builder -> builder.requires((ItemLike)ModBlocks.FRAGMENTED_OBSIDIAN_SKULL.getSkull()).requires(ModItems.OBSIDIANSTEEL_INGOT, 2).unlockedBy("has_fragmented_obsidian_skull", CraftingRecipeProvider.has((ItemLike[])new ItemLike[]{ModBlocks.FRAGMENTED_OBSIDIAN_SKULL.getSkull()})).unlockedBy("has_obsidiansteel_ingot", CraftingRecipeProvider.has((ItemLike[])new ItemLike[]{ModItems.OBSIDIANSTEEL_INGOT})));
        this.shapeless(RecipeCategory.MISC, (ItemLike)ModBlocks.FRAGMENTED_OBSIDIAN_SKULL.getSkull(), builder -> builder.requires((ItemLike)ModBlocks.FADING_OBSIDIAN_SKULL.getSkull()).requires(ModItems.OBSIDIANSTEEL_INGOT, 2).unlockedBy("has_fading_obsidian_skull", CraftingRecipeProvider.has((ItemLike[])new ItemLike[]{ModBlocks.FADING_OBSIDIAN_SKULL.getSkull()})).unlockedBy("has_obsidiansteel_ingot", CraftingRecipeProvider.has((ItemLike[])new ItemLike[]{ModItems.OBSIDIANSTEEL_INGOT})));
        this.shapeless(RecipeCategory.MISC, (ItemLike)ModBlocks.QUANTUM_CORE.get(), builder -> builder.requires(ModItems.RUNE).requires((ItemLike)Items.FLINT).requires(ModItems.MUNDABITUR_DUST).unlockedBy("has_rune", CraftingRecipeProvider.has((ItemLike[])new ItemLike[]{ModItems.RUNE})).unlockedBy("has_flint", CraftingRecipeProvider.has((ItemLike[])new ItemLike[]{Items.FLINT})).unlockedBy("has_mundabitur_dust", CraftingRecipeProvider.has((ItemLike[])new ItemLike[]{ModItems.MUNDABITUR_DUST})));
        this.add((RecipeBuilder)SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.ARCANE_CRYSTAL.get()}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.ARCANE_CRYSTAL_DUST.get()), (float)0.4f, (int)150).unlockedBy("has_item", CraftingRecipeProvider.has((ItemLike[])new ItemLike[]{(ItemLike)ModItems.ARCANE_CRYSTAL.get()})), "smelting/arcane_crystal_dust_from_smelting");
        this.add((RecipeBuilder)SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of(ModTags.Items.RUNIC_STONES), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.RUNE.get()), (float)1.0f, (int)200).unlockedBy("has_item", CraftingRecipeProvider.has(ModTags.Items.RUNIC_STONES)), "smelting/rune_from_smelting");
        this.add((RecipeBuilder)SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of(ModTags.Items.ARCANE_CRYSTAL_ORES), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.ARCANE_CRYSTAL.get()), (float)1.0f, (int)200).unlockedBy("has_item", CraftingRecipeProvider.has(ModTags.Items.ARCANE_CRYSTAL_ORES)), "smelting/arcane_crystal_from_smelting");
        this.add((RecipeBuilder)SimpleCookingRecipeBuilder.blasting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.ARCANE_CRYSTAL.get()}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.ARCANE_CRYSTAL_DUST.get()), (float)0.4f, (int)75).unlockedBy("has_item", CraftingRecipeProvider.has((ItemLike[])new ItemLike[]{(ItemLike)ModItems.ARCANE_CRYSTAL.get()})), "blasting/arcane_crystal_dust_from_blasting");
        this.add((RecipeBuilder)SimpleCookingRecipeBuilder.blasting((Ingredient)Ingredient.of(ModTags.Items.RUNIC_STONES), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.RUNE.get()), (float)1.0f, (int)100).unlockedBy("has_item", CraftingRecipeProvider.has(ModTags.Items.RUNIC_STONES)), "blasting/rune_from_blasting");
        this.add((RecipeBuilder)SimpleCookingRecipeBuilder.blasting((Ingredient)Ingredient.of(ModTags.Items.ARCANE_CRYSTAL_ORES), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.ARCANE_CRYSTAL.get()), (float)1.0f, (int)100).unlockedBy("has_item", CraftingRecipeProvider.has(ModTags.Items.ARCANE_CRYSTAL_ORES)), "blasting/arcane_crystal_from_blasting");
        this.addStonecutterRecipe((ItemLike)ModBlocks.TILED_POLISHED_DARKSTONE_BRICKS.get(), (ItemLike)ModBlocks.DARKSTONE.get());
        this.addStonecutterRecipe((ItemLike)ModBlocks.TILED_POLISHED_DARKSTONE_BRICKS.get(), (ItemLike)ModBlocks.POLISHED_DARKSTONE.get());
        this.addStonecutterRecipe((ItemLike)ModBlocks.TILED_POLISHED_DARKSTONE_BRICKS.get(), (ItemLike)ModBlocks.POLISHED_DARKSTONE_BRICKS.get());
        this.storageRecipe((ItemLike)ModItems.DARK_NETHER_STAR.get(), (ItemLike)ModBlocks.DARK_NETHER_STAR_BLOCK.get());
        this.storageRecipe((ItemLike)ModItems.OBSIDIANSTEEL_INGOT.get(), (ItemLike)ModBlocks.OBSIDIANSTEEL_BLOCK.get(), "obsidian_ingot", null);
        this.storageRecipe((ItemLike)ModItems.DEORUM_INGOT.get(), (ItemLike)ModBlocks.DEORUM_BLOCK.get(), "deorum_ingot", null);
        this.storageRecipe((ItemLike)ModItems.DEORUM_NUGGET.get(), (ItemLike)ModItems.DEORUM_INGOT.get(), null, "deorum_ingot");
        this.storageRecipe((ItemLike)ModItems.STELLARITE_PIECE.get(), (ItemLike)ModBlocks.STELLARITE_BLOCK.get());
        this.storageRecipe((ItemLike)ModItems.ARCANE_CRYSTAL.get(), (ItemLike)ModBlocks.ARCANE_CRYSTAL_BLOCK.get());
        this.storageRecipe((ItemLike)ModItems.CORRUPTED_ARCANE_CRYSTAL.get(), (ItemLike)ModBlocks.CORRUPTED_ARCANE_CRYSTAL_BLOCK.get());
        this.storageRecipe((ItemLike)ModItems.RUNE.get(), (ItemLike)ModBlocks.RUNE_BLOCK.get());
        this.storageRecipe((ItemLike)ModItems.DARK_RUNE.get(), (ItemLike)ModBlocks.DARK_RUNE_BLOCK.get());
        this.surroundingItem(RecipeCategory.BUILDING_BLOCKS, (ItemLike)ModBlocks.DEORUM_GLASS.get(), this.tag(ModTags.Items.DEORUM_INGOTS), RecipePart.of((Object)Blocks.GLASS), 8);
        this.glassPane((ItemLike)ModBlocks.DEORUM_GLASS_PANE.get(), this.item((ItemLike)ModBlocks.DEORUM_GLASS.get()));
        this.surroundingItem(RecipeCategory.BUILDING_BLOCKS, (ItemLike)ModBlocks.RUNIC_GLASS.get(), RecipePart.of((Object)((Item)ModItems.RUNE.get())), RecipePart.of((Object)Blocks.GLASS), 8);
        this.glassPane((ItemLike)ModBlocks.RUNIC_GLASS_PANE.get(), this.item((ItemLike)ModBlocks.RUNIC_GLASS.get()));
        this.surroundingItem(RecipeCategory.BUILDING_BLOCKS, (ItemLike)ModBlocks.DARK_RUNIC_GLASS.get(), RecipePart.of((Object)((Item)ModItems.DARK_RUNE.get())), RecipePart.of((Object)Blocks.GLASS), 8);
        this.glassPane((ItemLike)ModBlocks.DARK_RUNIC_GLASS_PANE.get(), this.item((ItemLike)ModBlocks.DARK_RUNIC_GLASS.get()));
        this.combine2x2((ItemLike)ModBlocks.SOULLESS_SANDSTONE.get(), this.item((ItemLike)ModBlocks.SOULLESS_SAND.get()));
        this.slab((ItemLike)ModBlocks.SOULLESS_SANDSTONE_SLAB.get(), this.item((ItemLike)ModBlocks.SOULLESS_SANDSTONE.get()));
        this.stairs((ItemLike)ModBlocks.SOULLESS_SANDSTONE_STAIRS.get(), this.item((ItemLike)ModBlocks.SOULLESS_SANDSTONE.get()));
        this.wall((ItemLike)ModBlocks.SOULLESS_SANDSTONE_WALL.get(), this.item((ItemLike)ModBlocks.SOULLESS_SANDSTONE.get()));
        this.combine2x2((ItemLike)ModBlocks.POLISHED_SOULLESS_SANDSTONE.get(), this.item((ItemLike)ModBlocks.SOULLESS_SANDSTONE.get()), 4);
        this.wood((ItemLike)ModBlocks.FUNGYSS_HYPHAE.get(), this.item((ItemLike)ModBlocks.FUNGYSS_STEM.get()));
        this.wood((ItemLike)ModBlocks.AURUM_WOOD.get(), this.item((ItemLike)ModBlocks.AURUM_LOG.get()));
        this.wood((ItemLike)ModBlocks.STRIPPED_AURUM_WOOD.get(), this.item((ItemLike)ModBlocks.STRIPPED_AURUM_LOG.get()));
        this.planks((ItemLike)ModBlocks.FUNGYSS_PLANKS.get(), ModTags.Items.FUNGYSS_STEMS, 4);
        this.planks((ItemLike)ModBlocks.AURUM_PLANKS.get(), ModTags.Items.MYSTERYWOOD_LOGS, 4);
        this.planks((ItemLike)ModBlocks.EDELWOOD_PLANKS.get(), ModTags.Items.EDELWOOD_LOGS, 2);
        this.surroundingItem(RecipeCategory.BUILDING_BLOCKS, (ItemLike)ModBlocks.ARCANE_EDELWOOD_PLANKS.get(), this.tag(ModTags.Items.DEORUM_INGOTS), this.item((ItemLike)ModBlocks.EDELWOOD_PLANKS.get()), 8);
        this.door((ItemLike)ModBlocks.DEORUM_DOOR.get(), this.tag(ModTags.Items.DEORUM_INGOTS));
        this.trapdoor((ItemLike)ModBlocks.DEORUM_TRAPDOOR.get(), this.tag(ModTags.Items.DEORUM_INGOTS));
        this.boat((ItemLike)ModItems.AURUM_BOAT.get(), this.item((ItemLike)ModBlocks.AURUM_PLANKS.get()));
        this.boat((ItemLike)ModItems.EDELWOOD_BOAT.get(), this.item((ItemLike)ModBlocks.EDELWOOD_PLANKS.get()));
        this.chestBoat((ItemLike)ModItems.AURUM_CHEST_BOAT.get(), (ItemLike)ModItems.AURUM_BOAT.get());
        this.chestBoat((ItemLike)ModItems.EDELWOOD_CHEST_BOAT.get(), (ItemLike)ModItems.EDELWOOD_BOAT.get());
        this.surroundingItem(RecipeCategory.BUILDING_BLOCKS, (ItemLike)ModBlocks.CLIBANO_CORE.get(), RecipePart.of((Object)Blocks.BLAST_FURNACE), RecipePart.of((Object)((Block)ModBlocks.DARKSTONE.get())), 1);
        this.lantern((ItemLike)ModBlocks.DEORUM_LANTERN.get(), (ItemLike)Blocks.TORCH, RecipePart.of(ModTags.Items.DEORUM_NUGGETS));
        this.lantern((ItemLike)ModBlocks.DEORUM_SOUL_LANTERN.get(), (ItemLike)Blocks.SOUL_TORCH, RecipePart.of(ModTags.Items.DEORUM_NUGGETS));
        this.shapeless(RecipeCategory.MISC, (ItemLike)ModItems.GOLDEN_ORCHID_SEEDS.get(), builder -> builder.requires((ItemLike)ModBlocks.YELLOW_ORCHID.get()).requires(ModTags.Items.DEORUM_INGOTS).unlockedBy("has_yellow_orchid", CraftingRecipeProvider.has((ItemLike[])new ItemLike[]{(ItemLike)ModBlocks.YELLOW_ORCHID.get()})).unlockedBy("has_deorum_ingot", CraftingRecipeProvider.has(ModTags.Items.DEORUM_INGOTS)));
        this.shaped(RecipeCategory.MISC, (ItemLike)ModItems.BLACKSMITH_GAVEL_HEAD.get(), builder -> builder.pattern("###").pattern("# #").pattern(" # ").define(Character.valueOf('#'), (ItemLike)Items.CLAY_BALL).unlockedBy((RecipeSubProvider)this, (ItemLike)Items.CLAY_BALL));
        this.blacksmithGavel((ItemLike)ModItems.WOODEN_BLACKSMITH_GAVEL.get(), (TagKey<Item>)ItemTags.PLANKS);
        this.blacksmithGavel((ItemLike)ModItems.STONE_BLACKSMITH_GAVEL.get(), (TagKey<Item>)ItemTags.STONE_TOOL_MATERIALS);
        this.blacksmithGavel((ItemLike)ModItems.GOLDEN_BLACKSMITH_GAVEL.get(), (TagKey<Item>)Tags.Items.INGOTS_GOLD);
        this.blacksmithGavel((ItemLike)ModItems.IRON_BLACKSMITH_GAVEL.get(), (TagKey<Item>)Tags.Items.INGOTS_IRON);
        this.blacksmithGavel((ItemLike)ModItems.DIAMOND_BLACKSMITH_GAVEL.get(), (TagKey<Item>)Tags.Items.GEMS_DIAMOND);
    }

    public void slab(ItemLike result, RecipePart<?> material) {
        this.shaped(RecipeCategory.BUILDING_BLOCKS, result, 6, builder -> builder.pattern("###").define(Character.valueOf('#'), material).unlockedBy((RecipeSubProvider)this, material));
    }

    public void stairs(ItemLike result, RecipePart<?> material) {
        this.shaped(RecipeCategory.BUILDING_BLOCKS, result, 4, builder -> builder.pattern("#  ").pattern("## ").pattern("###").define(Character.valueOf('#'), material).unlockedBy((RecipeSubProvider)this, material));
    }

    public void wall(ItemLike result, RecipePart<?> material) {
        this.shaped(RecipeCategory.BUILDING_BLOCKS, result, 6, builder -> builder.pattern("###").pattern("###").define(Character.valueOf('#'), material).unlockedBy((RecipeSubProvider)this, material));
    }

    public void combine2x2(ItemLike result, RecipePart<?> material) {
        this.combine2x2(result, material, 1);
    }

    public void combine2x2(ItemLike result, RecipePart<?> material, int count) {
        this.shaped(RecipeCategory.BUILDING_BLOCKS, result, count, builder -> builder.pattern("##").pattern("##").define(Character.valueOf('#'), material).unlockedBy((RecipeSubProvider)this, material));
    }

    private void lantern(ItemLike result, ItemLike torch, RecipePart<?> material) {
        this.shaped(RecipeCategory.DECORATIONS, result, builder -> builder.pattern("XXX").pattern("X#X").pattern("XXX").define(Character.valueOf('X'), material).define(Character.valueOf('#'), torch).unlockedBy((RecipeSubProvider)this, material).unlockedBy((RecipeSubProvider)this, torch));
    }

    private void blacksmithGavel(ItemLike gavel, TagKey<Item> material) {
        this.shaped(RecipeCategory.TOOLS, gavel, builder -> builder.pattern("#X#").pattern("#S#").pattern(" S ").define(Character.valueOf('#'), material).define(Character.valueOf('X'), (ItemLike)ModItems.BLACKSMITH_GAVEL_HEAD.get()).define(Character.valueOf('S'), Tags.Items.RODS_WOODEN).unlockedBy((RecipeSubProvider)this, RecipePart.of((Object)material)));
    }

    private void addStonecutterRecipe(ItemLike result, ItemLike material) {
        this.addStonecutterRecipe(result, material, 1);
    }

    private void addStonecutterRecipe(ItemLike result, ItemLike material, int count) {
        this.add((RecipeBuilder)SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{material}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)result, (int)count).unlockedBy("has_" + CraftingRecipeProvider.getName((ItemLike)material), CraftingRecipeProvider.has((ItemLike[])new ItemLike[]{material})), CraftingRecipeProvider.getName((ItemLike)result) + "_from_" + CraftingRecipeProvider.getName((ItemLike)material) + "_stonecutting");
    }
}

