/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.data.server.loot;

import com.stal111.forbidden_arcanus.ForbiddenArcanus;
import com.stal111.forbidden_arcanus.core.init.ModDataComponents;
import com.stal111.forbidden_arcanus.core.init.ModItems;
import com.stal111.forbidden_arcanus.core.registry.FARegistries;
import com.stal111.forbidden_arcanus.data.enhancer.ModEnhancerDefinitions;
import java.util.function.BiConsumer;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.loot.LootTableSubProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetComponentsFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import org.jetbrains.annotations.NotNull;

public class ModChestLoot
implements LootTableSubProvider {
    public static final ResourceKey<LootTable> ARTISAN_RELIC_ADDITION = ModChestLoot.register("chests/additions/artisan_relic_addition");
    public static final ResourceKey<LootTable> CRIMSON_STONE_ADDITION = ModChestLoot.register("chests/additions/crimson_stone_addition");
    public static final ResourceKey<LootTable> ELEMENTARIUM_ADDITION = ModChestLoot.register("chests/additions/elementarium_addition");
    public static final ResourceKey<LootTable> MALEDICTUS_PACT_ADDITION = ModChestLoot.register("chests/additions/maledictus_pact_addition");
    private final HolderLookup.Provider lookupProvider;

    public ModChestLoot(HolderLookup.Provider lookupProvider) {
        this.lookupProvider = lookupProvider;
    }

    public void generate(@NotNull BiConsumer<ResourceKey<LootTable>, LootTable.Builder> consumer) {
        HolderLookup.RegistryLookup lookup = (HolderLookup.RegistryLookup)this.lookupProvider.lookup(FARegistries.ENHANCER_DEFINITION).orElseThrow();
        consumer.accept(ARTISAN_RELIC_ADDITION, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(ModItems.ARTISAN_RELIC).apply((LootItemFunction.Builder)SetComponentsFunction.setComponent((DataComponentType)((DataComponentType)ModDataComponents.ENHANCER.get()), (Object)((Holder)lookup.get(ModEnhancerDefinitions.ARTISAN_RELIC).orElseThrow())))).when(LootItemRandomChanceCondition.randomChance((float)0.18f))));
        consumer.accept(CRIMSON_STONE_ADDITION, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(ModItems.CRIMSON_STONE).apply((LootItemFunction.Builder)SetComponentsFunction.setComponent((DataComponentType)((DataComponentType)ModDataComponents.ENHANCER.get()), (Object)((Holder)lookup.get(ModEnhancerDefinitions.CRIMSON_STONE).orElseThrow())))).when(LootItemRandomChanceCondition.randomChance((float)0.18f))));
        consumer.accept(ELEMENTARIUM_ADDITION, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(ModItems.ELEMENTARIUM).apply((LootItemFunction.Builder)SetComponentsFunction.setComponent((DataComponentType)((DataComponentType)ModDataComponents.ENHANCER.get()), (Object)((Holder)lookup.get(ModEnhancerDefinitions.ELEMENTARIUM).orElseThrow())))).when(LootItemRandomChanceCondition.randomChance((float)0.21f))));
        consumer.accept(MALEDICTUS_PACT_ADDITION, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(ModItems.MALEDICTUS_PACT).apply((LootItemFunction.Builder)SetComponentsFunction.setComponent((DataComponentType)((DataComponentType)ModDataComponents.ENHANCER.get()), (Object)((Holder)lookup.get(ModEnhancerDefinitions.MALEDICTUS_PACT).orElseThrow())))).when(LootItemRandomChanceCondition.randomChance((float)0.18f))));
    }

    private static ResourceKey<LootTable> register(String name) {
        return ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ForbiddenArcanus.location(name));
    }
}

