/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.animatable;

import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.GeckoLibServices;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.constant.dataticket.SerializableDataTicket;

public interface GeoEntity
extends GeoAnimatable {
    @ApiStatus.NonExtendable
    @Nullable
    default public <D> D getAnimData(SerializableDataTicket<D> dataTicket) {
        return this.getAnimatableInstanceCache().getManagerForId(((Entity)this).getId()).getData(dataTicket);
    }

    @ApiStatus.NonExtendable
    default public <D> void setAnimData(SerializableDataTicket<D> dataTicket, D data) {
        Entity entity = (Entity)this;
        if (entity.level().isClientSide()) {
            this.getAnimatableInstanceCache().getManagerForId(entity.getId()).setData(dataTicket, data);
        } else {
            GeckoLibServices.NETWORK.syncEntityAnimData(entity, false, dataTicket, data);
        }
    }

    @ApiStatus.NonExtendable
    default public void triggerAnim(@Nullable String controllerName, String animName) {
        Entity entity = (Entity)this;
        if (entity.level().isClientSide()) {
            this.getAnimatableInstanceCache().getManagerForId(entity.getId()).tryTriggerAnimation(controllerName, animName);
        } else {
            GeckoLibServices.NETWORK.triggerEntityAnim(entity, false, controllerName, animName);
        }
    }

    @Override
    default public double getTick(Object entity) {
        return ((Entity)entity).tickCount;
    }
}

