/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.model;

import java.util.Optional;
import java.util.function.BiConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.GeckoLibConstants;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoReplacedEntity;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationProcessor;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.cache.GeckoLibCache;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.constant.dataticket.DataTicket;
import software.bernie.geckolib.loading.math.MathParser;
import software.bernie.geckolib.loading.object.BakedAnimations;
import software.bernie.geckolib.util.RenderUtil;

public abstract class GeoModel<T extends GeoAnimatable> {
    private final AnimationProcessor<T> processor = new AnimationProcessor(this);
    private BakedGeoModel currentModel = null;
    private double animTime;
    private double lastGameTickTime;
    private long lastRenderedInstance = -1L;

    public abstract ResourceLocation getModelResource(T var1);

    public abstract ResourceLocation getTextureResource(T var1);

    public abstract ResourceLocation getAnimationResource(T var1);

    public boolean crashIfBoneMissing() {
        return false;
    }

    @Nullable
    public RenderType getRenderType(T animatable, ResourceLocation texture) {
        return RenderType.entityCutoutNoCull((ResourceLocation)texture);
    }

    public BakedGeoModel getBakedModel(ResourceLocation location) {
        BakedGeoModel model = GeckoLibCache.getBakedModels().get(location);
        if (model == null) {
            if (!location.getPath().contains("geo/")) {
                throw GeckoLibConstants.exception(location, "Invalid model resource path provided - GeckoLib models must be placed in assets/<modid>/geo/");
            }
            throw GeckoLibConstants.exception(location, "Unable to find model");
        }
        if (model != this.currentModel) {
            this.processor.setActiveModel(model);
            this.currentModel = model;
        }
        return this.currentModel;
    }

    public Optional<GeoBone> getBone(String name) {
        return Optional.ofNullable(this.getAnimationProcessor().getBone(name));
    }

    public Animation getAnimation(T animatable, String name) {
        ResourceLocation location = this.getAnimationResource(animatable);
        BakedAnimations bakedAnimations = GeckoLibCache.getBakedAnimations().get(location);
        if (bakedAnimations == null) {
            if (!location.getPath().contains("animations/")) {
                throw GeckoLibConstants.exception(location, "Invalid animation resource path provided - GeckoLib animations must be placed in assets/<modid>/animations/");
            }
            throw GeckoLibConstants.exception(location, "Unable to find animation file.");
        }
        return bakedAnimations.getAnimation(name);
    }

    public AnimationProcessor<T> getAnimationProcessor() {
        return this.processor;
    }

    public void addAdditionalStateData(T animatable, long instanceId, BiConsumer<DataTicket<T>, T> dataConsumer) {
    }

    @ApiStatus.Internal
    public void handleAnimations(T animatable, long instanceId, AnimationState<T> animationState, float partialTick) {
        boolean isReRender;
        Minecraft mc = Minecraft.getInstance();
        AnimatableManager animatableManager = animatable.getAnimatableInstanceCache().getManagerForId(instanceId);
        Double currentTick = animationState.getData(DataTickets.TICK);
        if (currentTick == null) {
            double d;
            if (animatable instanceof Entity) {
                Entity entity = (Entity)animatable;
                d = entity.tickCount;
            } else {
                d = RenderUtil.getCurrentTick();
            }
            currentTick = d;
        }
        if (animatableManager.getFirstTickTime() == -1.0) {
            animatableManager.startedAt(currentTick + (double)partialTick);
        }
        double currentFrameTime = animatable instanceof Entity || animatable instanceof GeoReplacedEntity ? currentTick + (double)partialTick : currentTick - animatableManager.getFirstTickTime();
        boolean bl = isReRender = !animatableManager.isFirstTick() && currentFrameTime == animatableManager.getLastUpdateTime();
        if (isReRender && instanceId == this.lastRenderedInstance) {
            return;
        }
        if (!mc.isPaused() || animatable.shouldPlayAnimsWhileGamePaused()) {
            animatableManager.updatedAt(currentFrameTime);
            double lastUpdateTime = animatableManager.getLastUpdateTime();
            this.animTime += lastUpdateTime - this.lastGameTickTime;
            this.lastGameTickTime = lastUpdateTime;
        }
        animationState.animationTick = this.animTime;
        this.lastRenderedInstance = instanceId;
        AnimationProcessor<T> processor = this.getAnimationProcessor();
        processor.preAnimationSetup(animationState, this.animTime);
        if (!processor.getRegisteredBones().isEmpty()) {
            processor.tickAnimation(animatable, this, animatableManager, this.animTime, animationState, this.crashIfBoneMissing());
        }
        this.setCustomAnimations(animatable, instanceId, animationState);
    }

    public void setCustomAnimations(T animatable, long instanceId, AnimationState<T> animationState) {
    }

    public void applyMolangQueries(AnimationState<T> animationState, double animTime) {
        Minecraft mc = Minecraft.getInstance();
        T animatable = animationState.getAnimatable();
        MathParser.setVariable("query.life_time", () -> animTime / 20.0);
        MathParser.setVariable("query.actor_count", () -> ((ClientLevel)mc.level).getEntityCount());
        MathParser.setVariable("query.time_of_day", () -> (float)mc.level.getDayTime() / 24000.0f);
        MathParser.setVariable("query.moon_phase", () -> ((ClientLevel)mc.level).getMoonPhase());
        if (animatable instanceof Entity) {
            Entity entity = (Entity)animatable;
            MathParser.setVariable("query.distance_from_camera", () -> mc.gameRenderer.getMainCamera().getPosition().distanceTo(entity.position()));
            MathParser.setVariable("query.is_on_ground", () -> RenderUtil.booleanToFloat(entity.onGround()));
            MathParser.setVariable("query.is_in_water", () -> RenderUtil.booleanToFloat(entity.isInWater()));
            MathParser.setVariable("query.is_in_water_or_rain", () -> RenderUtil.booleanToFloat(entity.isInWaterRainOrBubble()));
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                MathParser.setVariable("query.health", () -> ((LivingEntity)livingEntity).getHealth());
                MathParser.setVariable("query.max_health", () -> ((LivingEntity)livingEntity).getMaxHealth());
                MathParser.setVariable("query.is_on_fire", () -> RenderUtil.booleanToFloat(livingEntity.isOnFire()));
                MathParser.setVariable("query.ground_speed", () -> {
                    Vec3 velocity = livingEntity.getDeltaMovement();
                    return Mth.sqrt((float)((float)(velocity.x * velocity.x + velocity.z * velocity.z)));
                });
                MathParser.setVariable("query.yaw_speed", () -> livingEntity.getViewYRot((float)animTime - livingEntity.getViewYRot((float)animTime - 0.1f)));
            }
        }
    }
}

