/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.block;

import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluids;

public class ModLiquidBlock
extends LiquidBlock {
    private static Field FORGE_BLOCK_SUPPLIER;
    private static Field INIT;

    public ModLiquidBlock(Supplier<? extends FlowingFluid> supplier, BlockBehaviour.Properties arg) {
        super(PlatHelper.getPlatform().isFabric() ? supplier.get() : Fluids.WATER, arg);
        if (PlatHelper.getPlatform().isForge()) {
            if (FORGE_BLOCK_SUPPLIER == null) {
                FORGE_BLOCK_SUPPLIER = PlatHelper.findField(LiquidBlock.class, "supplier");
            }
            if (INIT == null) {
                INIT = PlatHelper.findField(LiquidBlock.class, "fluidStateCacheInitialized");
            }
            try {
                for (Field f : LiquidBlock.class.getDeclaredFields()) {
                    if (f.getType() == FlowingFluid.class) {
                        f.setAccessible(true);
                        f.set((Object)this, null);
                        continue;
                    }
                    if (f.getType() != ArrayList.class) continue;
                    f.setAccessible(true);
                    f.set((Object)this, Lists.newArrayList());
                }
                INIT.setAccessible(true);
                INIT.set((Object)this, false);
                this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)LEVEL, (Comparable)Integer.valueOf(0)));
                FORGE_BLOCK_SUPPLIER.setAccessible(true);
                FORGE_BLOCK_SUPPLIER.set((Object)this, supplier);
                INIT.set((Object)this, false);
            }
            catch (Exception e) {
                Moonlight.LOGGER.error("Failed to setup ModLiquidBlock class : " + String.valueOf(e));
                throw new RuntimeException(e);
            }
        }
    }
}

