/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.client.util;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.function.BiConsumer;
import net.mehvahdjukaar.moonlight.api.client.util.neoforge.RenderUtilImpl;
import net.mehvahdjukaar.moonlight.api.platform.ClientHelper;
import net.mehvahdjukaar.moonlight.core.MoonlightClient;
import net.mehvahdjukaar.moonlight.core.client.MLRenderTypes;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.joml.Matrix4f;

public class RenderUtil {
    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void renderBlock(BakedModel model, long seed, PoseStack poseStack, MultiBufferSource buffer, BlockState state, Level level, BlockPos pos, BlockRenderDispatcher dispatcher) {
        void var8_7;
        void var7_6;
        void var6_5;
        void var5_4;
        void var4_3;
        void var3_2;
        void var1_1;
        RenderUtilImpl.renderBlock(model, (long)var1_1, (PoseStack)var3_2, (MultiBufferSource)var4_3, (BlockState)var5_4, (Level)var6_5, (BlockPos)var7_6, (BlockRenderDispatcher)var8_7);
    }

    public static void renderBlock(long seed, PoseStack poseStack, MultiBufferSource buffer, BlockState state, Level level, BlockPos pos, BlockRenderDispatcher dispatcher) {
        BakedModel model = dispatcher.getBlockModel(state);
        RenderUtil.renderBlock(model, seed, poseStack, buffer, state, level, pos, dispatcher);
    }

    public static void renderModel(ModelResourceLocation modelLocation, PoseStack matrixStack, MultiBufferSource buffer, BlockRenderDispatcher blockRenderer, int light, int overlay, boolean cutout) {
        blockRenderer.getModelRenderer().renderModel(matrixStack.last(), buffer.getBuffer(cutout ? Sheets.cutoutBlockSheet() : Sheets.solidBlockSheet()), null, ClientHelper.getModel(blockRenderer.getBlockModelShaper().getModelManager(), modelLocation), 1.0f, 1.0f, 1.0f, light, overlay);
    }

    public static void renderGuiItemRelative(PoseStack poseStack, ItemStack stack, int x, int y, ItemRenderer renderer, BiConsumer<PoseStack, BakedModel> movement) {
        RenderUtil.renderGuiItemRelative(poseStack, stack, x, y, renderer, movement, 0xF000F0, OverlayTexture.NO_OVERLAY);
    }

    public static void renderGuiItemRelative(PoseStack poseStack, ItemStack stack, int x, int y, ItemRenderer renderer, BiConsumer<PoseStack, BakedModel> movement, int combinedLight, int pCombinedOverlay) {
        boolean flag;
        BakedModel model = renderer.getModel(stack, null, null, 0);
        int l = 0;
        poseStack.pushPose();
        poseStack.translate((float)(x + 8), (float)(y + 8), (float)(150 + (model.isGui3d() ? l : 0)));
        poseStack.mulPose(new Matrix4f().scaling(1.0f, -1.0f, 1.0f));
        poseStack.scale(16.0f, 16.0f, 16.0f);
        MultiBufferSource.BufferSource bufferSource = Minecraft.getInstance().renderBuffers().bufferSource();
        boolean bl = flag = !model.usesBlockLight();
        if (flag) {
            Lighting.setupForFlatItems();
        } else {
            Lighting.setupFor3DItems();
        }
        ItemDisplayContext pTransformType = ItemDisplayContext.GUI;
        model = RenderUtil.handleCameraTransforms(model, poseStack, pTransformType);
        movement.accept(poseStack, model);
        renderer.render(stack, ItemDisplayContext.NONE, false, poseStack, (MultiBufferSource)bufferSource, combinedLight, pCombinedOverlay, model);
        bufferSource.endBatch();
        RenderSystem.enableDepthTest();
        if (flag) {
            Lighting.setupFor3DItems();
        }
        poseStack.popPose();
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static BakedModel handleCameraTransforms(BakedModel model, PoseStack matrixStack, ItemDisplayContext pTransformType) {
        void var2_2;
        void var1_1;
        return RenderUtilImpl.handleCameraTransforms(model, (PoseStack)var1_1, (ItemDisplayContext)var2_2);
    }

    public static GuiGraphics getGuiDummy(PoseStack poseStack) {
        Minecraft mc = Minecraft.getInstance();
        return new GuiGraphics(mc, poseStack, mc.renderBuffers().bufferSource());
    }

    public static void blitSpriteSection(GuiGraphics graphics, int x, int y, int w, int h, float u, float v, int uW, int vH, TextureAtlasSprite sprite) {
        SpriteContents c = sprite.contents();
        int width = (int)((float)c.width() / (sprite.getU1() - sprite.getU0()));
        int height = (int)((float)c.height() / (sprite.getV1() - sprite.getV0()));
        graphics.blit(sprite.atlasLocation(), x, y, w, h, sprite.getU(u) * (float)width, (float)height * sprite.getV(v), uW, vH, width, height);
    }

    public static void renderSprite(PoseStack stack, VertexConsumer vertexBuilder, int light, int index, int b, int g, int r, TextureAtlasSprite sprite) {
        RenderUtil.renderSprite(stack, vertexBuilder, light, index, b, g, r, 255, sprite);
    }

    public static void renderSprite(PoseStack stack, VertexConsumer vertexBuilder, int light, int index, int b, int g, int r, int a, TextureAtlasSprite sprite) {
        Matrix4f matrix4f1 = stack.last().pose();
        float u0 = sprite.getU(0.0f);
        float u1 = sprite.getU(16.0f);
        float h = (u0 + u1) / 2.0f;
        float v0 = sprite.getV(0.0f);
        float v1 = sprite.getV(16.0f);
        float k = (v0 + v1) / 2.0f;
        float shrink = sprite.uvShrinkRatio();
        float u0s = Mth.lerp((float)shrink, (float)u0, (float)h);
        float u1s = Mth.lerp((float)shrink, (float)u1, (float)h);
        float v0s = Mth.lerp((float)shrink, (float)v0, (float)k);
        float v1s = Mth.lerp((float)shrink, (float)v1, (float)k);
        vertexBuilder.addVertex(matrix4f1, -1.0f, 1.0f, (float)index * -0.001f).setColor(r, g, b, a).setUv(u0s, v1s).setLight(light);
        vertexBuilder.addVertex(matrix4f1, 1.0f, 1.0f, (float)index * -0.001f).setColor(r, g, b, a).setUv(u1s, v1s).setLight(light);
        vertexBuilder.addVertex(matrix4f1, 1.0f, -1.0f, (float)index * -0.001f).setColor(r, g, b, a).setUv(u1s, v0s).setLight(light);
        vertexBuilder.addVertex(matrix4f1, -1.0f, -1.0f, (float)index * -0.001f).setColor(r, g, b, a).setUv(u0s, v0s).setLight(light);
    }

    public static RenderType getTextMipmapRenderType(ResourceLocation texture) {
        return MLRenderTypes.TEXT_MIP.apply(texture);
    }

    public static RenderType getEntityCutoutMipmapRenderType(ResourceLocation texture) {
        return MLRenderTypes.ENTITY_CUTOUT_MIP.apply(texture);
    }

    public static RenderType getEntitySolidMipmapRenderType(ResourceLocation texture) {
        return MLRenderTypes.ENTITY_SOLID_MIP.apply(texture);
    }

    public static RenderType getTextColorRenderType(ResourceLocation texture) {
        return MLRenderTypes.COLOR_TEXT.apply(texture);
    }

    public static void setDynamicTexturesToUseMipmap(boolean mipMap) {
        MoonlightClient.setMipMap(mipMap);
    }
}

