/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.map;

import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.map.CustomMapData;
import net.mehvahdjukaar.moonlight.api.map.decoration.MLMapDecorationType;
import net.mehvahdjukaar.moonlight.api.map.decoration.MLMapMarker;
import net.mehvahdjukaar.moonlight.api.map.decoration.MLSpecialMapDecorationType;
import net.mehvahdjukaar.moonlight.api.misc.TriFunction;
import net.mehvahdjukaar.moonlight.core.map.MapDataInternal;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import org.jetbrains.annotations.Nullable;

public class MapDataRegistry {
    public static final ResourceKey<Registry<MLMapDecorationType<?, ?>>> REGISTRY_KEY = MapDataInternal.KEY;

    public static <T extends CustomMapData<?>> CustomMapData.Type<T> registerCustomMapSavedData(CustomMapData.Type<T> type) {
        return MapDataInternal.registerCustomMapSavedData(type);
    }

    public static <T extends CustomMapData<?>> CustomMapData.Type<T> registerCustomMapSavedData(ResourceLocation id, Supplier<T> factory) {
        return MapDataRegistry.registerCustomMapSavedData(new CustomMapData.Type<T>(id, factory));
    }

    public static MLMapDecorationType<?, ?> getDefaultType() {
        return MapDataInternal.getGenericStructure();
    }

    public static void registerCustomType(ResourceLocation factoryId, Supplier<MLSpecialMapDecorationType<?, ?>> decorationTypeFactory) {
        MapDataInternal.registerCustomType(factoryId, decorationTypeFactory);
    }

    public static void addDynamicClientMarkersEvent(BiFunction<MapId, MapItemSavedData, Set<MLMapMarker<?>>> event) {
        MapDataInternal.addDynamicClientMarkersEvent(event);
    }

    public static void addDynamicServerMarkersEvent(TriFunction<Player, MapId, MapItemSavedData, Set<MLMapMarker<?>>> event) {
        MapDataInternal.addDynamicServerMarkersEvent(event);
    }

    public static MLSpecialMapDecorationType<?, ?> getCustomType(ResourceLocation resourceLocation) {
        return MapDataInternal.createCustomType(resourceLocation);
    }

    public static MLMapDecorationType<?, ?> getAssociatedType(Holder<Structure> structure) {
        return MapDataInternal.getAssociatedType(structure);
    }

    public static Registry<MLMapDecorationType<?, ?>> getRegistry(RegistryAccess registryAccess) {
        return MapDataInternal.getRegistry(registryAccess);
    }

    public static MLMapDecorationType<?, ?> getOrDefault(ResourceLocation id) {
        return MapDataInternal.getOrDefault(id);
    }

    public static Optional<MLMapDecorationType<?, ?>> getOptional(ResourceLocation id) {
        return MapDataInternal.getOptional(id);
    }

    @Nullable
    public static Holder<MLMapDecorationType<?, ?>> getHolder(ResourceLocation id) {
        return MapDataInternal.getHolder(id);
    }
}

