/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.map.decoration;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.map.MapDataRegistry;
import net.mehvahdjukaar.moonlight.api.map.decoration.MLJsonMapDecorationType;
import net.mehvahdjukaar.moonlight.api.map.decoration.MLMapDecoration;
import net.mehvahdjukaar.moonlight.api.map.decoration.MLMapMarker;
import net.mehvahdjukaar.moonlight.api.map.decoration.MLSpecialMapDecorationType;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.levelgen.structure.Structure;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public abstract sealed class MLMapDecorationType<D extends MLMapDecoration, M extends MLMapMarker<D>>
permits MLJsonMapDecorationType, MLSpecialMapDecorationType {
    public static final Codec<MLMapDecorationType<?, ?>> DIRECT_CODEC = Codec.lazyInitialized(() -> Codec.either(MLSpecialMapDecorationType.CODEC, MLJsonMapDecorationType.CODEC).xmap(either -> (MLMapDecorationType)either.map(s -> s, c -> c), type -> {
        if (type == null) {
            Moonlight.LOGGER.error("map decoration type cant be null. how did this happen?");
        }
        if (type instanceof MLSpecialMapDecorationType) {
            MLSpecialMapDecorationType c = (MLSpecialMapDecorationType)type;
            return Either.left((Object)c);
        }
        return Either.right((Object)((MLJsonMapDecorationType)type));
    }));
    public static final Codec<MLMapDecorationType<?, ?>> DIRECT_NETWORK_CODEC = Codec.lazyInitialized(() -> Codec.either(MLSpecialMapDecorationType.CODEC, MLJsonMapDecorationType.CODEC).xmap(either -> (MLMapDecorationType)either.map(s -> s, c -> c), type -> {
        if (type == null) {
            Moonlight.LOGGER.error("map decoration type cant be null. how did this happen?");
        }
        if (type instanceof MLSpecialMapDecorationType) {
            MLSpecialMapDecorationType c = (MLSpecialMapDecorationType)type;
            return Either.left((Object)c);
        }
        return Either.right((Object)((MLJsonMapDecorationType)type));
    }));
    public static final Codec<Holder<MLMapDecorationType<?, ?>>> CODEC = RegistryFileCodec.create(MapDataRegistry.REGISTRY_KEY, DIRECT_CODEC);
    public static final StreamCodec<RegistryFriendlyByteBuf, Holder<MLMapDecorationType<?, ?>>> STREAM_CODEC = ByteBufCodecs.holderRegistry(MapDataRegistry.REGISTRY_KEY);
    private final StreamCodec<RegistryFriendlyByteBuf, D> decorationCodec;
    private final MapCodec<M> markerCodec;

    protected MLMapDecorationType(MapCodec<M> markerCodec, StreamCodec<RegistryFriendlyByteBuf, D> decorationCodec) {
        this.decorationCodec = decorationCodec;
        this.markerCodec = markerCodec;
    }

    @ApiStatus.Internal
    abstract boolean isFromWorld();

    public ResourceLocation getCustomFactoryID() {
        return ResourceLocation.parse((String)"");
    }

    @Nullable
    public abstract M createMarkerFromWorld(BlockGetter var1, BlockPos var2);

    public int getDefaultMapColor() {
        return 1;
    }

    public Optional<HolderSet<Structure>> getAssociatedStructure() {
        return Optional.empty();
    }

    public StreamCodec<? super RegistryFriendlyByteBuf, D> getDecorationCodec() {
        return this.decorationCodec;
    }

    public MapCodec<M> getMarkerCodec() {
        return this.markerCodec;
    }
}

