/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.misc;

import java.util.Map;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.misc.WeakHashSet;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataObjectReference<T>
implements Supplier<T> {
    private static final WeakHashSet<DataObjectReference<?>> REFERENCES = new WeakHashSet();
    private final ResourceKey<Registry<T>> registryKey;
    private final ResourceKey<T> key;
    @Nullable
    private Holder<T> cache;

    public DataObjectReference(String id, ResourceKey<Registry<T>> registry) {
        this(ResourceLocation.parse((String)id), registry);
    }

    public DataObjectReference(ResourceLocation location, ResourceKey<Registry<T>> registry) {
        this.registryKey = registry;
        this.key = ResourceKey.create(this.registryKey, (ResourceLocation)location);
        REFERENCES.add(this);
    }

    public DataObjectReference(ResourceKey<T> key) {
        this.key = key;
        this.registryKey = ResourceKey.createRegistryKey((ResourceLocation)key.registry());
        REFERENCES.add(this);
    }

    public Holder<T> getHolder() {
        if (this.cache == null) {
            RegistryAccess r = Utils.hackyGetRegistryAccess();
            Registry reg = r.registryOrThrow(this.registryKey);
            try {
                this.cache = reg.getHolderOrThrow(this.key);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to get object from registry: " + String.valueOf(this.key) + ".\nCalled from " + String.valueOf(Thread.currentThread()) + ".\nRegistry content was: " + String.valueOf(reg.entrySet().stream().map(Map.Entry::getValue).toList()), e);
            }
        }
        return this.cache;
    }

    @Override
    @NotNull
    public T get() {
        return (T)this.getHolder().value();
    }

    public void clearCache() {
        this.cache = null;
    }

    public ResourceLocation getID() {
        return this.key.location();
    }

    @ApiStatus.Internal
    public static void onDataReload() {
        REFERENCES.forEach(DataObjectReference::clearCache);
    }
}

