/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.set.wood;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.mehvahdjukaar.moonlight.api.events.AfterLanguageLoadEvent;
import net.mehvahdjukaar.moonlight.api.set.BlockTypeRegistry;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class WoodTypeRegistry
extends BlockTypeRegistry<WoodType> {
    public static final WoodType OAK_TYPE = new WoodType(ResourceLocation.parse((String)"oak"), Blocks.OAK_PLANKS, Blocks.OAK_LOG);
    public static final WoodTypeRegistry INSTANCE = new WoodTypeRegistry();
    private final Map<net.minecraft.world.level.block.state.properties.WoodType, WoodType> fromVanilla = new IdentityHashMap<net.minecraft.world.level.block.state.properties.WoodType, WoodType>();
    public static Set<String> IGNORED_MODS = new HashSet<String>(Set.of("chipped", "securitycraft", "absentbydesign", "immersive_weathering"));
    private static final List<net.minecraft.world.level.block.state.properties.WoodType> VANILLA_ORDER = List.of(net.minecraft.world.level.block.state.properties.WoodType.OAK, net.minecraft.world.level.block.state.properties.WoodType.SPRUCE, net.minecraft.world.level.block.state.properties.WoodType.BIRCH, net.minecraft.world.level.block.state.properties.WoodType.JUNGLE, net.minecraft.world.level.block.state.properties.WoodType.ACACIA, net.minecraft.world.level.block.state.properties.WoodType.DARK_OAK, net.minecraft.world.level.block.state.properties.WoodType.MANGROVE, net.minecraft.world.level.block.state.properties.WoodType.CHERRY, net.minecraft.world.level.block.state.properties.WoodType.BAMBOO, net.minecraft.world.level.block.state.properties.WoodType.CRIMSON, net.minecraft.world.level.block.state.properties.WoodType.WARPED);

    public static Collection<WoodType> getTypes() {
        return INSTANCE.getValues();
    }

    @Nullable
    public static WoodType getValue(ResourceLocation name) {
        return (WoodType)INSTANCE.get(name);
    }

    public static WoodType fromNBT(String name) {
        return (WoodType)INSTANCE.getFromNBT(name);
    }

    public static WoodType fromVanilla(net.minecraft.world.level.block.state.properties.WoodType vanillaType) {
        return INSTANCE.getFromVanilla(vanillaType);
    }

    public WoodTypeRegistry() {
        super(WoodType.class, "wood_type");
        this.addFinder(() -> {
            WoodType b = new WoodType(ResourceLocation.parse((String)"bamboo"), Blocks.BAMBOO_PLANKS, Blocks.BAMBOO_BLOCK);
            b.addChild("stripped_log", Blocks.STRIPPED_BAMBOO_BLOCK);
            return Optional.of(b);
        });
    }

    @Override
    public WoodType getDefaultType() {
        return OAK_TYPE;
    }

    @Override
    public Optional<WoodType> detectTypeFromBlock(Block baseBlock, ResourceLocation baseRes) {
        ResourceLocation id;
        Block logBlock;
        BlockState state;
        String name = null;
        String path = baseRes.getPath();
        if (baseRes.getNamespace().equals("tfc") || baseRes.getNamespace().equals("afc")) {
            Optional log;
            if (path.contains("wood/planks/") && (log = BuiltInRegistries.BLOCK.getOptional(baseRes.withPath(path.replace("planks", "log")))).isPresent()) {
                ResourceLocation id2 = baseRes.withPath(path.replace("wood/planks/", ""));
                return Optional.of(new WoodType(id2, baseBlock, (Block)log.get()));
            }
            return Optional.empty();
        }
        if (path.endsWith("_planks")) {
            name = path.substring(0, path.length() - "_planks".length());
        } else if (path.startsWith("planks_")) {
            name = path.substring("planks_".length());
        } else if (path.endsWith("_plank")) {
            name = path.substring(0, path.length() - "_plank".length());
        } else if (path.startsWith("plank_")) {
            name = path.substring("plank_".length());
        }
        String namespace = baseRes.getNamespace();
        if (name != null && !IGNORED_MODS.contains(namespace) && (state = baseBlock.defaultBlockState()).getProperties().size() <= 2 && !(baseBlock instanceof SlabBlock) && (logBlock = WoodTypeRegistry.findLog(id = baseRes.withPath(name = name.replace("/", "_")))) != null) {
            return Optional.of(new WoodType(id, baseBlock, logBlock));
        }
        return Optional.empty();
    }

    @Nullable
    private static Block findLog(ResourceLocation id) {
        List<String> keywords = List.of("log", "stem", "stalk", "hyphae");
        ArrayList<ResourceLocation> resources = new ArrayList<ResourceLocation>();
        for (String keyword : keywords) {
            resources.add(id.withPath(id.getPath() + "_" + keyword));
            resources.add(id.withPath(keyword + "_" + id.getPath()));
            resources.add(ResourceLocation.parse((String)(id.getPath() + "_" + keyword)));
            resources.add(ResourceLocation.parse((String)(keyword + "_" + id.getPath())));
        }
        ResourceLocation[] test = resources.toArray(new ResourceLocation[0]);
        Block temp = null;
        for (ResourceLocation r : test) {
            if (!BuiltInRegistries.BLOCK.containsKey(r)) continue;
            temp = (Block)BuiltInRegistries.BLOCK.get(r);
            break;
        }
        return temp;
    }

    @Override
    public void addTypeTranslations(AfterLanguageLoadEvent language) {
        this.getValues().forEach(w -> {
            if (language.isDefault()) {
                language.addEntry(w.getTranslationKey(), w.getReadableName());
            }
        });
    }

    @Nullable
    public WoodType getFromVanilla(net.minecraft.world.level.block.state.properties.WoodType woodType) {
        return this.fromVanilla.get(woodType);
    }

    @Override
    protected void finalizeAndFreeze() {
        for (WoodType w : this.builder) {
            net.minecraft.world.level.block.state.properties.WoodType vanilla = w.toVanilla();
            if (vanilla == null) continue;
            this.fromVanilla.put(vanilla, w);
        }
        ArrayList temp = new ArrayList(this.builder);
        this.builder.clear();
        block1: for (net.minecraft.world.level.block.state.properties.WoodType v : VANILLA_ORDER) {
            for (WoodType t : temp) {
                if (t.toVanilla() != v) continue;
                this.builder.add(t);
                temp.remove(t);
                continue block1;
            }
        }
        this.builder.addAll(temp);
        super.finalizeAndFreeze();
    }
}

